interface Window {
    getTime(): number;
    mozRequestAnimationFrame(): number;
    webkitRequestAnimationFrame(): number;
    createCanvas(width: number, height: number): HTMLCanvasElement;
}
interface CommonOffset {
    x: number;
    y: number;
}
interface CommonSize {
    w: number;
    h: number;
}
class Rectangle {
    public left: number;
    public top: number;
    public right: number;
    public bottom: number;
    constructor (left?: number, top?: number, right?: number, bottom?: number);
    public hitTest(point: CommonOffset): bool;
}
class Area {
    public x: number;
    public y: number;
    public width: number;
    public height: number;
    constructor (x: number, y: number, width: number, height: number);
}
class Easing {
    static LINEAR(t, b, c, d);
    static SWING(t, b, c, d);
    static QUAD_EASEIN(t, b, c, d);
    static QUAD_EASEOUT(t, b, c, d);
    static QUAD_EASEINOUT(t, b, c, d);
    static CUBIC_EASEIN(t, b, c, d);
    static CUBIC_EASEOUT(t, b, c, d);
    static CUBIC_EASEINOUT(t, b, c, d);
    static QUART_EASEIN(t, b, c, d);
    static QUART_EASEOUT(t, b, c, d);
    static QUART_EASEINOUT(t, b, c, d);
    static QUINT_EASEIN(t, b, c, d);
    static QUINT_EASEOUT(t, b, c, d);
    static QUINT_EASEINOUT(t, b, c, d);
    static SIN_EASEIN(t, b, c, d);
    static SIN_EASEOUT(t, b, c, d);
    static SIN_EASEINOUT(t, b, c, d);
    static CIRC_EASEIN(t, b, c, d);
    static CIRC_EASEOUT(t, b, c, d);
    static CIRC_EASEINOUT(t, b, c, d);
    static ELASTIC_EASEIN(t, b, c, d, a, p);
    static ELASTIC_EASEOUT(t, b, c, d, a, p);
    static ELASTIC_EASEINOUT(t, b, c, d, a, p);
    static BOUNCE_EASEOUT(t, b, c, d);
    static BOUNCE_EASEIN(t, b, c, d);
    static BOUNCE_EASEINOUT(t, b, c, d);
    static BACK_EASEIN(t, b, c, d, s);
    static BACK_EASEOUT(t, b, c, d, s);
    static BACK_EASEINOUT(t, b, c, d, s);
    static EXPO_EASEIN(t, b, c, d);
    static EXPO_EASEOUT(t, b, c, d);
    static EXPO_EASEINOUT(t, b, c, d);
}
var ENTITY_OPTIONS_DEFAULT_VALUES: {
    rotate: number;
    translate: {
        x: number;
        y: number;
    };
    transform: {
        m11: number;
        m12: number;
        m21: number;
        m22: number;
        dx: number;
        dy: number;
    };
    scale: {
        x: number;
        y: number;
    };
    globalAlpha: any;
    font: any;
    fillStyle: any;
    strokeStyle: any;
    lineCap: any;
    lineJoin: any;
    lineWidth: any;
    miterLimit: any;
    shadowBlur: any;
    shadowColor: any;
    shadowOffsetX: any;
    shadowOffsetY: any;
    textAlign: any;
    textBaseline: any;
};
class E {
    public x: number;
    public y: number;
    public width: number;
    public height: number;
    public _tl: Timeline;
    public scene: Scene;
    public parent: E;
    public active_queue: Function[];
    public started: bool;
    public isUpdated: bool;
    public disableTransform: bool;
    public entities: E[];
    public pointCapture: bool;
    public inputDown: Trigger;
    public inputUp: Trigger;
    public inputMove: Trigger;
    public options: Object;
    constructor ();
    public enablePointingEvent(): void;
    public disablePointingEvent(): void;
    public removeDrawOption(name: string): void;
    public setDrawOption(name: string, value: any): void;
    public getDrawOption(name: string): any;
    public moveTo(x: number, y: number): void;
    public moveBy(x: number, y: number): void;
    public activate(): void;
    public addActiveQueue(f: Function): void;
    public appendTo(scene: Scene, layerName?: string): void;
    public remove(): void;
    public append(entity: E): void;
    public removeChild(entity: E): bool;
    public start(): void;
    public stop(): void;
    public startTimer(wait: number, method?: Function): void;
    public stopTimer(wait: number, method?: Function): void;
    public updated(): void;
    public isUpdate(): bool;
    public reflected(): void;
    public tl(): Timeline;
    public destroy(): void;
    public offset(): CommonOffset;
    public rect(): Rectangle;
    public hitTest(point: CommonOffset): bool;
    public getEntityByPoint(point: CommonOffset): E;
    public update(t: number): void;
    public interval(): void;
    public draw(area: Area, context: CanvasRenderingContext2D): void;
}
enum ShapeStyle {
    stroke,
    fill,
}
enum ShapeType {
    rect,
    arc,
}
class Shape extends E {
    public style: ShapeStyle;
    public type: ShapeType;
    constructor (width: number, height: number, style?: ShapeStyle, color?: string, type?: ShapeType);
    public setStyle(style: ShapeStyle): void;
    public setLineWidth(width: number): void;
    public getLineWidth();
    public setColor(color: string): void;
    public getColor();
    public draw(area: Area, context: CanvasRenderingContext2D): void;
}
interface TriggerHandler {
    owner: any;
    handler: Function;
}
class Trigger {
    public handlers: TriggerHandler[];
    constructor ();
    public handleInsert(index: number, owner: any, handler: Function): void;
    public handle(owner: any, handler?: Function): void;
    public destroy(): void;
    public removeAll(owner: any): void;
    public removeAllByHandler(handler: Function): void;
    public remove(owner: any, handler?: Function): void;
    public fire(param?: any): void;
    public fastFire(param?: any): void;
}
class Resource {
    public images: {
        [key: string]: HTMLImageElement;
    };
    public requests: any[];
    public loaded: Trigger;
    static instance: Resource;
    static getInstance(): Resource;
    constructor ();
    public get(name: string): HTMLImageElement;
    public loadImage(url: string, identifier: string, caller: any, callback?: (string: any, HTMLImageElement: any, bool: any) => void): void;
    public loadImageComplete(name: string, image: HTMLImageElement, is_success: bool): void;
    public load(name: string, url?: string): void;
}
class Scene {
    public layers: {
        [key: string]: Layer;
    };
    public layerCount: number;
    public game: Game;
    public mode: string[];
    public showed: Trigger;
    public hid: Trigger;
    public ended: Trigger;
    public started: Trigger;
    constructor (game: Game);
    public currentMode(): string;
    public getLayerArray(): Layer[];
    public enablePointingEvent(): void;
    public disablePointingEvent(): void;
    public changeMode(mode: string): void;
    public endCurrentMode(newMode?: string): void;
    public createLayer(name: string): Layer;
    public deleteLayer(name: string): void;
    public destroy(): void;
    public end(): void;
    public refresh(): void;
    public scrollTo(x: number, y: number, layerName?: string): void;
    public scrollBy(x: number, y: number, layerName?: string): void;
    public append(entity: E, layerName?: string): void;
    public removeEntity(entity: E): void;
}
class Sprite extends E {
    public image: any;
    public sep: number;
    public frame: number[];
    public fno: number;
    constructor (width: number, height: number, image?: any);
    public draw(area: Area, context: CanvasRenderingContext2D): void;
    public refresh(): void;
}
enum Angle {
    left,
    right,
    up,
    down,
}
interface CharacterMoveInfo {
    x: number;
    y: number;
    dx: number;
    dy: number;
    f: number;
    t: number;
}
interface CharacterMovedEventArgs {
    nextMove?: string;
}
class Character extends Sprite {
    public moving: bool;
    public moveInfo: CharacterMoveInfo;
    public nextMove: string;
    public moved: Trigger;
    public charaSeq: number;
    public charaCol: number;
    public animeCnt: number;
    public movePixel: number;
    public moveTime: number;
    constructor (width: number, height: number, image: HTMLImageElement, wait?: number);
    public moveLeft(stackNext?: bool): bool;
    public moveRight(stackNext?: bool): bool;
    public moveUp(stackNext?: bool): bool;
    public moveDown(stackNext?: bool): bool;
    public move(x: number, y: number, f: number): bool;
    public update(t: number): void;
    public endMove(): void;
    public angle(angle: Angle): void;
    public interval(): void;
}
class CharacterFactory {
    public charaCol: number;
    public animeCnt: number;
    public movePixel: number;
    public moveTime: number;
    public image: HTMLImageElement;
    public width: number;
    public height: number;
    public wait: number;
    public angle: Angle;
    public createClass: any;
    constructor (width: number, height: number, image: HTMLImageElement);
    public create(charaSeq: number, offset?: CommonOffset, angle?: Angle): Character;
}
class Label extends E {
    public text: string;
    public maxWidth: number;
    constructor (text?: string, fontSize?: number, fontColor?: string, baseline?: string);
    public setMaxWidth(maxWidth: number): void;
    public updateSize(): void;
    public addShadow(color?: string): void;
    public removeShadow(): void;
    public setText(text: string): void;
    public setFont(fontString: string): void;
    public getFont(): string;
    public setFontSize(size: number): void;
    public getFontSize(): number;
    public setTextAlign(align: string): void;
    public getTextAlign(): string;
    public setTextBaseline(baseline: string): void;
    public getTextBaseline(): string;
    public setColor(color: string): void;
    public getColor(): string;
    public draw(area: Area, context: CanvasRenderingContext2D): void;
}
class Tile extends E {
    public tileWidth: number;
    public tileHeight: number;
    public image: HTMLImageElement;
    public canvas: HTMLCanvasElement;
    public data: number[][];
    public sep: number;
    public chipCount: CommonSize;
    constructor (tileWidth: number, tileHeight: number, image?: HTMLImageElement);
    public generate(data: number[][], width?: number, height?: number): void;
    public refresh(): void;
    public draw(area: Area, context: CanvasRenderingContext2D): void;
}
class Layer extends E {
    public canvas: HTMLCanvasElement;
    public context: CanvasRenderingContext2D;
    constructor (scene: Scene);
    public hasBuffer(): bool;
    public createBuffer(): void;
    public refresh(must?: bool): void;
    public deleteBuffer(): void;
    public destroy(): void;
}
class LoadingScene extends Scene {
    public resource: Resource;
    public shape: Shape;
    public shapeP: Shape;
    public requestCount: number;
    constructor (game: Game, resource: Resource);
    public complete(cnt: number): void;
}
enum InputEventType {
    Keyboard,
    Point,
}
enum Keytype {
    left,
    right,
    up,
    down,
    enter,
    esc,
}
class InputEvent {
    public type: InputEventType;
    public param: any;
    constructor (type: InputEventType, param?: any);
}
class InputKeyboardEvent extends InputEvent {
    public key: Keytype;
    constructor (key: Keytype);
}
class InputPointEvent extends InputEvent {
    public x: number;
    public y: number;
    public point: CommonOffset;
    public entity: E;
    constructor (e: any, entity: E);
}
class Renderer {
    public radian: number;
    public drawOptionFunctions: Object;
    constructor ();
    public getMatrix(width: number, height: number, scaleX: number, scaleY: number, angle: number): number[];
    public renderParent(parent: E, c: CanvasRenderingContext2D, area?: Area): void;
    public renderEntity(area: Area, entity: E, c: CanvasRenderingContext2D): void;
    public useDrawOption(entity: E, c: CanvasRenderingContext2D): void;
}
enum RenderTransferMode {
    Transfer,
    Flip,
    Direct,
}
class GameRenderer extends Renderer {
    public buffer: HTMLCanvasElement[];
    public fc: CanvasRenderingContext2D;
    public bc: CanvasRenderingContext2D;
    public scene: Scene;
    public game: Game;
    public bg: ImageData;
    public container: HTMLElement;
    public flipNo: number;
    public transferMode: RenderTransferMode;
    public disableClear: bool;
    constructor (game: Game, container?: HTMLElement, transferMode?: RenderTransferMode);
    public changeTransferMode(mode: RenderTransferMode): void;
    public changeScene(scene: Scene): void;
    public flip(): void;
    public render(): void;
    public refresh(): void;
}
class BufferedRenderer extends Renderer {
    public buffer: HTMLCanvasElement;
    public c: CanvasRenderingContext2D;
    public size: CommonSize;
    constructor (size: CommonSize);
    public clear(): void;
    public createSprite(area: Area): Sprite;
    public renderUnit(entity: E): void;
    public renderLayer(layer: Layer): void;
    public renderScene(scene: Scene): void;
    public refresh(): void;
}
class GameTimer {
    public tick: number;
    public wait: number;
    public trigger: Trigger;
    constructor (wait: number);
    public tryFire(t: number): void;
    public fire(t: number): void;
}
class Game {
    public _exit: bool;
    public tick: number;
    public renderTick: number;
    public keymap: Object;
    public renderer: GameRenderer;
    public scenes: Scene[];
    public currentScene: Scene;
    public resource: Resource;
    public width: number;
    public height: number;
    public targetFps: number;
    public fps: HTMLElement;
    public loaded: Trigger;
    public update: Trigger;
    public timers: GameTimer[];
    public render: Trigger;
    public inputDown: Trigger;
    public inputUp: Trigger;
    public inputMove: Trigger;
    public onmousedown: any;
    public onmousemove: any;
    public onmouseup: any;
    public enterFrame: Trigger;
    public enterFrameTick: number;
    constructor (width: number, height: number);
    public refresh(): void;
    public isTouchEnable(): bool;
    public pointHandler(): void;
    public keyboardHandler(): void;
    public addTimer(wait: number, owner: any, handler: Function): void;
    public removeTimer(wait: number, owner: any, handler: Function): void;
    public removeTimerAll(owner: any): void;
    public exit(): void;
    public changeScene(scene: Scene): void;
    public endScene(): void;
    public r(name: string): HTMLImageElement;
    public preloadArray(ary: string[], loadingScene?: LoadingScene): void;
    public preload(ary: {
        [key: string]: string;
    }, loadingScene?: Scene): void;
    public preloadComplete(cnt: number): void;
    public main(): void;
}
class FrameGame extends Game {
    public _fps: number;
    constructor (width: number, height: number, fps: number);
    public main(): void;
}
interface ActionEventArgs {
    timeline: Timeline;
}
interface ActionTickEventArgs {
    timeline: Timeline;
    elapsed: number;
}
class Action {
    public time: number;
    public frame: number;
    public added_to_timeline: Trigger;
    public removed_from_timeline: Trigger;
    public action_tick: Trigger;
    public action_start: Trigger;
    public action_end: Trigger;
    public timeline: Timeline;
    public entity: E;
    constructor (param?: any);
    public removedFromTimeline(): void;
    public addedToTimeline(p: ActionEventArgs): void;
    public actionTick(p: ActionTickEventArgs): void;
}
class ParallelAction extends Action {
    public actions: Action[];
    public endedActions: Action[];
    constructor (param?: any);
    public addedToTimeline(p: ActionEventArgs): void;
    public removedFromTimeline(): void;
    public actionTick(evt: ActionTickEventArgs): void;
    public parallelActionStart(e: any): void;
}
var TWEEN_DRAW_OPTION_SETTERS: {};
class Tween extends Action {
    public origin: any;
    public target: any;
    public old: any;
    public easing: Function;
    public props: Object;
    constructor (params: any);
    public actionStart(e: any): void;
    public tweenActionTick(e: any): void;
}
class Timeline {
    public entity: E;
    public queue: Action[];
    public paused: bool;
    public looped: bool;
    public _activated: bool;
    public _parallel: ParallelAction;
    public isFrameBased: bool;
    constructor (entity: E);
    public _deactivateTimeline(force?: bool): void;
    public _activateTimeline(force?: bool): void;
    public setFrameBased(): void;
    public setTimeBased(): void;
    public next(remainingTime?: number): void;
    public tick(t: number): void;
    public add(action: Action): Timeline;
    public action(params: any): Timeline;
    public tween(params: any): Timeline;
    public clear(): Timeline;
    public skip(frames: number): Timeline;
    public pause(): Timeline;
    public resume(): Timeline;
    public loop(): Timeline;
    public unloop(): Timeline;
    public delay(time: number): Timeline;
    public then(func: Function): Timeline;
    public exec(func: Function): void;
    public cue(cue: any): void;
    public repeat(func: Function, time: number): Timeline;
    public and(): Timeline;
    public waitUntil(func: Function): Timeline;
    public moveTo(x: number, y: number, time: number, easing?: Function): Timeline;
    public moveX(x: number, time: number, easing?: Function): Timeline;
    public moveY(y: number, time: number, easing?: Function): Timeline;
    public moveBy(x: number, y: number, time: number, easing?: Function): Timeline;
    public fadeTo(opacity: number, time: number, easing?: Function): Timeline;
    public fadeIn(time: number, easing?: Function): Timeline;
    public fadeOut(time: number, easing?: Function): Timeline;
    public hide(): Timeline;
    public show(): Timeline;
    public scaleTo(scale: number, time: number, easing?: any): Timeline;
    public scaleBy(scale: number, time: number, easing?: any): Timeline;
    public rotateTo(deg: number, time: number, easing?: Function): Timeline;
    public rotateBy(deg: number, time: number, easing?: Function): Timeline;
    public removeFromScene(): Timeline;
}
