//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXShellMailTo.h
 * @brief		mailto⏕NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXShellMailTo_H_
#define _IRIS_WXShellMailTo_H_

//======================================================================
// include
#include "iris_object.h"
#include <vector>
#include <string>

namespace iris {
namespace wx
{

//======================================================================
// class
//! mailto⏕NX
class CMailTo : public IIrisObject
{
	typedef std::vector<std::_tstring>	strlist;
private:
	strlist	m_To;		//!< to
	strlist	m_Cc;		//!< cc
	strlist	m_Bcc;		//!< bcc
public:
	// RXgN^
	CMailTo(void);
	// fXgN^
	~CMailTo(void);
	
public:
	// s
	void	MailTo(HWND hWnd, LPCTSTR lpSubject, LPCTSTR lpBody, int nShowCmd);

public:
	/// Toǉ
	void	AddTo(LPCTSTR lpString)		{ Add(m_To , lpString); }
	/// Ccǉ
	void	AddCc(LPCTSTR lpString)		{ Add(m_Cc , lpString); }
	/// Bccǉ
	void	AddBcc(LPCTSTR lpString)	{ Add(m_Bcc, lpString); }

	/// ToNA
	void	ClearTo(void)	{ Clear(m_To); }
	/// CcNA
	void	ClearCc(void)	{ Clear(m_Cc); }
	/// BccNA
	void	ClearBcc(void)	{ Clear(m_Bcc); }

private:
	// ǉ
	void	Add(strlist& rList, LPCTSTR lpString)	{ rList.push_back(lpString); }
	// NA
	void	Clear(strlist& rList)					{ rList.clear(); }
};

}	// end of namespace wx
}	// end of namespace iris

#endif
