//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXShellAbout.cpp
 * @brief		Shello[W_CAOt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXShellAbout_CPP_

//======================================================================
// include
#include <string>
#include <tchar.h>
#include "WXShellAbout.h"

#include "../debug/WXDebug.h"
#include "../debug/WXDebugLeakCheckMacro.h"

//======================================================================
// link
#pragma comment( lib, "shlwapi.lib" )

namespace iris {
namespace wx
{

//======================================================================
// define
#ifndef VERSIONDLG_SEPARATOR_CHAR
	#define VERSIONDLG_SEPARATOR_CHAR	TEXT('-')
#endif
#ifndef VERSIONDLG_SEPARATOR_CHARNUM
	#define VERSIONDLG_SEPARATOR_CHARNUM	(30)
#endif

#define NL								TEXT("\n")

//======================================================================
// declare
static void _VersionDlg_MakeComment(CVersionInfo& vi, std::_tstring& str, int table[]);

/**********************************************************************//**
 *
 * ShellAboutĂяo
 *
 ----------------------------------------------------------------------
 * @param [in]	hParent	= eEBhEnh
 * @param [in]	AppName	= AvP[V
 * @param [in]	Comment	= Rg
 * @param [in]	hIcon	= ACR
 * @return	
*//***********************************************************************/
int	WinShellAbout (HWND hParent, LPCTSTR AppName, LPCTSTR Comment, HICON hIcon)
{
	return ShellAbout(hParent, AppName, Comment, hIcon);
}
/// iris::wx::WinShellAbout Q
int	WinShellAboutA(HWND hParent, LPCSTR  AppName, LPCSTR  Comment, HICON hIcon)
{
	return ShellAboutA(hParent, AppName, Comment, hIcon);
}
/// iris::wx::WinShellAbout Q
int	WinShellAboutW(HWND hParent, LPCWSTR AppName, LPCWSTR Comment, HICON hIcon)
{
	return ShellAboutW(hParent, AppName, Comment, hIcon);
}

/**********************************************************************//**
 *
 * ShellAboutĂяo
 *  VersionInfo\[XeLXgݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hParent	= eEBhEnh
 * @param [in]	nFlags	= \eLXgtOiVERSIONDLG_MASKj
 * @param [in]	hIcon	= ACR
 * @return	
*//***********************************************************************/
int	WinShellAboutVersionInfo(HWND hParent, int nMask, HICON hIcon)
{
	int id_table[CVersionInfo::TERM];
	int c=0;
	for( int i=0; i < CVersionInfo::TERM; ++i )
	{
		if( nMask & (1<<i) )
		{
			id_table[c++] = i;
		}
	}
	id_table[c] = VERDLG_MASK_TERM;
	return WinShellAboutVersionInfoEx(hParent, id_table, hIcon);
}

/**********************************************************************//**
 *
 * ShellAboutĂяo
 *  VersionInfo\[XeLXgݒ
 *
 * @note	VERDLG_MASK_SEPARATOR, VERDLG_MASK_RETURNw\
 *
 ----------------------------------------------------------------------
 * @param [in]	hParent		= eEBhEnh
 * @param [in]	id_table	= \eLXgtOi VERSIONDLG_ID ̔zAI[ VERDLG_ID_TERM j
 * @param [in]	hIcon		= ACR
 * @return	
*//***********************************************************************/
int	WinShellAboutVersionInfoEx(HWND hParent, int id_table[], HICON hIcon)
{
	CVersionInfo vi;
	if( !vi.Open() )
	{
		IRIS_WARNING( "VERSIONINFO܂B" );
		return 0;
	}

	LPTSTR pFileName;
	LPTSTR pVersion;
	if( vi.GetProductName(&pFileName) == 0 ) return 0;
	if( vi.GetProductVersion(&pVersion) == 0 ) return 0;
	// AppName
	std::_tstring app = TEXT("Version information on \"");
	app += pFileName;
	app += TEXT("\"");
	app += NL;
	// Version
	std::_tstring ver = pVersion;
	LPTSTR p = (LPTSTR)_tcschr( ver.c_str(), TEXT(','));
	while( p )
	{
		*p = TEXT('.');	// .ɒ
		p = _tcschr( p, TEXT(','));
	}
	app += TEXT("#");
	app += pFileName;
	app += TEXT(" Version ");
	app += ver.c_str();
	// Comment
	std::_tstring comm;
	_VersionDlg_MakeComment(vi, comm, id_table);

	return ShellAbout(hParent, app.c_str(), comm.c_str(), hIcon);
}

//**********************************************************************
//
//	̐
//
//**********************************************************************
void _VersionDlg_MakeComment(CVersionInfo& vi, std::_tstring& str, int table[])
{
	str = TEXT("");
	int *tbl = table;
	for( ; *tbl != VERDLG_MASK_TERM; ++tbl)
	{
		int id = *tbl;
		switch( id )
		{
		case VERDLG_ID_SEPARATOR:
			{
				for( int i=0; i < VERSIONDLG_SEPARATOR_CHARNUM; ++i )
					str += VERSIONDLG_SEPARATOR_CHAR;
				str += NL;
			}
			break;
		case VERDLG_ID_RETURN:
			str += NL;
			break;
		default:
			{
				LPTSTR txt;
				if( vi.GetStringFileInfoFromID(id,&txt) )
				{
					str += txt;
					str += NL;
				}
			}
			break;
		}
	}
}

}	// end of namespace wx
}	// end of namespace iris
