//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXCSIDL.h
 * @brief		CSIDL t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXCSIDL_H_
#define _IRIS_WXCSIDL_H_

//======================================================================
// include
#include "iris_object.h"
#include <shlobj.h>

namespace iris {
namespace wx
{

//======================================================================
// decalre
class CCSIDLPathA;
class CCSIDLPathW;

//======================================================================
// typedef
#ifdef UNICODE
typedef CCSIDLPathW	CCSIDLPath;
#else
typedef CCSIDLPathA	CCSIDLPath;
#endif

//======================================================================
// class
/// CSIDL Path NX
class CCSIDLPathA : public IIrisObject
{
	CHAR	m_Path[MAX_PATH];
public:
	// RXgN^
	explicit CCSIDLPathA(int CSIDL);
public:
	operator LPSTR	(void)		{ return m_Path; }
	operator LPCSTR (void)		{ return m_Path; }
	CHAR operator [] (int idx)	{ return m_Path[idx]; }
};

/// CSIDL Path NX
class CCSIDLPathW : public IIrisObject
{
	WCHAR	m_Path[MAX_PATH];
public:
	// RXgN^
	explicit CCSIDLPathW(int CSIDL);
public:
	operator LPWSTR	(void)		{ return m_Path; }
	operator LPCWSTR (void)		{ return m_Path; }
	WCHAR operator [] (int idx)	{ return m_Path[idx]; }
};

}	// end of namespace wx
}	// end of namespace iris

#endif
