//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXAppBar.cpp
 * @brief		AvP[Vo[NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXAppBar_CPP_

//======================================================================
// include
#include "WXAppBar.h"
#include <shlwapi.h>

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CAppBar::CAppBar(void)
{
	m_Data.cbSize = sizeof(m_Data);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CAppBar::~CAppBar(void)
{
}

/**********************************************************************//**
 *
 * 쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd				= AvP[Vo[ɂEBhEnh
 * @param [in]	uCallbackMessage	= hWndɑMR}hbZ[W
 * @param [in]	uEdge				= 
 * @param [in]	lParam				= 
 * @return	
*//***********************************************************************/
BOOL CAppBar::Create(HWND hWnd, UINT uCallbackMessage, UINT uEdge, LPARAM lParam)
{
	Destroy();
	m_Data.hWnd				= hWnd;
	m_Data.uCallbackMessage	= uCallbackMessage;
	m_Data.uEdge			= uEdge;
	m_Data.lParam			= lParam;
	return (BOOL)(Message(ABM_NEW));
}

/**********************************************************************//**
 *
 * 폜
 *
 ----------------------------------------------------------------------
 * @return 
*//***********************************************************************/
UINT_PTR CAppBar::Destroy(void)
{
	if( m_Data.hWnd == nullptr ) return 0;
	UINT_PTR ret = Message(ABM_REMOVE);
	m_Data.hWnd = nullptr;
	return ret;
}

/**********************************************************************//**
 *
 * bZ[WM
 *
 ----------------------------------------------------------------------
 * @return 
*//***********************************************************************/
UINT_PTR CAppBar::Message(DWORD dwMessage)
{
	return SHAppBarMessage(dwMessage, &m_Data);
}
UINT_PTR CAppBar::GetState(void)			{ return Message(ABM_GETSTATE); }
UINT_PTR CAppBar::Activate(BOOL activate)	{ m_Data.lParam = (LPARAM)activate; return Message(ABM_ACTIVATE); }

}	// end of namespace wx
}	// end of namespace iris
