//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXActiveDesktop.cpp
 * @brief		ANeBufXNgbvNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXActiveDesktop_CPP_

//======================================================================
// include
#include "WXActiveDesktop.h"
#include <stdio.h>
#include "../wx_inchead.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CActiveDesktop::CActiveDesktop(void)
: m_pAD(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CActiveDesktop::~CActiveDesktop(void)
{
	Release();
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CActiveDesktop::Initialize(void)
{
	HRESULT hr = S_OK;
	if( !IsInit() )
	{
		hr = CoInitialize();
		if( FAILED(hr) ) return FALSE;
	}
	hr = CoCreateInstance(CLSID_ActiveDesktop, nullptr, CLSCTX_INPROC_SERVER,
								IID_IActiveDesktop, (LPVOID*)&m_pAD);
	if( FAILED(hr) )
	{
		puts("failed CoCreateInstance.");
		return FALSE;
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
void CActiveDesktop::Release(void)
{
	IRIS_SAFE_RELEASE(m_pAD);
}

/**********************************************************************//**
 *
 * ANeBx[g
 *
 ----------------------------------------------------------------------
 * @param [in]	bComponents		= 
 * @param [in]	bActiveDesktop	= 
 * @return	
*//***********************************************************************/
HRESULT CActiveDesktop::Activate(BOOL bComponents, BOOL bActiveDesktop)
{
	if( m_pAD == nullptr ) return S_FALSE;
	COMPONENTSOPT comopt;
	comopt.dwSize = sizeof(comopt);
	//m_pAD->GetDesktopItemOptions(&comopt, 0);
	comopt.fEnableComponents = bComponents;
	comopt.fActiveDesktop	 = bActiveDesktop;
	return m_pAD->SetDesktopItemOptions(&comopt, 0);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	dwFlags		= AD_APPLY_***
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::ApplyChanges(DWORD dwFlags)
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->ApplyChanges(dwFlags);
}

/**********************************************************************//**
 *
 * ǎt@C̃pX擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszWallpaper	= ǎt@C̃pX
 * @param [in]	cchWallpaper	= lpszWallpaper̃obt@TCY
 * @param [in]	dwReserved		= 
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::GetWallpaper (LPTSTR lpszWallpaper, UINT cchWallpaper, DWORD dwReserved)
{
#ifdef UNICODE
	return GetWallpaperW(lpszWallpaper, cchWallpaper, dwReserved);
#else
	return GetWallpaperA(lpszWallpaper, cchWallpaper, dwReserved);
#endif
}
/// CActiveDesktop::GetWallpaper Q
HRESULT	CActiveDesktop::GetWallpaperA(LPSTR  lpszWallpaper, UINT cchWallpaper, DWORD dwReserved)
{
	if( m_pAD == nullptr ) return S_FALSE;
	WCHAR szWallpaper[MAX_PATH];
	HRESULT hr = m_pAD->GetWallpaper(szWallpaper, MAX_PATH, dwReserved);
	if( FAILED(hr) ) return hr;
	WideCharToMultiByte(CP_THREAD_ACP, 0, szWallpaper, -1, lpszWallpaper, cchWallpaper, nullptr, nullptr);
	return hr;
}
/// CActiveDesktop::GetWallpaper Q
HRESULT	CActiveDesktop::GetWallpaperW(LPWSTR lpszWallpaper, UINT cchWallpaper, DWORD dwReserved)
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->GetWallpaper(lpszWallpaper, cchWallpaper, dwReserved);
}

/**********************************************************************//**
 *
 * ǎt@C̃pXݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszWallpaper	= ǎt@C̃pX
 * @param [in]	dwReserved		= 
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::SetWallpaper (LPCTSTR lpszWallpaper, DWORD dwReserved)
{
#ifdef UNICODE
	return SetWallpaperW(lpszWallpaper, dwReserved);
#else
	return SetWallpaperA(lpszWallpaper, dwReserved);
#endif
}
/// CActiveDesktop::SetWallpaper Q
HRESULT	CActiveDesktop::SetWallpaperA(LPCSTR  lpszWallpaper, DWORD dwReserved)
{
	if( m_pAD == nullptr ) return S_FALSE;
	int size = MultiByteToWideChar(CP_THREAD_ACP,  0, lpszWallpaper, -1, nullptr, 0);
	LPWSTR pwszTemp = new WCHAR [size+1];
	MultiByteToWideChar(CP_THREAD_ACP,  0, lpszWallpaper, -1, pwszTemp, size+1);
	HRESULT hr = m_pAD->SetWallpaper(pwszTemp, dwReserved);
	delete [] pwszTemp;
	return hr;
}
/// CActiveDesktop::SetWallpaper Q
HRESULT	CActiveDesktop::SetWallpaperW(LPCWSTR lpszWallpaper, DWORD dwReserved)
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->SetWallpaper(lpszWallpaper, dwReserved);
}

/**********************************************************************//**
 *
 * ǎ̃IvVݒ擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpwpo			= ݒ
 * @param [in]	dwReserved		= 
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::GetWallpaperOptions(LPWALLPAPEROPT lpwpo, DWORD dwReserved)
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->GetWallpaperOptions(lpwpo, dwReserved);
}

/**********************************************************************//**
 *
 * ǎ̃IvVݒݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpwpo			= ݒ
 * @param [in]	dwReserved		= 
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::SetWallpaperOptions(LPCWALLPAPEROPT lpwpo, DWORD dwReserved)
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->SetWallpaperOptions(lpwpo, dwReserved);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszPattern		= 
 * @param [in]	cchPattern		= lpszPatterñobt@TCY
 * @param [in]	dwReserved		= 
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::GetPattern (LPTSTR lpszPattern, UINT cchPattern, DWORD dwReserved)
{
#ifdef UNICODE
	return GetPatternW(lpszPattern, cchPattern, dwReserved);
#else
	return GetPatternA(lpszPattern, cchPattern, dwReserved);
#endif
}
/// CActiveDesktop::GetPattern Q
HRESULT	CActiveDesktop::GetPatternA(LPSTR  lpszPattern, UINT cchPattern, DWORD dwReserved)
{
	if( m_pAD == nullptr ) return S_FALSE;
	WCHAR szTemp[1024];	// TODO:obt@H
	HRESULT hr = m_pAD->GetWallpaper(szTemp, 1024, dwReserved);
	if( FAILED(hr) ) return hr;
	WideCharToMultiByte(CP_THREAD_ACP, 0, szTemp, -1, lpszPattern, cchPattern, nullptr, nullptr);
	return hr;
}
/// CActiveDesktop::GetPattern Q
HRESULT	CActiveDesktop::GetPatternW(LPWSTR lpszPattern, UINT cchPattern, DWORD dwReserved)
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->GetPattern(lpszPattern, cchPattern, dwReserved);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszPattern		= 
 * @param [in]	dwReserved		= 
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::SetPattern (LPCTSTR lpszPattern, DWORD dwReserved)
{
#ifdef UNICODE
	return SetPatternW(lpszPattern, dwReserved);
#else
	return SetPatternA(lpszPattern, dwReserved);
#endif
}
/// CActiveDesktop::SetPattern Q
HRESULT	CActiveDesktop::SetPatternA(LPCSTR  lpszPattern, DWORD dwReserved)
{
	if( m_pAD == nullptr ) return S_FALSE;
	int size = MultiByteToWideChar(CP_THREAD_ACP,  0, lpszPattern, -1, nullptr, 0);
	LPWSTR pwszTemp = new WCHAR [size+1];
	MultiByteToWideChar(CP_THREAD_ACP,  0, lpszPattern, -1, pwszTemp, size+1);
	HRESULT hr = m_pAD->SetPattern(pwszTemp, dwReserved);
	delete [] pwszTemp;
	return hr;
}
/// CActiveDesktop::SetPattern Q
HRESULT	CActiveDesktop::SetPatternW(LPCWSTR lpszPattern, DWORD dwReserved)
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->SetPattern(lpszPattern, dwReserved);
}

/**********************************************************************//**
 *
 * IvVݒ擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpco			= ݒ
 * @param [in]	dwReserved		= 
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::GetDesktopItemOptions(LPCOMPONENTSOPT lpco, DWORD dwReserved)
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->GetDesktopItemOptions(lpco, dwReserved);
}

/**********************************************************************//**
 *
 * IvVݒݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpco			= ݒ
 * @param [in]	dwReserved		= 
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::SetDesktopItemOptions(LPCCOMPONENTSOPT lpco, DWORD dwReserved)
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->SetDesktopItemOptions(lpco, dwReserved);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	lpcomp			= 
 * @param [in]	dwReserved		= 
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::AddDesktopItem(LPCCOMPONENT lpcomp, DWORD dwReserved)
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->AddDesktopItem(lpcomp, dwReserved);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd			= 
 * @param [in]	lpcomp			= 
 * @param [in]	dwReserved		= 
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::AddDesktopItemWithUI(HWND hWnd, LPCOMPONENT lpcomp, DWORD dwReserved)
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->AddDesktopItemWithUI(hWnd, lpcomp, dwReserved);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	lpcomp			= 
 * @param [in]	dwFlags			= 
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::ModifyDesktopItem(LPCCOMPONENT lpcomp, DWORD dwFlags)
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->ModifyDesktopItem(lpcomp, dwFlags);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	lpcomp			= 
 * @param [in]	dwReserved		= 
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::RemoveDesktopItem(LPCCOMPONENT lpcomp, DWORD dwReserved)
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->RemoveDesktopItem(lpcomp, dwReserved);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	lpiCount		= 
 * @param [in]	dwReserved		= 
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::GetDesktopItemCount(LPINT lpiCount, DWORD dwReserved)
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->GetDesktopItemCount(lpiCount, dwReserved);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	nComponent		= 
 * @param [in]	lpcomp			= 
 * @param [in]	dwReserved		= 
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::GetDesktopItem(int nComponent, LPCOMPONENT lpcomp, DWORD dwReserved)
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->GetDesktopItem(nComponent, lpcomp, dwReserved);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	dwID			= 
 * @param [in]	lpcomp			= 
 * @param [in]	dwReserved		= 
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::GetDesktopItemByID(ULONG_PTR dwID, LPCOMPONENT lpcomp, DWORD dwReserved)
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->GetDesktopItemByID(dwID, lpcomp, dwReserved);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszFileName	= 
 * @param [in]	lpcomp			= 
 * @param [in]	dwReserved		= 
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::GenerateDesktopItemHtml (LPCTSTR lpszFileName, LPCOMPONENT lpcomp, DWORD dwReserved)
{
#ifdef UNICODE
	return GenerateDesktopItemHtmlW(lpszFileName, lpcomp, dwReserved);
#else
	return GenerateDesktopItemHtmlA(lpszFileName, lpcomp, dwReserved);
#endif
}
/// CActiveDesktop::GenerateDesktopItemHtml Q
HRESULT	CActiveDesktop::GenerateDesktopItemHtmlA(LPCSTR  lpszFileName, LPCOMPONENT lpcomp, DWORD dwReserved)
{
	if( m_pAD == nullptr ) return S_FALSE;
	int size = MultiByteToWideChar(CP_THREAD_ACP,  0, lpszFileName, -1, nullptr, 0);
	LPWSTR pwszTemp = new WCHAR [size+1];
	MultiByteToWideChar(CP_THREAD_ACP,  0, lpszFileName, -1, pwszTemp, size+1);
	HRESULT hr = m_pAD->GenerateDesktopItemHtml(pwszTemp, lpcomp, dwReserved);
	delete [] pwszTemp;
	return hr;
}
/// CActiveDesktop::GenerateDesktopItemHtml Q
HRESULT	CActiveDesktop::GenerateDesktopItemHtmlW(LPCWSTR lpszFileName, LPCOMPONENT lpcomp, DWORD dwReserved)
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->GenerateDesktopItemHtml(lpszFileName, lpcomp, dwReserved);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd			= 
 * @param [in]	lpszSource		= 
 * @param [in]	lpcomp			= 
 * @param [in]	dwFlags			= 
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::AddUrl (HWND hWnd, LPCTSTR lpszSource, LPCOMPONENT lpcomp, DWORD dwFlags)
{
#ifdef UNICODE
	return AddUrlW(hWnd, lpszSource, lpcomp, dwFlags);
#else
	return AddUrlA(hWnd, lpszSource, lpcomp, dwFlags);
#endif
}
/// CActiveDesktop::AddUrl Q
HRESULT	CActiveDesktop::AddUrlA(HWND hWnd, LPCSTR  lpszSource, LPCOMPONENT lpcomp, DWORD dwFlags)
{
	if( m_pAD == nullptr ) return S_FALSE;
	int size = MultiByteToWideChar(CP_THREAD_ACP,  0, lpszSource, -1, nullptr, 0);
	LPWSTR pwszTemp = new WCHAR [size+1];
	MultiByteToWideChar(CP_THREAD_ACP,  0, lpszSource, -1, pwszTemp, size+1);
	HRESULT hr = m_pAD->AddUrl(hWnd, pwszTemp, lpcomp, dwFlags);
	delete [] pwszTemp;
	return hr;
}
/// CActiveDesktop::AddUrl Q
HRESULT	CActiveDesktop::AddUrlW(HWND hWnd, LPCWSTR lpszSource, LPCOMPONENT lpcomp, DWORD dwFlags)
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->AddUrl(hWnd, lpszSource, lpcomp, dwFlags);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszSource		= 
 * @param [in]	lpcomp			= 
 * @param [in]	dwReserved		=
 * @return	HRESULTl
*//***********************************************************************/
HRESULT	CActiveDesktop::GetDesktopItemBySource (LPCTSTR lpszSource, LPCOMPONENT lpcomp, DWORD dwReserved)
{
#ifdef UNICODE
	return GetDesktopItemBySourceW(lpszSource, lpcomp, dwReserved);
#else
	return GetDesktopItemBySourceA(lpszSource, lpcomp, dwReserved);
#endif
}
/// CActiveDesktop::GetDesktopItemBySource Q
HRESULT	CActiveDesktop::GetDesktopItemBySourceA(LPCSTR  lpszSource, LPCOMPONENT lpcomp, DWORD dwReserved)
{
	if( m_pAD == nullptr ) return S_FALSE;
	int size = MultiByteToWideChar(CP_THREAD_ACP,  0, lpszSource, -1, nullptr, 0);
	LPWSTR pwszTemp = new WCHAR [size+1];
	MultiByteToWideChar(CP_THREAD_ACP,  0, lpszSource, -1, pwszTemp, size+1);
	HRESULT hr = m_pAD->GetDesktopItemBySource(pwszTemp, lpcomp, dwReserved);
	delete [] pwszTemp;
	return hr;
}
/// CActiveDesktop::GetDesktopItemBySource Q
HRESULT	CActiveDesktop::GetDesktopItemBySourceW(LPCWSTR lpszSource, LPCOMPONENT lpcomp, DWORD dwReserved)
{
	if( m_pAD == nullptr ) return S_FALSE;
	return m_pAD->GetDesktopItemBySource(lpszSource, lpcomp, dwReserved);
}

}	// end of namespace wx
}	// end of namespace iris
