//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXVersionInfo.h
 * @brief		o[Wt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXVersionInfo_H_
#define _IRIS_WXVersionInfo_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris {
namespace wx
{

//======================================================================
// class
//! o[W擾NX
class CVersionInfo : public INonCopyObject
{
public:
	typedef enum BLOCKID
	{
		COMPANYNAME = 0,	//!< Ж
		FILEDESCRIPTION,	//!< 
		FILEVERSION,		//!< t@Co[W
		INTERNALNAME,		//!< 
		LEGALCOPYRIGHT,		//!< 쌠
		ORIGINALFILENAME,	//!< t@C
		PRODUCTNAME,		//!< i
		PRODUCTVERSION,		//!< io[W
		COMMENTS,			//!< Rg
		LEGALTRADEMARKS,	//!< W
		PRIVATEBUILD,		//!< vCx[grh
		SPECIALBUILD,		//!< XyVrh
		TERM
	} BLOCKID;
protected:
	char*	m_pVI;		//!< 擾pobt@
	LPWORD	m_pWord;	//!< ǂݍ񂾌Zbg
	DWORD	m_Word;		//!< Zbg
public:
	// RXgN^
	CVersionInfo();
	// fXgN^
	virtual ~CVersionInfo();
public:
	// J
	bool	Open(void);
	bool	Open(LPCTSTR filename);

	// 
	void	Close(void);

public:
	// ݒ
	DWORD	GetWord(void)		{ return m_Word; }
	void	SetWord(DWORD w)	{ m_Word = w; }
	void	LoadWord(int idx)	{ m_Word = MAKELONG(m_pWord[idx+1], m_pWord[idx]); }

public:
	// Ж
	UINT	GetCompanyName(TCHAR** dst);
	// 
	UINT	GetFileDescription(TCHAR** dst);
	// t@Co[W
	UINT	GetFileVersion(TCHAR** dst);
	// 
	UINT	GetInternalName(TCHAR** dst);
	// 쌠
	UINT	GetLegalCopyright(TCHAR** dst);
	// t@C
	UINT	GetOriginalFileName(TCHAR** dst);
	// i
	UINT	GetProductName(TCHAR** dst);
	// io[W
	UINT	GetProductVersion(TCHAR** dst);
	// Rg
	UINT	GetComments(TCHAR** dst);
	// W
	UINT	GetLegalTrademarks(TCHAR** dst);
	// vCx[grh
	UINT	GetPrivateBuild(TCHAR** dst);
	// XyVrh
	UINT	GetSpecialBuild(TCHAR** dst);

	// ID擾
	UINT	GetStringFileInfoFromID(int nID, TCHAR** dst);

	// o[W𐔒lɕϊ
	int		GetVersionInt(void);
	int		GetVersionHex(void);

public:
	UINT	GetQueryValue(LPTSTR block_name, LPVOID* dst);
	UINT	GetStringFileInfo(LPTSTR block_name, LPVOID* dst);
};

}	// end of namespace wx
}	// end of namespace iris

#endif