//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXVersionInfo.cpp
 * @brief		o[Wt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXVersionInfo_CPP_

//======================================================================
// include
#include "WXVersionInfo.h"
#include <stdio.h>

#include "../debug/WXDebugLeakCheckMacro.h"

//======================================================================
// link
#pragma comment (lib,"version.lib")

namespace iris {
namespace wx
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CVersionInfo::CVersionInfo()
: m_pVI(nullptr)
, m_pWord(nullptr)
, m_Word(0)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CVersionInfo::~CVersionInfo()
{
	Close();
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CVersionInfo::Open(void)
{
	TCHAR name[MAX_PATH];
	GetModuleFileName(nullptr,name,MAX_PATH);
	return Open(name);
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	filename	= W[
 * @return	
*//***********************************************************************/
bool CVersionInfo::Open(LPCTSTR filename)
{
	DWORD handle;
	DWORD dwVerInfoSize = GetFileVersionInfoSize(filename, &handle);
	if( dwVerInfoSize <= 0 ) return false;
	m_pVI = new char [dwVerInfoSize];
	GetFileVersionInfo(filename,handle,dwVerInfoSize,m_pVI);
	// 擾Ă
	// m_pWord[0] == Zbg m_pWord[1] == LN^Zbg
	GetQueryValue(TEXT("\\VarFileInfo\\Translation"),(LPVOID*)&m_pWord);
	m_Word = MAKELONG( m_pWord[1], m_pWord[0] );
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CVersionInfo::Close(void)
{
	// m_pVI΁AVerQueryValueŊmۂ̈炵B
	delete [] m_pVI;
	m_pVI = nullptr;
	m_pWord = nullptr;
	m_Word = 0;
}

//**********************************************************************
//
// e̎擾
//
//**********************************************************************
//! Ж
UINT CVersionInfo::GetCompanyName(TCHAR** dst)
{
	return GetStringFileInfo(TEXT("CompanyName")	,(LPVOID*)dst);
}
//! 
UINT CVersionInfo::GetFileDescription(TCHAR** dst)
{
	return GetStringFileInfo(TEXT("FileDescription"),(LPVOID*)dst);
}
//! t@Co[W
UINT CVersionInfo::GetFileVersion(TCHAR** dst)
{
	return GetStringFileInfo(TEXT("FileVersion")	,(LPVOID*)dst);
}
//! 
UINT CVersionInfo::GetInternalName(TCHAR** dst)
{
	return GetStringFileInfo(TEXT("InternalName")	,(LPVOID*)dst);
}
//! 쌠
UINT CVersionInfo::GetLegalCopyright(TCHAR** dst)
{
	return GetStringFileInfo(TEXT("LegalCopyright")	,(LPVOID*)dst);
}
//! t@C
UINT CVersionInfo::GetOriginalFileName(TCHAR** dst)
{
	return GetStringFileInfo(TEXT("OriginalFileName"),(LPVOID*)dst);
}
//! i
UINT CVersionInfo::GetProductName(TCHAR** dst)
{
	return GetStringFileInfo(TEXT("ProductName")	,(LPVOID*)dst);
}
//! io[W
UINT CVersionInfo::GetProductVersion(TCHAR** dst)
{
	return GetStringFileInfo(TEXT("ProductVersion")	,(LPVOID*)dst);
}
//! Rg
UINT CVersionInfo::GetComments(TCHAR** dst)
{
	return GetStringFileInfo(TEXT("Comments")		,(LPVOID*)dst);
}
//! W
UINT CVersionInfo::GetLegalTrademarks(TCHAR** dst)
{
	return GetStringFileInfo(TEXT("LegalTrademarks"),(LPVOID*)dst);
}
//! vCx[grh
UINT CVersionInfo::GetPrivateBuild(TCHAR** dst)
{
	return GetStringFileInfo(TEXT("PrivateBuild")	,(LPVOID*)dst);
}
//! XyVrh
UINT CVersionInfo::GetSpecialBuild(TCHAR** dst)
{
	return GetStringFileInfo(TEXT("SpecialBuild")	,(LPVOID*)dst);
}

/**********************************************************************//**
 *
 * StringFileInfo̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	nID	= 
 * @param [out]	dst	= o̓obt@
 * @return	
*//***********************************************************************/
UINT CVersionInfo::GetStringFileInfoFromID(int nID, TCHAR** dst)
{
	switch( nID )
	{
	case COMPANYNAME:
		return GetCompanyName(dst);
	case FILEDESCRIPTION:
		return GetFileDescription(dst);
	case FILEVERSION:
		return GetFileVersion(dst);
	case INTERNALNAME:
		return GetInternalName(dst);
	case LEGALCOPYRIGHT:
		return GetLegalCopyright(dst);
	case ORIGINALFILENAME:
		return GetOriginalFileName(dst);
	case PRODUCTNAME:
		return GetProductName(dst);
	case PRODUCTVERSION:
		return GetProductVersion(dst);
	case COMMENTS:
		return GetComments(dst);
	case LEGALTRADEMARKS:
		return GetLegalTrademarks(dst);
	case PRIVATEBUILD:
		return GetPrivateBuild(dst);
	case SPECIALBUILD:
		return GetSpecialBuild(dst);
	}
	return 0;
}

/**********************************************************************//**
 *
 * o[W̎擾(10i)
 *
 ----------------------------------------------------------------------
 * @return	o[W(10i)
*//***********************************************************************/
int CVersionInfo::GetVersionInt(void)
{
	int d=1;
	int ret=0;
	LPTSTR v;
	GetProductVersion(&v);
	// I[T
	LPTSTR e = v;
	while( *e != TEXT('\0') ) ++e;
	do
	{
		--e;
		if( *e >= TEXT('0') && *e <= TEXT('9') )
		{
			ret += d*(*e-TEXT('0'));
			d*=10;
		}
	} while( e != v );
	return ret;
}

/**********************************************************************//**
 *
 * o[W̎擾(16i)
 *
 ----------------------------------------------------------------------
 * @return	o[W(16i)
*//***********************************************************************/
int CVersionInfo::GetVersionHex(void)
{
	int d=1;
	int ret=0;
	LPTSTR v;
	GetProductVersion(&v);
	// I[T
	LPTSTR e = v;
	while( *e != TEXT('\0') ) ++e;
	do
	{
		--e;
		if( *e >= TEXT('0') && *e <= TEXT('9') )
		{
			ret += d*(*e-TEXT('0'));
			d*=0x10;
		}
		else
		{
			char c = (char)toupper(*e);
			if( c >= TEXT('A') && c <= TEXT('F') )
			{
				ret += d*(c-TEXT('A')+10);
				d*=0x10;
			}
		}
	} while( e != v );
	return ret;
}

/**********************************************************************//**
 *
 * ̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	block_name	= ubN
 * @param [out]	dst			= o
 * @return	
*//***********************************************************************/
UINT CVersionInfo::GetQueryValue(LPTSTR block_name, LPVOID* dst)
{
	UINT len=0;
	if( VerQueryValue(m_pVI, block_name, dst, &len) == 0 ) return 0;
	return len;
}

/**********************************************************************//**
 *
 * StringFileInfo̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	block_name	= ubN
 * @param [out]	dst			= o
 * @return	
*//***********************************************************************/
UINT CVersionInfo::GetStringFileInfo(LPTSTR block_name, LPVOID* dst)
{
	TCHAR key[256];
	wsprintf( key, TEXT("\\StringFileInfo\\%08x\\%s"), m_Word, block_name );
	return GetQueryValue(key, dst);
}

}	// end of namespace wx
}	// end of namespace iris
