//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXStaringTable.h
 * @brief		StringTablet@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXStaringTable_H_
#define _IRIS_WXStaringTable_H_

//======================================================================
// include
#include "iris_object.h"
#include <vector>

/*
// L`incldeOɐ錾Ă
// cpp̒`ƒu邱Ƃł
// ŏ
#define STRING_TABLE_LENGTH_MIN		64
// ő啶
// Ȃ̏ꍇ͒`Ȃ
#define STRING_TABLE_LENGTH_MAX		4096
// 擾x
// (STRING_TABLE_LENGTH_MINSTRING_TABLE_ACCURACYZẴobt@𐶐B)
#define STRING_TABLE_ACCURACY		64	
*/

namespace iris {
namespace wx
{

//======================================================================
// declare
class CStringTableA;
class CStringTableW;

//======================================================================
// typedef
#ifdef UNICODE
typedef CStringTableW	CStringTable;
#else
typedef CStringTableA	CStringTable;
#endif

//======================================================================
// class
//! StringTableANX
class CStringTableA : public INonCopyObject
{
	typedef std::vector<LPSTR> StringArray;
	typedef StringArray::iterator iterator;
	// i[
	StringArray m_StringArray;
public:
	// RXgN^
	CStringTableA(void);
	// fXgN^
	virtual ~CStringTableA(void);
public:
	// 擾
	// pDefString = 擾ɎsƂɕԂ
	LPSTR	Get(HINSTANCE hInst, int nID, LPSTR pDefString=nullptr);
	LPSTR	Get(int nID, LPSTR pDefString=nullptr);
};

//! StringTableWNX
class CStringTableW : public INonCopyObject
{
	typedef std::vector<LPWSTR> StringArray;
	typedef StringArray::iterator iterator;
	// i[
	StringArray m_StringArray;
public:
	// RXgN^
	CStringTableW(void);
	// fXgN^
	virtual ~CStringTableW(void);
public:
	// 擾
	// pDefString = 擾ɎsƂɕԂ
	LPWSTR	Get(HINSTANCE hInst, int nID, LPWSTR pDefString=nullptr);
	LPWSTR	Get(int nID, LPWSTR pDefString=nullptr);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
