//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXRegistry.h
 * @brief		WXgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXRegistry_H_
#define _IRIS_WXRegistry_H_

//======================================================================
// include
#include "iris_object.h"
#include <winreg.h>

namespace iris {
namespace wx
{

//======================================================================
// class
//! WXgNX
class CRegistry : public INonCopyObject
{
private:
	HKEY	m_hKey;
public:
	typedef BOOL	(*PFN_EnumProc)(CRegistry& rKey, DWORD dwIndex, LPVOID lpArg);
public:
	// RXgN^
	CRegistry(void);
	CRegistry(HKEY hKey);
	// fXgN^
	virtual ~CRegistry(void);

	HKEY	GetKey(void)		{ return m_hKey; }
	HKEY	operator () (void)	{ return GetKey(); } 
	operator HKEY (void)		{ return GetKey(); } 

public:
	// ֘At
	HKEY	Attach(HKEY hKey);
	// ֘At̉
	HKEY	Detach(void);

public:
	BOOL	IsValid(void)		{ return m_hKey != nullptr ? TRUE : FALSE; }
public:
	// J
	BOOL	Open (HKEY hKey, LPCTSTR lpSubKey);
	BOOL	OpenA(HKEY hKey, LPCSTR  lpSubKey);
	BOOL	OpenW(HKEY hKey, LPCWSTR lpSubKey);

	BOOL	OpenEx (HKEY hKey, LPCTSTR lpSubKey, DWORD dwOptions, REGSAM samDesired);
	BOOL	OpenExA(HKEY hKey, LPCSTR  lpSubKey, DWORD dwOptions, REGSAM samDesired);
	BOOL	OpenExW(HKEY hKey, LPCWSTR lpSubKey, DWORD dwOptions, REGSAM samDesired);
	// 
	BOOL	Close(void);

public:
	// 쐬


public:
	// l擾
	BOOL	QueryValue (LPCTSTR lpSubKey, LPTSTR lpValue, PLONG lpcbValue);
	BOOL	QueryValueA(LPCSTR  lpSubKey, LPSTR  lpValue, PLONG lpcbValue);
	BOOL	QueryValueW(LPCWSTR lpSubKey, LPWSTR lpValue, PLONG lpcbValue);

	BOOL	QueryValueEx (LPCTSTR lpValueName, LPDWORD lpType, LPBYTE lpData, LPDWORD lpcbData);
	BOOL	QueryValueExA(LPCSTR  lpValueName, LPDWORD lpType, LPBYTE lpData, LPDWORD lpcbData);
	BOOL	QueryValueExW(LPCWSTR lpValueName, LPDWORD lpType, LPBYTE lpData, LPDWORD lpcbData);

public:
	// lݒ
	BOOL	SetValue (LPCTSTR lpSubKey, DWORD dwType, LPCTSTR lpData, DWORD cbData);
	BOOL	SetValueA(LPCSTR  lpSubKey, DWORD dwType, LPCSTR  lpData, DWORD cbData);
	BOOL	SetValueW(LPCWSTR lpSubKey, DWORD dwType, LPCWSTR lpData, DWORD cbData);

	BOOL	SetValueEx (LPCTSTR lpValueName, DWORD dwType, const BYTE* lpData, DWORD cbData);
	BOOL	SetValueExA(LPCSTR  lpValueName, DWORD dwType, const BYTE* lpData, DWORD cbData);
	BOOL	SetValueExW(LPCWSTR lpValueName, DWORD dwType, const BYTE* lpData, DWORD cbData);

public:
	// 
	LSTATUS	EnumKey (DWORD dwIndex, LPTSTR lpName, DWORD cchName);
	LSTATUS	EnumKeyA(DWORD dwIndex, LPSTR  lpName, DWORD cchName);
	LSTATUS	EnumKeyW(DWORD dwIndex, LPWSTR lpName, DWORD cchName);

	LSTATUS	EnumKeyEx (DWORD dwIndex, LPTSTR lpName, LPDWORD lpcchName, LPDWORD lpReserved, LPTSTR lpClass, LPDWORD lpcchClass, PFILETIME lpftLastWriteTime);
	LSTATUS	EnumKeyExA(DWORD dwIndex, LPSTR  lpName, LPDWORD lpcchName, LPDWORD lpReserved, LPSTR  lpClass, LPDWORD lpcchClass, PFILETIME lpftLastWriteTime);
	LSTATUS	EnumKeyExW(DWORD dwIndex, LPWSTR lpName, LPDWORD lpcchName, LPDWORD lpReserved, LPWSTR lpClass, LPDWORD lpcchClass, PFILETIME lpftLastWriteTime);

	// 񋓏
	BOOL	EnumKeyProc(PFN_EnumProc pfnEnumProc, LPVOID lpArg);

public:
	// 
	BOOL	SetKeySecurity(SECURITY_INFORMATION si, PSECURITY_DESCRIPTOR sd);

public:
	// 
	BOOL	SaveKey (LPCTSTR lpFile, LPSECURITY_ATTRIBUTES lpSecurityAttributes);
	BOOL	SaveKeyA(LPCSTR  lpFile, LPSECURITY_ATTRIBUTES lpSecurityAttributes);
	BOOL	SaveKeyW(LPCWSTR lpFile, LPSECURITY_ATTRIBUTES lpSecurityAttributes);

public:
	// template
	template<typename _TN>
	BOOL	OpenT(HKEY hKey, const _TN* lpSubKey)			{ return FALSE; }
	template<>
	BOOL	OpenT<CHAR>(HKEY hKey, const CHAR* lpSubKey)	{ return OpenA(hKey, lpSubKey); }
	template<>
	BOOL	OpenT<WCHAR>(HKEY hKey, const WCHAR* lpSubKey)	{ return OpenW(hKey, lpSubKey); }

	template<typename _TN>
	BOOL	QueryValueT(const _TN* lpSubKey, _TN* lpValue, PLONG lpcbValue)				{ return FALSE; }
	template<>
	BOOL	QueryValueT<CHAR>(LPCSTR  lpSubKey, LPSTR  lpValue, PLONG lpcbValue)		{ return QueryValueA(lpSubKey, lpValue, lpcbValue); }
	template<>
	BOOL	QueryValueT<WCHAR>(LPCWSTR lpSubKey, LPWSTR lpValue, PLONG lpcbValue)		{ return QueryValueW(lpSubKey, lpValue, lpcbValue); }

	template<typename _TN>
	BOOL	QueryValueExT(const _TN* lpSubKey, LPDWORD lpType, LPBYTE lpData, LPDWORD lpcbData)			{ return FALSE; }
	template<>
	BOOL	QueryValueExT<CHAR>(LPCSTR  lpSubKey, LPDWORD lpType, LPBYTE lpData, LPDWORD lpcbData)		{ return QueryValueExA(lpSubKey, lpType, lpData, lpcbData); }
	template<>
	BOOL	QueryValueExT<WCHAR>(LPCWSTR lpSubKey, LPDWORD lpType, LPBYTE lpData, LPDWORD lpcbData)		{ return QueryValueExW(lpSubKey, lpType, lpData, lpcbData); }

};

}	// end of namespace wx
}	// end of namespace iris

#endif
