//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXRegistry.cpp
 * @brief		WXgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXRegistry_CPP_

//======================================================================
// include
#include "WXRegistry.h"
#include "iris_debug.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CRegistry::CRegistry(void)
: m_hKey(nullptr)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hKey	= ֘AtL[
*//***********************************************************************/
CRegistry::CRegistry(HKEY hKey)
: m_hKey(nullptr)
{
	Attach(hKey);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CRegistry::~CRegistry(void)
{
	Close();
}

/**********************************************************************//**
 *
 * ֘At
 *
 * @note	L[Ȃ̂Œ
 *
 ----------------------------------------------------------------------
 * @param [in]	hKey		= Vnh
 * @return	ȑÕnh
*//***********************************************************************/
HKEY CRegistry::Attach(HKEY hKey)
{
	HKEY hPre = m_hKey;
	m_hKey = hKey;
	return hPre;
}

/**********************************************************************//**
 *
 * ֘At
 *
 * @note	L[Ȃ̂Œ
 *
 ----------------------------------------------------------------------
 * @return	ȑÕnh
*//***********************************************************************/
HKEY CRegistry::Detach(void)
{
	HKEY hPre = m_hKey;
	m_hKey = nullptr;
	return hPre;
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	hKey		= 
 * @param [in]	lpSubKey	= 
 * @return	
*//***********************************************************************/
BOOL CRegistry::Open (HKEY hKey, LPCTSTR lpSubKey)
{
#ifdef UNICODE
	return OpenW(hKey, lpSubKey);
#else
	return OpenA(hKey, lpSubKey);
#endif
}
/// CRegistry::Open Q
BOOL CRegistry::OpenA(HKEY hKey, LPCSTR  lpSubKey)
{
	Close();
	if( RegOpenKeyA(hKey, lpSubKey, &m_hKey) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}
/// CRegistry::Open Q
BOOL CRegistry::OpenW(HKEY hKey, LPCWSTR lpSubKey)
{
	Close();
	if( RegOpenKeyW(hKey, lpSubKey, &m_hKey) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	hKey		= 
 * @param [in]	lpSubKey	= 
 * @param [in]	dwOptions	= 
 * @param [in]	samDesired	= KEY_***
 * @return	
*//***********************************************************************/
BOOL CRegistry::OpenEx (HKEY hKey, LPCTSTR lpSubKey, DWORD dwOptions, REGSAM samDesired)
{
#ifdef UNICODE
	return OpenExW(hKey, lpSubKey, dwOptions, samDesired);
#else
	return OpenExA(hKey, lpSubKey, dwOptions, samDesired);
#endif
}
/// CRegistry::OpenEx Q
BOOL CRegistry::OpenExA(HKEY hKey, LPCSTR  lpSubKey, DWORD dwOptions, REGSAM samDesired)
{
	Close();
	if( RegOpenKeyExA(hKey, lpSubKey, dwOptions, samDesired, &m_hKey) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}
/// CRegistry::OpenEx Q
BOOL CRegistry::OpenExW(HKEY hKey, LPCWSTR lpSubKey, DWORD dwOptions, REGSAM samDesired)
{
	Close();
	if( RegOpenKeyExW(hKey, lpSubKey, dwOptions, samDesired, &m_hKey) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CRegistry::Close(void)
{
	if( RegCloseKey(m_hKey) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * l擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpSubKey	= 
 * @param [in]	lpValue		= 
 * @param [in]	lpcbValue	= 
 * @return	
*//***********************************************************************/
BOOL CRegistry::QueryValue (LPCTSTR lpSubKey, LPTSTR lpValue, PLONG lpcbValue)
{
	if( RegQueryValue (m_hKey, lpSubKey, lpValue, lpcbValue) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}
/// CRegistry::QueryValue Q
BOOL CRegistry::QueryValueA(LPCSTR  lpSubKey, LPSTR  lpValue, PLONG lpcbValue)
{
	if( RegQueryValueA(m_hKey, lpSubKey, lpValue, lpcbValue) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}
/// CRegistry::QueryValue Q
BOOL CRegistry::QueryValueW(LPCWSTR lpSubKey, LPWSTR lpValue, PLONG lpcbValue)
{
	if( RegQueryValueW(m_hKey, lpSubKey, lpValue, lpcbValue) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * l擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpSubKey	= 
 * @param [in]	lpValue		= 
 * @param [in]	lpcbValue	= 
 * @return	
*//***********************************************************************/
BOOL CRegistry::QueryValueEx (LPCTSTR lpValueName, LPDWORD lpType, LPBYTE lpData, LPDWORD lpcbData)
{
	if( RegQueryValueEx (m_hKey, lpValueName, nullptr, lpType, lpData, lpcbData) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}
/// CRegistry::QueryValueEx Q
BOOL CRegistry::QueryValueExA(LPCSTR  lpValueName, LPDWORD lpType, LPBYTE lpData, LPDWORD lpcbData)
{
	if( RegQueryValueExA(m_hKey, lpValueName, nullptr, lpType, lpData, lpcbData) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}
/// CRegistry::QueryValue Q
BOOL CRegistry::QueryValueExW(LPCWSTR lpValueName, LPDWORD lpType, LPBYTE lpData, LPDWORD lpcbData)
{
	if( RegQueryValueExW(m_hKey, lpValueName, nullptr, lpType, lpData, lpcbData) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * lݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpSubKey	= 
 * @param [in]	dwType		= 
 * @param [in]	lpData		= 
 * @param [in]	cbData		= 
 * @return	
*//***********************************************************************/
BOOL CRegistry::SetValue (LPCTSTR lpSubKey, DWORD dwType, LPCTSTR lpData, DWORD cbData)
{
	if( RegSetValue (m_hKey, lpSubKey, dwType, lpData, cbData) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}
/// CRegistry::SetValue Q
BOOL CRegistry::SetValueA(LPCSTR  lpSubKey, DWORD dwType, LPCSTR  lpData, DWORD cbData)
{
	if( RegSetValueA(m_hKey, lpSubKey, dwType, lpData, cbData) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}
/// CRegistry::SetValue Q
BOOL CRegistry::SetValueW(LPCWSTR lpSubKey, DWORD dwType, LPCWSTR lpData, DWORD cbData)
{
	if( RegSetValueW(m_hKey, lpSubKey, dwType, lpData, cbData) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * lݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpValueName	= 
 * @param [in]	dwType		= 
 * @param [in]	lpData		= 
 * @param [in]	cbData		= 
 * @return	
*//***********************************************************************/
BOOL CRegistry::SetValueEx (LPCTSTR lpValueName, DWORD dwType, const BYTE* lpData, DWORD cbData)
{
	if( RegSetValueEx (m_hKey, lpValueName, 0, dwType, lpData, cbData) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}
/// CRegistry::SetValueEx Q
BOOL CRegistry::SetValueExA(LPCSTR  lpValueName, DWORD dwType, const BYTE* lpData, DWORD cbData)
{
	if( RegSetValueExA(m_hKey, lpValueName, 0, dwType, lpData, cbData) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}
/// CRegistry::SetValueEx Q
BOOL CRegistry::SetValueExW(LPCWSTR lpValueName, DWORD dwType, const BYTE* lpData, DWORD cbData)
{
	if( RegSetValueExW(m_hKey, lpValueName, 0, dwType, lpData, cbData) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * CfbNX擾
 *
 ----------------------------------------------------------------------
 * @param [in]	dwIndex				= CfbNX
 * @param [out]	lpName				= o̓obt@
 * @param [in]	cchName				= o̓obt@TCY
 * @return	
*//***********************************************************************/
LSTATUS CRegistry::EnumKey (DWORD dwIndex, LPTSTR lpName, DWORD cchName)
{
#ifdef UNICODE
	return EnumKeyW(dwIndex, lpName, cchName);
#else
	return EnumKeyA(dwIndex, lpName, cchName);
#endif
}
/// CRegistry::EnumKey Q
LSTATUS CRegistry::EnumKeyA(DWORD dwIndex, LPSTR  lpName, DWORD cchName)
{
	return RegEnumKeyA(m_hKey, dwIndex, lpName, cchName);
}
/// CRegistry::EnumKey Q
LSTATUS CRegistry::EnumKeyW(DWORD dwIndex, LPWSTR lpName, DWORD cchName)
{
	return RegEnumKeyW(m_hKey, dwIndex, lpName, cchName);
}

/**********************************************************************//**
 *
 * CfbNX擾
 *
 ----------------------------------------------------------------------
 * @param [in]	dwIndex				= CfbNX
 * @param [out]	lpName				= L[
 * @param [out]	lpcchName			= L[̏o̓TCY
 * @param [in]	lpReserved			= \̈
 * @param [out]	lpClass				= 
 * @param [out]	lpcchClass			= 
 * @param [in]	lpftLastWriteTime	= 
 * @return	
*//***********************************************************************/
LSTATUS CRegistry::EnumKeyEx (DWORD dwIndex, LPTSTR lpName, LPDWORD lpcchName, LPDWORD lpReserved, LPTSTR lpClass, LPDWORD lpcchClass, PFILETIME lpftLastWriteTime)
{
#ifdef UNICODE
	return EnumKeyExW(dwIndex, lpName, lpcchName, lpReserved, lpClass, lpcchClass, lpftLastWriteTime);
#else
	return EnumKeyExA(dwIndex, lpName, lpcchName, lpReserved, lpClass, lpcchClass, lpftLastWriteTime);
#endif
}
/// CRegistry::EnumKeyEx Q
LSTATUS CRegistry::EnumKeyExA(DWORD dwIndex, LPSTR  lpName, LPDWORD lpcchName, LPDWORD lpReserved, LPSTR  lpClass, LPDWORD lpcchClass, PFILETIME lpftLastWriteTime)
{
	return RegEnumKeyExA(m_hKey, dwIndex, lpName, lpcchName, lpReserved, lpClass, lpcchClass, lpftLastWriteTime);
}
/// CRegistry::EnumKeyEx Q
LSTATUS CRegistry::EnumKeyExW(DWORD dwIndex, LPWSTR lpName, LPDWORD lpcchName, LPDWORD lpReserved, LPWSTR lpClass, LPDWORD lpcchClass, PFILETIME lpftLastWriteTime)
{
	return RegEnumKeyExW(m_hKey, dwIndex, lpName, lpcchName, lpReserved, lpClass, lpcchClass, lpftLastWriteTime);
}

/**********************************************************************//**
 *
 * 񋓏 
 *
 ----------------------------------------------------------------------
 * @param [in]	pfnEnumProc		= ֐
 * @return	
*//***********************************************************************/
BOOL CRegistry::EnumKeyProc(PFN_EnumProc pfnEnumProc, LPVOID lpArg)
{
	IRIS_ASSERT( pfnEnumProc != nullptr );
	if( !IsValid() ) return FALSE;
	CHAR key[MAX_PATH];
	DWORD key_size = MAX_PATH;
	DWORD dwIndex = 0;
	do
	{
		LSTATUS lstatus = EnumKeyA(dwIndex, key, key_size);
		if( lstatus == ERROR_NO_MORE_ITEMS ) break;
		IRIS_ASSERT( lstatus == ERROR_SUCCESS );

		CRegistry reg;
		if( reg.OpenA(m_hKey, key) )
		{
			if( !(*pfnEnumProc)(reg, dwIndex, lpArg) )
			{
				break;
			}
		}
	} while(++dwIndex);
	return TRUE;
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	si		= 
 * @param [in]	sd		= 
 * @return	
*//***********************************************************************/
BOOL CRegistry::SetKeySecurity(SECURITY_INFORMATION si, PSECURITY_DESCRIPTOR sd)
{
	if( RegSetKeySecurity(m_hKey, si, sd) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * lݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpFile					= 
 * @param [in]	lpSecurityAttributes	= 
 * @return	
*//***********************************************************************/
BOOL CRegistry::SaveKey (LPCTSTR lpFile, LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{
	if( RegSaveKey (m_hKey, lpFile, lpSecurityAttributes) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}
/// CRegistry::SaveKey Q
BOOL CRegistry::SaveKeyA(LPCSTR  lpFile, LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{
	if( RegSaveKeyA(m_hKey, lpFile, lpSecurityAttributes) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}
/// CRegistry::SaveKey Q
BOOL CRegistry::SaveKeyW(LPCWSTR lpFile, LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{
	if( RegSaveKeyW(m_hKey, lpFile, lpSecurityAttributes) != ERROR_SUCCESS )
		return FALSE;
	return TRUE;
}

}	// end of namespace wx
}	// end of namespace iris
