//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXProfile.h
 * @brief		ProfileNX
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXProfile_H_
#define _IRIS_WXProfile_H_

//======================================================================
// include
#include "stl/STLvecmap.h"
#include "stl/STLtstring.h"

namespace iris {
namespace wx 
{

//======================================================================
// function
// l̏
BOOL	WritePrivateProfileIntA(LPCSTR  lpAppName, LPCSTR  lpKeyName, UINT nValue, LPCSTR  lpFileName);
BOOL	WritePrivateProfileIntW(LPCWSTR lpAppName, LPCWSTR lpKeyName, UINT nValue, LPCWSTR lpFileName);
// l(HEX)̏
BOOL	WritePrivateProfileHexA(LPCSTR  lpAppName, LPCSTR  lpKeyName, DWORD nValue, LPCSTR  lpFileName);
BOOL	WritePrivateProfileHexW(LPCWSTR lpAppName, LPCWSTR lpKeyName, DWORD nValue, LPCWSTR lpFileName);
// l̎擾
DWORD	GetPrivateProfileHexA(LPCSTR  lpAppName, LPCSTR  lpKeyName, DWORD nDefault, LPCSTR  lpFileName);
DWORD	GetPrivateProfileHexW(LPCWSTR lpAppName, LPCWSTR lpKeyName, DWORD nDefault, LPCWSTR lpFileName);
// l̏
BOOL	WritePrivateProfileFloatA(LPCSTR  lpAppName, LPCSTR  lpKeyName, float fValue, LPCSTR  lpFileName);
BOOL	WritePrivateProfileFloatW(LPCWSTR lpAppName, LPCWSTR lpKeyName, float fValue, LPCWSTR lpFileName);
// l̎擾
float	GetPrivateProfileFloatA(LPCSTR  lpAppName, LPCSTR  lpKeyName, float fDefault, LPCSTR  lpFileName);
float	GetPrivateProfileFloatW(LPCWSTR lpAppName, LPCWSTR lpKeyName, float fDefault, LPCWSTR lpFileName);
// WINDOWPLACEMENT̏
BOOL	WritePrivateProfileWindowPlacementA(LPCSTR  lpAppName, LPCSTR  lpKeyName, HWND hWnd, LPCSTR  lpFileName);
BOOL	WritePrivateProfileWindowPlacementW(LPCWSTR lpAppName, LPCWSTR lpKeyName, HWND hWnd, LPCWSTR lpFileName);
// WINDOWPLACEMENT̎擾
BOOL	GetPrivateProfileWindowPlacementA(LPCSTR  lpAppName, LPCSTR  lpKeyName, LPWINDOWPLACEMENT lpwdpl, LPCSTR  lpFileName);
BOOL	GetPrivateProfileWindowPlacementW(LPCWSTR lpAppName, LPCWSTR lpKeyName, LPWINDOWPLACEMENT lpwdpl, LPCWSTR lpFileName);
BOOL	GetPrivateProfileWindowPlacementA(LPCSTR  lpAppName, LPCSTR  lpKeyName, HWND hWnd, LPCSTR  lpFileName);
BOOL	GetPrivateProfileWindowPlacementW(LPCWSTR lpAppName, LPCWSTR lpKeyName, HWND hWnd, LPCWSTR lpFileName);

//======================================================================
// define
#ifdef UNICODE
#define WritePrivateProfileInt				WritePrivateProfileIntW
#define WritePrivateProfileHex				WritePrivateProfileHexW
#define WritePrivateProfileFloat			WritePrivateProfileFloatW
#define GetPrivateProfileFloat				GetPrivateProfileFloatW
#define WritePrivateProfileWindowPlacement	WritePrivateProfileWindowPlacementW
#define GetPrivateProfileWindowPlacement	GetPrivateProfileWindowPlacementW
#else
#define WritePrivateProfileInt				WritePrivateProfileIntA
#define WritePrivateProfileHex				WritePrivateProfileHexA
#define WritePrivateProfileFloat			WritePrivateProfileFloatA
#define GetPrivateProfileFloat				GetPrivateProfileFloatA
#define WritePrivateProfileWindowPlacement	WritePrivateProfileWindowPlacementA
#define GetPrivateProfileWindowPlacement	GetPrivateProfileWindowPlacementA
#endif

//======================================================================
// class
//! PrivateProfileNX
class CPrivateProfile : public IIrisObject
{
public:
	// 
	typedef stl::tstring							std_tstring;
	typedef	std_tstring								KeyData;
	typedef std::pair<std_tstring, KeyData>			SectionPair;
	typedef stl::vecmap<std_tstring, KeyData>		SectionData;
	typedef std::pair<std_tstring, SectionData>		ProfilePair;
	typedef stl::vecmap<std_tstring, SectionData>	ProfileData;

private:
	// init@C
	TCHAR		m_Path[MAX_PATH];
	//
	ProfileData	m_Profile;

public:
	// RXgN^
	CPrivateProfile(void);
	// fXgN^
	virtual ~CPrivateProfile(void);
public:
	// J
	void		Open(LPCTSTR path);
	// 
	void		Close(void);

public:

	// ZNV擾
	DWORD		GetSectionNames(LPTSTR lpReturn, DWORD nSize);
	// ZNVɑ݂L[擾
	DWORD		GetSection	(LPCTSTR lpAppName, LPTSTR lpReturn, DWORD nSize);
	// t@C當擾
	DWORD		GetString	(LPCTSTR lpAppName, LPCTSTR lpKeyName, LPCTSTR lpDefault, LPTSTR lpReturn, DWORD nSize);
	// t@C琮l擾
	UINT		GetInt		(LPCTSTR lpAppName, LPCTSTR lpKeyName, UINT nDefault);
	// t@C珬l擾
	float		GetFloat	(LPCTSTR lpAppName, LPCTSTR lpKeyName, float fDefault);
	// t@C\̂擾
	DWORD		GetStruct	(LPCTSTR lpAppName, LPCTSTR lpKeyName, LPVOID lpStruct, DWORD nSize);
	// t@CWINDOWPLACEMENT擾
	DWORD		GetWindowPlacement(LPCTSTR lpAppName, LPCTSTR lpKeyName, LPWINDOWPLACEMENT lpwdpl);
	DWORD		GetWindowPlacement(LPCTSTR lpAppName, LPCTSTR lpKeyName, HWND hWnd);

	// t@CɃL[
	BOOL		WriteSection(LPCTSTR lpAppName, LPCTSTR lpString);
	// t@Cɐl
	BOOL		WriteInt	(LPCTSTR lpAppName, LPCTSTR lpKeyName, UINT nValue);
	// t@Cɏl
	BOOL		WriteFloat	(LPCTSTR lpAppName, LPCTSTR lpKeyName, float fValue);
	// t@Cɕ
	BOOL		WriteString	(LPCTSTR lpAppName, LPCTSTR lpKeyName, LPCTSTR lpString);
	// t@Cɍ\̂
	BOOL		WriteStruct	(LPCTSTR lpAppName, LPCTSTR lpKeyName, LPVOID lpStruct, DWORD nSize);
	// t@CWINDOWPLACEMENT
	BOOL		WriteWindowPlacement(LPCTSTR lpAppName, LPCTSTR lpKeyName, HWND hWnd);

public:
	// JĂ邩
	bool		IsOpen(void)	{ return (m_Path[0] != TEXT('\0')); }

public:
	// ZNṼXg
	bool		MakeAppList(void);
	// L[̃Xg
	//	ŃZNṼXg܂
	bool		MakeKeyList(LPCTSTR lpAppName);
	// L[̃Xg
	static bool	MakeKeyList(LPCTSTR lpAppName, LPCTSTR lpFileName, SectionData& rData);

	// ZNVEL[̃Xg
	bool		MakeProfileList(void);
	// Xg̃NA
	void		ClearProfileList(void);
	// Xg
	bool		WriteList(bool bClear);

public:
	// set, get
	// vt@C̎擾
	ProfileData		GetProfileData(void)	{ return m_Profile; }

	// ZNV̎擾
	std_tstring*	GetAppName(int nIndex);
	// L[̎擾
	std_tstring*	GetKeyName(int nAppIndex, int nIndex);
	std_tstring*	GetKeyName(LPCTSTR lpAppNae, int nIndex);
	// L[l̎擾
	KeyData*		GetKeyData(int nAppIndex, int nKeyIndex);
	KeyData*		GetKeyData(LPCTSTR lpAppNae, int nKeyIndex);

	// ZNV폜
	BOOL			DeleteSection(LPCTSTR lpAppName);
	// L[폜
	BOOL			DeleteKey(LPCTSTR lpAppName, LPCTSTR lpKeyName);

public:

	// L[Xǧ
	SectionData*	FindSectionData(LPCTSTR lpAppName);

};

}	// end of namespace wx
}	// end of namespace iris

#endif
