//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXProcess.h
 * @brief		vZXNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXProcess_H_
#define _IRIS_WXProcess_H_

//======================================================================
// include
#include "../base/WXHandle.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/// vZXNX
class CProcess : public CHandle
{
public:
	// RXgN^
	CProcess(void);
	CProcess(HANDLE hProcess);
	// fXgN^
	virtual ~CProcess(void);

public:
	// 쐬
	BOOL	Create (LPCTSTR lpApplicationName, LPTSTR lpCmdLine
					   , LPSECURITY_ATTRIBUTES lpProcessAttr, LPSECURITY_ATTRIBUTES lpThreadAttr
					   , BOOL bInheritHandles, DWORD dwCreationFlags
					   , LPVOID lpEnvironment, LPCTSTR lpCurrentDirectory
					   , LPSTARTUPINFO lpStartupInfo, LPPROCESS_INFORMATION lppi);
	BOOL	CreateA(LPCSTR  lpApplicationName, LPSTR  lpCmdLine
					   , LPSECURITY_ATTRIBUTES lpProcessAttr, LPSECURITY_ATTRIBUTES lpThreadAttr
					   , BOOL bInheritHandles, DWORD dwCreationFlags
					   , LPVOID lpEnvironment, LPCSTR  lpCurrentDirectory
					   , LPSTARTUPINFOA lpStartupInfo, LPPROCESS_INFORMATION lppi);
	BOOL	CreateW(LPCWSTR lpApplicationName, LPWSTR lpCmdLine
					   , LPSECURITY_ATTRIBUTES lpProcessAttr, LPSECURITY_ATTRIBUTES lpThreadAttr
					   , BOOL bInheritHandles, DWORD dwCreationFlags
					   , LPVOID lpEnvironment, LPCWSTR lpCurrentDirectory
					   , LPSTARTUPINFOW lpStartupInfo, LPPROCESS_INFORMATION lppi);
	BOOL	CreateAsUser (HANDLE hToken, LPCTSTR lpApplicationName, LPTSTR lpCmdLine
					   , LPSECURITY_ATTRIBUTES lpProcessAttr, LPSECURITY_ATTRIBUTES lpThreadAttr
					   , BOOL bInheritHandles, DWORD dwCreationFlags
					   , LPVOID lpEnvironment, LPCTSTR lpCurrentDirectory
					   , LPSTARTUPINFO lpStartupInfo, LPPROCESS_INFORMATION lppi);
	BOOL	CreateAsUserA(HANDLE hToken, LPCSTR  lpApplicationName, LPSTR  lpCmdLine
					   , LPSECURITY_ATTRIBUTES lpProcessAttr, LPSECURITY_ATTRIBUTES lpThreadAttr
					   , BOOL bInheritHandles, DWORD dwCreationFlags
					   , LPVOID lpEnvironment, LPCSTR  lpCurrentDirectory
					   , LPSTARTUPINFOA lpStartupInfo, LPPROCESS_INFORMATION lppi);
	BOOL	CreateAsUserW(HANDLE hToken, LPCWSTR lpApplicationName, LPWSTR lpCmdLine
					   , LPSECURITY_ATTRIBUTES lpProcessAttr, LPSECURITY_ATTRIBUTES lpThreadAttr
					   , BOOL bInheritHandles, DWORD dwCreationFlags
					   , LPVOID lpEnvironment, LPCWSTR lpCurrentDirectory
					   , LPSTARTUPINFOW lpStartupInfo, LPPROCESS_INFORMATION lppi);

	// vZX̏IR[h̎擾
	DWORD	GetExitCode(void);
	// vZXID̎擾
	DWORD	GetProcessId(void);
	// vZX̎ԏ擾
	BOOL	GetProcessTimes(LPFILETIME lpCreationTime, LPFILETIME lpExitTime, LPFILETIME lpKernelTime, LPFILETIME lpUserTime);
	// vZX̃J[l[hł̌oߎԂ擾
	BOOL	GetProcessKernelTime(LPFILETIME lpKernelTime);

public:
	// vZXJ
	BOOL	Open(DWORD dwDesiredAccess, BOOL bInheritHandle, DWORD dwProcessId);

private:
	// 쐬ʏ
	BOOL	_Create(LPPROCESS_INFORMATION lppid, LPPROCESS_INFORMATION lppis);

};

/// vZX쐬NX
class CProcessInfo : public INonCopyObject
{
protected:
	PROCESS_INFORMATION	m_Info;	//!< vZX
public:
	// fXgN^
	virtual ~CProcessInfo(void);
public:
	/// vZX̎擾
			PROCESS_INFORMATION&	GetProcessInfo(void)		{ return m_Info; }
	const	PROCESS_INFORMATION&	GetProcessInfo(void) const	{ return m_Info; }
			PROCESS_INFORMATION*	operator () (void)			{ return &m_Info; }
	const	PROCESS_INFORMATION*	operator () (void)	const	{ return &m_Info; }
	operator 		PROCESS_INFORMATION*	(void)				{ return &m_Info; }
	operator const	PROCESS_INFORMATION*	(void)	const		{ return &m_Info; }
};


}	// end of namespace wx
}	// end of namespace iris

#endif
