//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXModule.cpp
 * @brief		W[NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXModule_CPP_

//======================================================================
// include
#include "WXModule.h"
#include "iris_iostream.h"

#ifdef _IRIS_DEBUG
#include "../base/WXError.h"
#include <tchar.h>
#endif

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 * 
*//***********************************************************************/
CModule::CModule(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 * 
*//***********************************************************************/
CModule::~CModule(void)
{
	Release();
}

/**********************************************************************//**
 *
 * ǂݍ
 * 
 ----------------------------------------------------------------------
 * @param [in] lpModuleName	= W[t@C
 * @return	
*//***********************************************************************/
BOOL CModule::Load (LPCTSTR lpModuleName)
{
#ifdef UNICODE
	return LoadW(lpModuleName);
#else
	return LoadA(lpModuleName);
#endif
}
/// CModule::Load Q
BOOL CModule::LoadA(LPCSTR  lpModuleName)
{
	HMODULE hModule = LoadLibraryA(lpModuleName);
	if( hModule == nullptr ) 
	{
#ifdef _IRIS_DEBUG
		CErrorString es;
		es.GetErrorString(CLocalLastError());
		_tprintf(es.GetErrorString());
#endif
		return FALSE;
	}
	if( !Attach(reinterpret_cast<HANDLE>(hModule)) )
	{
		FreeLibrary(hModule);
		return FALSE;
	}
	return TRUE;
}
/// CModule::Load Q
BOOL CModule::LoadW(LPCWSTR lpModuleName)
{
	HMODULE hModule = LoadLibraryW(lpModuleName);
	if( hModule == nullptr ) 
	{
#ifdef _IRIS_DEBUG
		CErrorString es;
		es.GetErrorString(CLocalLastError());
		_tprintf(es.GetErrorString());
#endif
		return FALSE;
	}
	if( !Attach(reinterpret_cast<HANDLE>(hModule)) )
	{
		FreeLibrary(hModule);
		return FALSE;
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * 
 * 
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CModule::Release(void)
{
	return FreeLibrary(reinterpret_cast<HMODULE>(Detach()));
}

/**********************************************************************//**
 *
 * J
 *
 * @note	QƃJE^CNgȂ̂ŁA
 *			ReleaseƂ͒
 * 
 ----------------------------------------------------------------------
 * @param [in] lpModuleName	= W[
 * @return	
*//***********************************************************************/
BOOL CModule::Open (LPCTSTR lpModuleName)
{
#ifdef UNICODE
	return OpenW(lpModuleName);
#else
	return OpenA(lpModuleName);
#endif
}
/// CModule::Open Q
BOOL CModule::OpenA(LPCSTR  lpModuleName)
{
	HMODULE hModule = GetModuleHandleA(lpModuleName);
	if( hModule == nullptr ) return FALSE;
	return Attach(reinterpret_cast<HANDLE>(hModule));
}
/// CModule::Open Q
BOOL CModule::OpenW(LPCWSTR lpModuleName)
{
	HMODULE hModule = GetModuleHandleW(lpModuleName);
	if( hModule == nullptr ) return FALSE;
	return Attach(reinterpret_cast<HANDLE>(hModule));
}

/**********************************************************************//**
 *
 * 
 * 
*//***********************************************************************/
BOOL CModule::Close(void)
{
	Detach();
	return TRUE;
}

/**********************************************************************//**
 *
 * AhX̎擾
 * 
 ----------------------------------------------------------------------
 * @param [in]	lpProcName	= ֐
 * @return	AhX
*//***********************************************************************/
PROC CModule::GetProcAddress(LPCSTR lpProcName)
{
	return ::GetProcAddress(*this, lpProcName);
}

}	// end of namespace wx
}	// end of namespace iris
