//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXCriticalSection.cpp
 * @brief		NeBJZNV t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXCriticalSection_CPP_

//======================================================================
// include
#include "WXCriticalSection.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCriticalSection::CCriticalSection(void)
{
	InitializeCriticalSection(&m_Section);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CCriticalSection::~CCriticalSection(void)
{
	DeleteCriticalSection(&m_Section);
}

/**********************************************************************//**
 *
 * bN
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CCriticalSection::Lock(void)
{
	EnterCriticalSection(&m_Section);
	return true;
}

/**********************************************************************//**
 *
 * bN
 *
*//***********************************************************************/
void CCriticalSection::Unlock(void)
{
	LeaveCriticalSection(&m_Section);
}

/**********************************************************************//**
 *
 * bN
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CCriticalSection::TryLock(void)
{
#if _WIN32_WINNT >= 0x0400
	return TryEnterCriticalSection(&m_Section) != 0;
#else
	return false;
#endif
}


}	// end of namespace wx
}	// end of namespace iris

