//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSMTP.h
 * @brief		Simple Mail Transfer ProtocolNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXSMTP_H_
#define _IRIS_WXSMTP_H_

//======================================================================
// include
#include "WXTCP.h"
#include <string>

namespace iris {
namespace wx
{

//======================================================================
// class
//! SMTPNCAgNX
class CSMTPClient : public CTCPSocket
{
protected:
	DWORD	m_LastError;	//!< G[l
public:
	// RXgN^
	CSMTPClient();
	// fXgN^
	~CSMTPClient();

public:

	// OC
	BOOL	Login(LPCSTR lpszHost);
	// OAEg
	BOOL	Logout(void);

public:
	// HELLO
	BOOL	Hello(LPCSTR lpszHost);
	// FROM
	BOOL	MailFrom(LPCSTR lpAddress);
	// TO
	BOOL	RcptTo(LPCSTR lpAddress);
	// DATA
	BOOL	Data(void);
	// DATA end
	BOOL	End(void);

public:
	// ԐM̊mF
	BOOL	IsStatusOK(void);

public:
	// G[l擾
	DWORD	GetLastError(void)	{ return m_LastError; }
	BOOL	IsError(void);
};

}	// end of namespace wx
}	// end of namespace iris

#endif 
