//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMMWaveOut.cpp
 * @brief		WaveOutt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXMMWaveOut_CPP_

//======================================================================
// include
#include "WXMMWaveOut.h"
#include "WXMMSysError.h"
#include "../wx_inchead.h"

#include "../debug/WXDebugLeakCheckMacro.h"

//======================================================================
// link
#pragma comment( lib, "winmm.lib" )

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMMWaveOut::CMMWaveOut(void)
: m_hWaveOut(nullptr)
{
	ZeroMemory(&m_WaveHeader,sizeof(m_WaveHeader));
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CMMWaveOut::~CMMWaveOut(void)
{
	Reset();
	UnprepareHeader();
	Close();
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	pFormat		= tH[}bg
 * @param [in]	uDeviceID	= 
 * @return	MMRESULTl
*//***********************************************************************/
MMRESULT CMMWaveOut::Open(LPWAVEFORMATEX pFormat, UINT uDeviceID, DWORD_PTR dwCallbak, DWORD_PTR dwInstance, DWORD dwOpen)
{
	MMRESULT mmResult = waveOutOpen(&m_hWaveOut, uDeviceID, pFormat, dwCallbak, dwInstance, dwOpen);
	WX_MM_ERROR2(mmResult, TEXT("waveOutOpen(&m_hWaveOut, uDeviceID, pFormat, dwCallbak, dwInstance, dwOpen)") );
	return mmResult;
}

/**********************************************************************//**
 *
 * PrepareHeader
 *
 ----------------------------------------------------------------------
 * @param [in]	lpData		= 
 * @param [in]	dwLength	= 
 * @param [in]	dwFlags		= 
 * @param [in]	dwLoops		= 
 * @param [in]	dwUser		= 
 * @return	 
*//***********************************************************************/
MMRESULT CMMWaveOut::PrepareHeader(LPSTR lpData, DWORD dwLength, DWORD dwFlags, DWORD dwLoops, DWORD_PTR dwUser)
{
	if( m_hWaveOut == nullptr ) return MMSYSERR_NOERROR;
	m_WaveHeader.lpData			= lpData;
	m_WaveHeader.dwBufferLength	= dwLength;
	m_WaveHeader.dwFlags		= dwFlags;
	m_WaveHeader.dwLoops		= dwLoops;
	m_WaveHeader.dwUser			= dwUser;
	MMRESULT mmResult = waveOutPrepareHeader( m_hWaveOut, &m_WaveHeader, sizeof(m_WaveHeader) );
	WX_MM_ERROR2(mmResult, TEXT("waveOutPrepareHeader( m_hWaveOut, &m_WaveHeader, sizeof(m_WaveHeader) )") );
	return mmResult;
}

/**********************************************************************//**
 *
 * ݁iMj
 *
 ----------------------------------------------------------------------
 * @return	 
*//***********************************************************************/
MMRESULT CMMWaveOut::Write(void)
{
	if( m_hWaveOut == nullptr ) return MMSYSERR_NOERROR;
	MMRESULT mmResult = waveOutWrite( m_hWaveOut, &m_WaveHeader, sizeof(m_WaveHeader) );
	WX_MM_ERROR2(mmResult, TEXT("waveOutWrite( m_hWaveOut, &m_WaveHeader, sizeof(m_WaveHeader) )") );
	return mmResult;
}

/**********************************************************************//**
 *
 * ~
 *
 ----------------------------------------------------------------------
 * @return	 
*//***********************************************************************/
MMRESULT CMMWaveOut::Reset(void)
{
	if( m_hWaveOut == nullptr ) return MMSYSERR_NOERROR;
	MMRESULT mmResult = waveOutReset( m_hWaveOut );
	WX_MM_ERROR2(mmResult, TEXT("waveOutReset( m_hWaveOut )") );
	return mmResult;
}

/**********************************************************************//**
 *
 * UnprepareHeader
 *
 ----------------------------------------------------------------------
 * @return	 
*//***********************************************************************/
MMRESULT CMMWaveOut::UnprepareHeader(void)
{
	if( m_hWaveOut == nullptr ) return MMSYSERR_NOERROR;
	MMRESULT mmResult = waveOutUnprepareHeader( m_hWaveOut, &m_WaveHeader, sizeof(m_WaveHeader) );
	WX_MM_ERROR2(mmResult, TEXT("waveOutReset( m_hWaveOut )") );
	return mmResult;
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	 
*//***********************************************************************/
MMRESULT CMMWaveOut::Close(void)
{
	if( m_hWaveOut == nullptr ) return MMSYSERR_NOERROR;
	MMRESULT mmResult = waveOutClose( m_hWaveOut );
	WX_MM_ERROR2(mmResult, TEXT("waveOutClose( m_hWaveOut )") );
	if( mmResult == MMSYSERR_NOERROR ) m_hWaveOut = nullptr;
	return mmResult;
}

/**********************************************************************//**
 *
 * ꎞ~
 *
 ----------------------------------------------------------------------
 * @return	 
*//***********************************************************************/
MMRESULT CMMWaveOut::Pause(void)
{
	MMRESULT mmResult = waveOutPause( m_hWaveOut );
	WX_MM_ERROR2(mmResult, TEXT("waveOutPause( m_hWaveOut )") );
	return mmResult;
}

/**********************************************************************//**
 *
 * ĊJ
 *
 ----------------------------------------------------------------------
 * @return	 
*//***********************************************************************/
MMRESULT CMMWaveOut::Restart(void)
{
	MMRESULT mmResult = waveOutRestart( m_hWaveOut );
	WX_MM_ERROR2(mmResult, TEXT("waveOutRestart( m_hWaveOut )") );
	return mmResult;
}

/**********************************************************************//**
 *
 * [v̒f
 *
 ----------------------------------------------------------------------
 * @return	 
*//***********************************************************************/
MMRESULT CMMWaveOut::BreakLoop(void)
{
	MMRESULT mmResult = waveOutBreakLoop( m_hWaveOut );
	WX_MM_ERROR2(mmResult, TEXT("waveOutBreakLoop( m_hWaveOut )") );
	return mmResult;
}

/**********************************************************************//**
 *
 * ʎ擾
 *
 ----------------------------------------------------------------------
 * @return	 
*//***********************************************************************/
DWORD CMMWaveOut::GetVolume(void)
{
	DWORD dwVolume=0;
	WX_MM_CHECK_RESULT( waveOutGetVolume( m_hWaveOut, &dwVolume ) );
	return dwVolume;
}

/**********************************************************************//**
 *
 * ʐݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	dwVolume	= 
 * @return
*//***********************************************************************/
MMRESULT CMMWaveOut::SetVolume(DWORD dwVolume)
{
	MMRESULT mmResult = waveOutSetVolume( m_hWaveOut, dwVolume );
	WX_MM_ERROR2(mmResult, TEXT("waveOutSetVolume( m_hWaveOut, dwVolume )") );
	return mmResult;
}

/**********************************************************************//**
 *
 * ʐݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	dwVolumeL	= (`l)
 * @param [in]	dwVolumeR	= (E`l)
 * @return
*//***********************************************************************/
MMRESULT CMMWaveOut::SetVolume(DWORD dwVolumeL, DWORD dwVolumeR)
{
	DWORD vol = MAKELONG(dwVolumeL, dwVolumeR);
	return SetVolume(vol);
}

/**********************************************************************//**
 *
 * sb`擾
 *
 ----------------------------------------------------------------------
 * @return	sb`
*//***********************************************************************/
DWORD CMMWaveOut::GetPitch(void)
{
	DWORD dwPitch=0;
	WX_MM_CHECK_RESULT( waveOutGetPitch( m_hWaveOut, &dwPitch ) );
	return dwPitch;
}

/**********************************************************************//**
 *
 * sb`ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	dwPitch	= sb`
 * @return
*//***********************************************************************/
MMRESULT CMMWaveOut::SetPitch(DWORD dwPitch)
{
	MMRESULT mmResult = waveOutSetPitch( m_hWaveOut, dwPitch );
	WX_MM_ERROR2(mmResult, TEXT("waveOutSetPitch( m_hWaveOut, dwPitch )") );
	return mmResult;
}

/**********************************************************************//**
 *
 * 擾
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
DWORD CMMWaveOut::GetPlaybackRate(void)
{
	DWORD dwRate=0;
	WX_MM_CHECK_RESULT( waveOutGetPlaybackRate( m_hWaveOut, &dwRate ) );
	return dwRate;
}

/**********************************************************************//**
 *
 * ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	dwRate	= :, :
 * @return
*//***********************************************************************/
MMRESULT CMMWaveOut::SetPlaybackRate(DWORD dwRate)
{
	MMRESULT mmResult = waveOutSetPlaybackRate( m_hWaveOut, dwRate );
	WX_MM_ERROR2(mmResult, TEXT("waveOutSetPlaybackRate( m_hWaveOut, dwPitch )") );
	return mmResult;
}

/**********************************************************************//**
 *
 * ID擾
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
UINT CMMWaveOut::GetID(void)
{
	UINT id=0;
	WX_MM_CHECK_RESULT( waveOutGetID( m_hWaveOut, &id ) );
	return id;
}

/**********************************************************************//**
 *
 * bZ[WM
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
MMRESULT CMMWaveOut::Message(UINT uMsg, DWORD_PTR dw1, DWORD_PTR dw2)
{
	return waveOutMessage( m_hWaveOut, uMsg, dw1, dw2 );
}

/**********************************************************************//**
 *
 * foCX\̎擾
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
MMRESULT CMMWaveOut::GetDevCapsA(LPWAVEOUTCAPSA lpwoc)
{
	MMRESULT mmResult = waveOutGetDevCapsA( (UINT_PTR)m_hWaveOut, lpwoc, sizeof(WAVEOUTCAPSA) );
	WX_MM_ERROR2(mmResult, TEXT("waveOutGetDevCapsA( m_hWaveOut, lpwoc, sizeof(WAVEOUTCAPSA) )") );
	return mmResult;
}
/// CMMWaveOut::GetDevCapsW Q
MMRESULT CMMWaveOut::GetDevCapsW(LPWAVEOUTCAPSW lpwoc)
{
	MMRESULT mmResult = waveOutGetDevCapsW( (UINT_PTR)m_hWaveOut, lpwoc, sizeof(WAVEOUTCAPSW) );
	WX_MM_ERROR2(mmResult, TEXT("waveOutGetDevCapsW( m_hWaveOut, lpwoc, sizeof(WAVEOUTCAPSW) )") );
	return mmResult;
}

/**********************************************************************//**
 *
 * foCX̎擾
 *
 ----------------------------------------------------------------------
 * @return	foCX
*//***********************************************************************/
UINT CMMWaveOut::GetNumDevs(void)
{
	return waveOutGetNumDevs();
}

//**********************************************************************
//
// wrap
//
//***********************************************************************
MMRESULT CMMWaveOut::GetPosition(PMMTIME pmmt)	{ return waveOutGetPosition( m_hWaveOut, pmmt, sizeof(MMTIME) ); }

}	// end of namespace wx
}	// end of namespace iris
