//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMMPfmTimer.cpp
 * @brief		^C}[NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXMMPfmTimer_CPP_

//======================================================================
// include
#include "WXMMPfmTimer.h"
#include "fnd/system/FndFps.h"
#include <mmsystem.h>

//======================================================================
// link
#pragma comment( lib, "winmm.lib" )

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMMPfmTimer::CMMPfmTimer(void)
: m_ToMillisec(1)
{
	// v̑I
	LARGE_INTEGER cnt;
	if( (QueryPerformanceCounter(&cnt) != FALSE)
		&& (QueryPerformanceFrequency(&m_Freq) != FALSE) )
	{
		m_ToMillisec = 1000;
		m_bPfm = true;
	}
	else
	{
		m_Freq.QuadPart = 1;
		m_bPfm = false;
		timeBeginPeriod(1);
	}
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CMMPfmTimer::~CMMPfmTimer(void)
{
	if( !m_bPfm ) timeEndPeriod(1);
}

/**********************************************************************//**
 *
 * ݂̎擾
 *
 -----------------------------------------------------------------------
 * @return ݂̎
*//***********************************************************************/
u64 CMMPfmTimer::GetNowTime(void)
{
	if( !IsActive() ) return m_StopTime;
	if( !m_bPfm ) return (u64)timeGetTime();
	LARGE_INTEGER cnt;
	QueryPerformanceCounter(&cnt);
	return cnt.QuadPart;
}

/**********************************************************************//**
 *
 * oߎԂ̎擾
 *
 -----------------------------------------------------------------------
 * @return oߎ
*//***********************************************************************/
u64 CMMPfmTimer::GetElapsedMilliSecond(void)
{
	u64 time = GetNowTime();
	u64 elapsedtime = (time - m_LastTime) * m_ToMillisec / m_Freq.QuadPart;
	m_LastTime = time;
	return elapsedtime;
}

/**********************************************************************//**
 *
 * AvP[VԂ̎擾
 *
 -----------------------------------------------------------------------
 * @return NĂ̎
*//***********************************************************************/
u64 CMMPfmTimer::GetStockMilliSecond(void)
{
	u64 time = GetNowTime();
	return (time - m_BaseTime) * m_ToMillisec / m_Freq.QuadPart;
}

/**********************************************************************//**
 *
 * oߎԂ̎擾iXVj
 *
 -----------------------------------------------------------------------
 * @return oߎ
*//***********************************************************************/
u64 CMMPfmTimer::GetElapsedMilliSecondRef(void)
{
	u64 time = GetNowTime();
	u64 elapsedtime = (time - m_LastTime) * m_ToMillisec / m_Freq.QuadPart;
	return elapsedtime;
}

/**********************************************************************//**
 *
 * Sync
 *
 ----------------------------------------------------------------------
 * @return	syncꍇ́Atrue
*//***********************************************************************/
bool CMMPfmTimer::Sync(bool sleep)
{
	while(1)
	{
		u64 mspf = fnd::MSPF();
		u64 time = GetElapsedMilliSecondRef();
		if( time > mspf )
		{
			m_LastTime += mspf;
			return true;
		}
		if( !sleep ) break;

		Sleep((DWORD)(mspf-time));
	}
	return false;
}

/**********************************************************************//**
 *
 * oߎԂ̎擾iSyncj
 *
 -----------------------------------------------------------------------
 * @return oߎ
*//***********************************************************************/
float CMMPfmTimer::GetSyncElapsedSecond(void)
{
	return fnd::SPF();
}

}	// end of namespace wx
}	// end of namespace iris
