//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXHeap.h
 * @brief		q[vnhNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXHeap_H_
#define _IRIS_WXHeap_H_

//======================================================================
// include
#include "../base/WXHandle.h"

namespace iris {
namespace wx 
{

//======================================================================
// class
//! q[vnhNX
class CHeap : public CHandle
{
public:
	// RXgN^
	CHeap(void);
	CHeap(HANDLE hHeap);
	// fXgN^
	virtual	~CHeap(void);

public:
	// 쐬
	BOOL	Create(DWORD dwOptions, SIZE_T InitialSize, SIZE_T MaximumSize);
	// 폜
	BOOL	Destroy(void);

public:
	// m
	LPVOID	Alloc(DWORD dwFlags, SIZE_T Size);
	// ̍Ċ蓖
	LPVOID	ReAlloc(DWORD dwFlags, LPVOID lpMem, SIZE_T Size);
	// 
	BOOL	Free(DWORD dwFlags, LPVOID lpMem);

	// TCY
	SIZE_T	GetSize(DWORD dwFlags, LPVOID lpMem);

public:
	// bN
	BOOL	Lock(void);
	// bN
	BOOL	Unlock(void);
	// Compact
	SIZE_T	Compact(DWORD dwFlags);
	// 
	BOOL	Validate(DWORD dwFlags, LPVOID lpMem);
};

//! Processq[vnhNX
class CProcessHeap : public CHeap
{
public:
	// RXgN^
	CProcessHeap(void);
	// fXgN^
	virtual	~CProcessHeap(void);

public:
	// 擾
	BOOL	GetProcessHeap(void);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
