//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXClipboard.cpp
 * @brief		Nbv{[hNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXClipboard_CPP_

//======================================================================
// include
#include "WXClipboard.h"

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CClipboard::CClipboard(void)
: m_hOwner(nullptr)
, m_hViewer(nullptr)
, m_hPreViewer(nullptr)
, m_isOpen(false)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWndNewOwner	= I[i[EBhE
*//***********************************************************************/
CClipboard::CClipboard(HWND hWndNewOwner)
: m_hOwner(nullptr)
, m_hViewer(nullptr)
, m_hPreViewer(nullptr)
, m_isOpen(false)
{
	Open(hWndNewOwner);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CClipboard::~CClipboard(void)
{
	CloseViewer();
	Close();
}

/**********************************************************************//**
 *
 * J
 *
 -----------------------------------------------------------------------
 * @param [in]	hWndNewOwner	= VKI[i[EBhEnh
 * @return	
*//***********************************************************************/
BOOL CClipboard::Open(HWND hWndNewOwner)
{
	BOOL ret = OpenClipboard(hWndNewOwner);
	if( ret != 0 )
	{
		m_isOpen = true;
		m_hOwner = hWndNewOwner;
	}
	return ret;
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CClipboard::Close(void)
{
	if( !m_isOpen ) return FALSE;
	return CloseClipboard();
}

/**********************************************************************//**
 *
 * JĂ邩
 *
 -----------------------------------------------------------------------
 * @return	JĂTRUE
*//***********************************************************************/
bool CClipboard::IsOpen(void)
{
	return m_isOpen;
}

/**********************************************************************//**
 *
 * f[^ݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	uFormat	= tH[}bg(CF_*** or user register)
 * @param [in]	hMem	= f[^̃nh
 * @return	
*//***********************************************************************/
HANDLE CClipboard::SetData(UINT uFormat, HANDLE hMem)
{
	if( m_hOwner == nullptr ) return nullptr;
	return SetClipboardData(uFormat, hMem);
}

/**********************************************************************//**
 *
 * f[^擾
 *
 -----------------------------------------------------------------------
 * @param [in]	uFormat	= tH[}bg(CF_***)
 * @return	f[^̃nh
*//***********************************************************************/
HANDLE CClipboard::GetData(UINT uFormat)
{
	return GetClipboardData(uFormat);
}

/**********************************************************************//**
 *
 * f[^ɂ
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CClipboard::Empty(void)
{
	return EmptyClipboard();
}

/**********************************************************************//**
 *
 * f[^̗L
 *
 -----------------------------------------------------------------------
 * @return	L
*//***********************************************************************/
BOOL CClipboard::IsFormatAvailable(UINT uFormat)
{
	return IsClipboardFormatAvailable(uFormat);
}

/**********************************************************************//**
 *
 * I[i[EBhEnh擾
 *
 -----------------------------------------------------------------------
 * @return	I[i[EBhEnh
*//***********************************************************************/
HWND CClipboard::GetOwner(void)
{
	return GetClipboardOwner();
}

/**********************************************************************//**
 *
 * OpenĂEBhEnh擾
 *
 -----------------------------------------------------------------------
 * @return	EBhEnh
*//***********************************************************************/
HWND CClipboard::GetOpenWindow(void)
{
	return m_hOwner;
	//return GetOpenClipboardWindow();
}

/**********************************************************************//**
 *
 * Nbv{[h̃V[PXԍ擾
 *
 -----------------------------------------------------------------------
 * @return	Nbv{[h̃V[PXԍ
 * @retval	0 = EBhEXe[Vւ WINSTA_ACCESSCLIPBOARD ANZXȂ
*//***********************************************************************/
DWORD CClipboard::GetSequenceNumber(void)
{
	return GetClipboardSequenceNumber();
}

/**********************************************************************//**
 *
 * tH[}bg̎擾
 *
 -----------------------------------------------------------------------
 * @return	tH[}bg
*//***********************************************************************/
int CClipboard::CountFormats(void)
{
	return CountClipboardFormats();
}

/**********************************************************************//**
 *
 * tH[}bg̗
 *
 -----------------------------------------------------------------------
 * @return	JgtH[}bgiJn 0 j
 * @return	̃tH[}bg
*//***********************************************************************/
UINT CClipboard::EnumFormats(UINT uFormat)
{
	if( m_hOwner == nullptr ) return FALSE;
	return EnumClipboardFormats(uFormat);
}

/**********************************************************************//**
 *
 * Xg̒ŏɗpłNbv{[htH[}bg̎擾
 *
 -----------------------------------------------------------------------
 * @param [out]	paPriorityList	= o
 * @param [in]	nFormats		= paPriorityList̔z
 * @return	tH[}bg
 * @reval	0	= Nbv{[h
 * @reval	1	= XĝǂƂvȂ
*//***********************************************************************/
int CClipboard::GetPriorityFormat(UINT* paPriorityList, int nFormats)
{
	return GetPriorityClipboardFormat(paPriorityList, nFormats);
}

/**********************************************************************//**
 *
 * Nbv{[h̐VtH[}bg Windows VXeɓo^
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszFormat	= tH[}bg
 * @return	tH[}bgʎq
*//***********************************************************************/
UINT CClipboard::RegisterFormat (LPCTSTR lpszFormat)
{
	return RegisterClipboardFormat(lpszFormat);
}
/// CClipboard::RegisterFormat Q
UINT CClipboard::RegisterFormatA(LPCSTR  lpszFormat)
{
	return RegisterClipboardFormatA(lpszFormat);
}
/// CClipboard::RegisterFormat Q
UINT CClipboard::RegisterFormatW(LPCWSTR lpszFormat)
{
	return RegisterClipboardFormatW(lpszFormat);
}

/**********************************************************************//**
 *
 * o^ς݃tH[}bg擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszFormat		= 擾tH[}bg
 * @param [out]	lpszFormatName	= óBtH[}bg
 * @param [in]	cchMaxCount		= tH[}bg̃TCY
 * @return	o͂ɃRs[ꂽTCY
*//***********************************************************************/
int CClipboard::GetFormatName (UINT uFormat, LPTSTR lpszFormatName, int cchMaxCount)
{
	return GetClipboardFormatName (uFormat, lpszFormatName, cchMaxCount);
}
/// CClipboard::GetFormatName Q
int CClipboard::GetFormatNameA(UINT uFormat, LPSTR  lpszFormatName, int cchMaxCount)
{
	return GetClipboardFormatNameA(uFormat, lpszFormatName, cchMaxCount);
}
/// CClipboard::GetFormatName Q
int CClipboard::GetFormatNameW(UINT uFormat, LPWSTR lpszFormatName, int cchMaxCount)
{
	return GetClipboardFormatNameW(uFormat, lpszFormatName, cchMaxCount);
}

/**********************************************************************//**
 *
 * Nbv{[hr[Ã`FCɒǉ
 *
 * @note	Nbv{[hr[ÅeEBhE WM_DRAWCLIPBOARD bZ[W󂯎܂
 *
 -----------------------------------------------------------------------
 * @param [in]	hViewer	= ǉEBhEnh
 * @return	ȑÕnh
*//***********************************************************************/
HWND CClipboard::SetViewer(HWND hViewer)
{
	CloseViewer();
	m_hViewer = hViewer;
	m_hPreViewer = SetClipboardViewer(hViewer);
	return m_hPreViewer;
}

/**********************************************************************//**
 *
 * Nbv{[hr[Ã`FCɂŏ̃EBhE擾
 *
 -----------------------------------------------------------------------
 * @return	EBhEnh
*//***********************************************************************/
HWND CClipboard::GetViewer(void)
{
	return GetClipboardViewer();
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CClipboard::CloseViewer(void)
{
	HWND hViewer = GetViewer();
	if( m_hViewer != hViewer )
	{
		// OŐ擪ς
		m_hPreViewer = hViewer;
	}
	if( m_hPreViewer == nullptr ) return FALSE;
	ChangeChain(m_hViewer, m_hPreViewer);
	m_hViewer = nullptr;
	m_hPreViewer = nullptr;
	return TRUE;
}

/**********************************************************************//**
 *
 * Nbv{[hr[Ã`FCAw肳ꂽEBhE폜
 *
 -----------------------------------------------------------------------
 * @param [in]	hRemove		= 폜nh
 * @param [in]	hNewNext	= ̃nh
 * @return	
*//***********************************************************************/
BOOL CClipboard::ChangeChain(HWND hRemove, HWND hNewNext)
{
	return ChangeClipboardChain(hRemove, hNewNext);
}

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../debug/unittest/WXDebugUnitTest.h"
#include <tchar.h>
#include "iris_iostream.h"
#include "iris.h"
#include "../memory/WXGlobalMemory.h"

//======================================================================
// test
IRIS_UNITTEST(CWXClipboardUnitTest,WXClipboardUnitTest)
{
	CClipboard clip;
	if( !clip.Open(GetDesktopWindow()) ) return;

	for( int i=0; i < 2; ++i )
	{
		CGMem gmem;
		if( clip.IsFormatAvailable(CF_TEXT) )
		{
			gmem = clip.GetData(CF_TEXT);
			LPVOID p = gmem.Lock();
			if( p != nullptr )
			{
				char* c = (char*)p;
				puts(c);
				gmem.Unlock();
			}
			gmem.Detach();
		}
		if( i == 1 ) break;

		clip.Empty();
		char buf[256];
		std::cout << "͂ĂB" << std::endl;
		std::cin >> buf;
		size_t len = strlen(buf) + 1;
		gmem.Alloc(GHND, len);
		char* p = (char*)gmem.Lock();
		if( p != nullptr )
		{
			strcpy_s(p, len, buf);
			clip.SetData(CF_TEXT, gmem );
			gmem.Unlock();
			gmem.Detach();
		}
	}
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

