//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXAccelerator.h
 * @brief		ANZ[^NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXAccelerator_H_
#define _IRIS_WXAccelerator_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	ANZ[^NX
 * @note	.cppɎLqׂÃbp[NXȂ̂
 *			vWFNgグ̎ԂȂ߂ɁA.hɂ܂B
*/
class CAccelerator : public IIrisObject
{
protected:
	HACCEL	m_hAccel;	//!< ANZ[^nh

public:
	/// RXgN^
	CAccelerator(void) : m_hAccel(nullptr) {}
	/// RXgN^
	CAccelerator(HACCEL hAccel) : m_hAccel(nullptr) { Attach(hAccel); }

	/// fXgN^
	~CAccelerator(void)
	{
		Destroy();
	}

	HACCEL						GetAccel(void)		{ return m_hAccel; }	//!< nh̎擾
					operator	HACCEL (void)		{ return m_hAccel; }
	HACCEL			operator	() (void)			{ return m_hAccel; }
	CAccelerator&	operator	= (HACCEL hAccel)	{ Attach(hAccel); return *this; }

public:
	/**
	 * @brief	֘At
	 * @param [in] hAccel	= ֘Atnh
	 * @return 
	*/
	BOOL	Attach(HACCEL hAccel)
	{
		if( hAccel == nullptr || m_hAccel != nullptr ) return FALSE;
		m_hAccel = hAccel;
		return TRUE;
	}

	/**
	 * @brief	֘At̉
	 * @return ȑÕnh
	*/
	HACCEL	Detach(void)
	{
		HACCEL hPre = m_hAccel;
		m_hAccel = nullptr;
		return hPre;
	}

public:
	/**
	 * @brief	ANZ[^e[u̍쐬
	 * @param [in]	lpAccel = e[u
	 * @param [in]	nAccel	= e[u̔zvf
	 * @return 
	*/
	BOOL	Create(LPACCEL lpAccel, s32 nAccel)
	{
#ifdef UNICODE
		return CreateW(lpAccel, nAccel);
#else
		return CreateA(lpAccel, nAccel);
#endif
	}
	/// CAccelerator::Create Q
	BOOL	CreateA(LPACCEL lpAccel, s32 nAccel)
	{
		HACCEL hAccel = CreateAcceleratorTableA(lpAccel, nAccel);
		if( !Attach(hAccel) )
		{
			DestroyAcceleratorTable(hAccel);
			return FALSE;
		}
		return TRUE;
	}
	/// CAccelerator::Create Q
	BOOL	CreateW(LPACCEL lpAccel, s32 nAccel)
	{
		HACCEL hAccel = CreateAcceleratorTableW(lpAccel, nAccel);
		if( !Attach(hAccel) )
		{
			DestroyAcceleratorTable(hAccel);
			return FALSE;
		}
		return TRUE;
	}

	/**
	 * @brief	ANZ[^e[u̔j
	 * @return 
	*/
	BOOL	Destroy(void)
	{
		return DestroyAcceleratorTable(Detach());
	}

	/**
	 * @brief	ANZ[^e[ũ\[Xǂݍ
	 * @param [in]	hInstance	= CX^Xnh
	 * @param [in]	lpTableName	= e[u
	 * @return 
	*/
	BOOL	Load (HINSTANCE hInstance, LPCTSTR lpTableName)
	{
#ifdef UNICODE
		return LoadW(hInstance, lpTableName);
#else
		return LoadA(hInstance, lpTableName);
#endif
	}
	/// CAccelerator::Load Q
	BOOL	LoadA(HINSTANCE hInstance, LPCSTR  lpTableName)
	{
		HACCEL hAccel = LoadAcceleratorsA(hInstance, lpTableName);
		if( !Attach(hAccel) )
		{
			DestroyAcceleratorTable(hAccel);
			return FALSE;
		}
		return TRUE;
	}
	/// CAccelerator::Load Q
	BOOL	LoadW(HINSTANCE hInstance, LPCWSTR lpTableName)
	{
		HACCEL hAccel = LoadAcceleratorsW(hInstance, lpTableName);
		if( !Attach(hAccel) )
		{
			DestroyAcceleratorTable(hAccel);
			return FALSE;
		}
		return TRUE;
	}

public:
	/**
	 * @brief	ANZ[^̏
	 * @param [in]	hWnd	= EBhEnh
	 * @param [in]	lpMsg	= bZ[W
	 * @return 
	*/
	BOOL	Translate(HWND hWnd, LPMSG lpMsg)
	{
#ifdef UNICODE
		return TranslateW(hWnd, lpMsg);
#else
		return TranslateA(hWnd, lpMsg);
#endif
	}
	/// CAccelerator::Translate Q
	BOOL	TranslateA(HWND hWnd, LPMSG lpMsg)
	{
		return TranslateAcceleratorA(hWnd, m_hAccel, lpMsg);
	}
	/// CAccelerator::Translate Q
	BOOL	TranslateW(HWND hWnd, LPMSG lpMsg)
	{
		return TranslateAcceleratorW(hWnd, m_hAccel, lpMsg);
	}

};

}	// end of namespace wx
}	// end of namespace iris

#endif
