//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXUrlCach.h
 * @brief		C^[lbgLbVnhNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXUrlCach_H_
#define _IRIS_WXUrlCach_H_

//======================================================================
// include
#include "../base/WXHandle.h"
#include <wininet.h>

namespace iris {
namespace wx
{

//======================================================================
// class
//! C^[lbgLbVnhNX
class CUrlCach : public CHandle
{
public:
	// RXgN^
	CUrlCach(void);
	CUrlCach(HANDLE hCach);
	// fXgN^
	~CUrlCach(void);

public:

	// 
	BOOL	Close(void);

public:
	// LbV
	BOOL	FindFirst (LPCTSTR lpszUrlSearchPattern, LPINTERNET_CACHE_ENTRY_INFO  lpCacheEntry, LPDWORD lpdwBufferSize);
	BOOL	FindFirstA(LPCSTR  lpszUrlSearchPattern, LPINTERNET_CACHE_ENTRY_INFOA lpCacheEntry, LPDWORD lpdwBufferSize);
	BOOL	FindFirstW(LPCWSTR lpszUrlSearchPattern, LPINTERNET_CACHE_ENTRY_INFOW lpCacheEntry, LPDWORD lpdwBufferSize);
	// 
	BOOL	FindNext (LPINTERNET_CACHE_ENTRY_INFO  lpCacheEntry, LPDWORD lpdwBufferSize);
	BOOL	FindNextA(LPINTERNET_CACHE_ENTRY_INFOA lpCacheEntry, LPDWORD lpdwBufferSize);
	BOOL	FindNextW(LPINTERNET_CACHE_ENTRY_INFOW lpCacheEntry, LPDWORD lpdwBufferSize);

public:
	// LbV
	BOOL	FindFirstEx (LPCTSTR lpszUrlSearchPattern, DWORD dwFlags, DWORD dwFilter, GROUPID GroupId
				, LPINTERNET_CACHE_ENTRY_INFO  lpCacheEntry, LPDWORD lpdwBufferSize);
	BOOL	FindFirstExA(LPCSTR  lpszUrlSearchPattern, DWORD dwFlags, DWORD dwFilter, GROUPID GroupId
				, LPINTERNET_CACHE_ENTRY_INFOA lpCacheEntry, LPDWORD lpdwBufferSize);
	BOOL	FindFirstExW(LPCWSTR lpszUrlSearchPattern, DWORD dwFlags, DWORD dwFilter, GROUPID GroupId
				, LPINTERNET_CACHE_ENTRY_INFOW lpCacheEntry, LPDWORD lpdwBufferSize);
	// 
	BOOL	FindNextEx (LPINTERNET_CACHE_ENTRY_INFO  lpCacheEntry, LPDWORD lpdwBufferSize);
	BOOL	FindNextExA(LPINTERNET_CACHE_ENTRY_INFOA lpCacheEntry, LPDWORD lpdwBufferSize);
	BOOL	FindNextExW(LPINTERNET_CACHE_ENTRY_INFOW lpCacheEntry, LPDWORD lpdwBufferSize);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
