//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXInternet.h
 * @brief		C^[lbgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXInternet_H_
#define _IRIS_WXInternet_H_

//======================================================================
// include
#include "WXInetBase.h"

namespace iris {
namespace wx
{

//======================================================================
// class
//! C^[lbgNX
class CInternet : public CInetBase
{
public:
	// RXgN^
	CInternet(void);
	CInternet(HINTERNET hInternet);
	// fXgN^
	~CInternet(void);

public:
	// J
	BOOL		Open (LPCTSTR lpszAgent, DWORD dwAccessType
						, LPCTSTR lpszProxy=nullptr, LPCTSTR lpszProxyBypass=nullptr, DWORD dwFlags=0);
	BOOL		OpenA(LPCSTR  lpszAgent, DWORD dwAccessType
						, LPCSTR  lpszProxy=nullptr, LPCSTR  lpszProxyBypass=nullptr, DWORD dwFlags=0);
	BOOL		OpenW(LPCWSTR lpszAgent, DWORD dwAccessType
						, LPCWSTR lpszProxy=nullptr, LPCWSTR lpszProxyBypass=nullptr, DWORD dwFlags=0);

	// ڑ
	HINTERNET	Connect (LPCTSTR lpszServerName, INTERNET_PORT nServerPort
						, LPCTSTR lpszUserName, LPCTSTR lpszPassword
						, DWORD dwService, DWORD dwFlags, DWORD_PTR dwContext=0);
	HINTERNET	ConnectA(LPCSTR  lpszServerName, INTERNET_PORT nServerPort
						, LPCSTR  lpszUserName, LPCSTR  lpszPassword
						, DWORD dwService, DWORD dwFlags, DWORD_PTR dwContext=0);
	HINTERNET	ConnectW(LPCWSTR lpszServerName, INTERNET_PORT nServerPort
						, LPCWSTR lpszUserName, LPCWSTR lpszPassword
						, DWORD dwService, DWORD dwFlags, DWORD_PTR dwContext=0);

public:

	// URL open
	HINTERNET	OpenUrl (LPCTSTR lpszUrl, LPCTSTR lpszHeaders, DWORD dwHeadersLen, DWORD dwFlags, DWORD_PTR dwContext=0);
	HINTERNET	OpenUrlA(LPCSTR  lpszUrl, LPCSTR  lpszHeaders, DWORD dwHeadersLen, DWORD dwFlags, DWORD_PTR dwContext=0);
	HINTERNET	OpenUrlW(LPCWSTR lpszUrl, LPCWSTR lpszHeaders, DWORD dwHeadersLen, DWORD dwFlags, DWORD_PTR dwContext=0);

	// IvV̎擾
	BOOL		QueryOption (DWORD dwOption, LPVOID lpBuffer, LPDWORD lpdwBufferLength);
	BOOL		QueryOptionA(DWORD dwOption, LPVOID lpBuffer, LPDWORD lpdwBufferLength);
	BOOL		QueryOptionW(DWORD dwOption, LPVOID lpBuffer, LPDWORD lpdwBufferLength);

	// IvV̐ݒ
	BOOL		SetOption (DWORD dwOption, LPVOID lpBuffer, DWORD dwBufferLength);
	BOOL		SetOptionA(DWORD dwOption, LPVOID lpBuffer, DWORD dwBufferLength);
	BOOL		SetOptionW(DWORD dwOption, LPVOID lpBuffer, DWORD dwBufferLength);

	// IvV̐ݒ
	BOOL		SetOptionEx (DWORD dwOption, LPVOID lpBuffer, DWORD dwBufferLength, DWORD dwFlags);
	BOOL		SetOptionExA(DWORD dwOption, LPVOID lpBuffer, DWORD dwBufferLength, DWORD dwFlags);
	BOOL		SetOptionExW(DWORD dwOption, LPVOID lpBuffer, DWORD dwBufferLength, DWORD dwFlags);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
