//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXInternet.cpp
 * @brief		C^[lbgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXInternet_CPP_

//======================================================================
// include
#include "WXInternet.h"

//======================================================================
#pragma comment ( lib, "wininet.lib" )

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CInternet::CInternet(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hIneternet		= ֘Atnh
*//***********************************************************************/
CInternet::CInternet(HINTERNET hInternet)
: CInetBase(hInternet)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CInternet::~CInternet(void)
{
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszAgent		= G[WFg
 * @param [in]	dwAccessType	= ANZX@(INTERNET_OPEN_***)
 * @param [in]	lpszProxy		= vLVT[o(nullptr̂Ƃ́AWXg擾)
 * @param [in]	lpszProxyBypass	= m̃zXgAIPAhX̃Xg
 * @param [in]	dwFlags			= tO(INTERNET_FLAG_***)
 * @return	
*//***********************************************************************/
BOOL CInternet::Open (LPCTSTR lpszAgent, DWORD dwAccessType
					  , LPCTSTR lpszProxy, LPCTSTR lpszProxyBypass, DWORD dwFlags)
{
	m_hInternet = InternetOpen (lpszAgent, dwAccessType, lpszProxy, lpszProxyBypass, dwFlags);
	if( m_hInternet == nullptr ) return FALSE;
	return TRUE;
}
/// CInternet::Open Q
BOOL CInternet::OpenA(LPCSTR  lpszAgent, DWORD dwAccessType
					  , LPCSTR  lpszProxy, LPCSTR  lpszProxyBypass, DWORD dwFlags)
{
	m_hInternet = InternetOpenA(lpszAgent, dwAccessType, lpszProxy, lpszProxyBypass, dwFlags);
	if( m_hInternet == nullptr ) return FALSE;
	return TRUE;
}
/// CInternet::Open Q
BOOL CInternet::OpenW(LPCWSTR lpszAgent, DWORD dwAccessType
					  , LPCWSTR lpszProxy, LPCWSTR lpszProxyBypass, DWORD dwFlags)
{
	m_hInternet = InternetOpenW(lpszAgent, dwAccessType, lpszProxy, lpszProxyBypass, dwFlags);
	if( m_hInternet == nullptr ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * ڑ
 *
 * @note	FTP̏ꍇAlpszUserName=nullptr && lpszPassword=nullptre-mailAhXɂȂ
 * 
 ----------------------------------------------------------------------
 * @param [in]	lpszServerName	= T[o[܂́AIPAhX
 * @param [in]	nServerPort		= T[o[|[gԍ(0=ftHg)
 * @param [in]	lpszUserName	= [U[(nullptr=ftHg)
 * @param [in]	lpszPassword	= pX[h(nullptr\)
 * @param [in]	dwService		= T[rX̃^Cv(INTERNET_SERVICE_***)
 * @param [in]	dwFlags			= T[rXŗL̃tO
 * @param [in]	dwContext		= R[obN֐ɓnl
 * @return	
*//***********************************************************************/
HINTERNET CInternet::Connect (LPCTSTR lpszServerName, INTERNET_PORT nServerPort
							  , LPCTSTR lpszUserName, LPCTSTR lpszPassword
							  , DWORD dwService, DWORD dwFlags, DWORD_PTR dwContext)
{
	if( m_hInternet == nullptr ) return nullptr;
	return InternetConnect (m_hInternet
		, lpszServerName
		, nServerPort
		, lpszUserName
		, lpszPassword
		, dwService
		, dwFlags
		, dwContext);
}
/// CInternet::Connect Q
HINTERNET CInternet::ConnectA(LPCSTR  lpszServerName, INTERNET_PORT nServerPort
							  , LPCSTR  lpszUserName, LPCSTR  lpszPassword
							  , DWORD dwService, DWORD dwFlags, DWORD_PTR dwContext)
{
	if( m_hInternet == nullptr ) return nullptr;
	return InternetConnectA(m_hInternet
		, lpszServerName
		, nServerPort
		, lpszUserName
		, lpszPassword
		, dwService
		, dwFlags
		, dwContext);
}
/// CInternet::Connect Q
HINTERNET CInternet::ConnectW(LPCWSTR lpszServerName, INTERNET_PORT nServerPort
							  , LPCWSTR lpszUserName, LPCWSTR lpszPassword
							  , DWORD dwService, DWORD dwFlags, DWORD_PTR dwContext)
{
	if( m_hInternet == nullptr ) return nullptr;
	return InternetConnectW(m_hInternet
		, lpszServerName
		, nServerPort
		, lpszUserName
		, lpszPassword
		, dwService
		, dwFlags
		, dwContext);
}

/**********************************************************************//**
 *
 * URL open
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszUrl			= URL
 * @param [in]	lpszHeaders		= HTTPT[o[wb_(nullptr\)
 * @param [in]	dwHeadersLen	= lpszHeaders̃TCY(-1=vZ)
 * @param [in]	dwFlags			= tO(INTERNET_FLAG_***)
 * @param [in]	dwContext		= R[obN֐ɓnl
 * @return	
*//***********************************************************************/
HINTERNET CInternet::OpenUrl (LPCTSTR lpszUrl, LPCTSTR lpszHeaders, DWORD dwHeadersLen, DWORD dwFlags, DWORD_PTR dwContext)
{
	return InternetOpenUrl (m_hInternet, lpszUrl, lpszHeaders, dwHeadersLen, dwFlags, dwContext);
}
/// CInternet::OpenUrl Q
HINTERNET CInternet::OpenUrlA(LPCSTR  lpszUrl, LPCSTR  lpszHeaders, DWORD dwHeadersLen, DWORD dwFlags, DWORD_PTR dwContext)
{
	return InternetOpenUrlA(m_hInternet, lpszUrl, lpszHeaders, dwHeadersLen, dwFlags, dwContext);
}
/// CInternet::OpenUrl Q
HINTERNET CInternet::OpenUrlW(LPCWSTR lpszUrl, LPCWSTR lpszHeaders, DWORD dwHeadersLen, DWORD dwFlags, DWORD_PTR dwContext)
{
	return InternetOpenUrlW(m_hInternet, lpszUrl, lpszHeaders, dwHeadersLen, dwFlags, dwContext);
}

/**********************************************************************//**
 *
 * IvV̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	dwOption			= 擾w肷tO(INTERNET_OPTION_***)
 * @param [in]	lpBuffer			= o̓obt@
 * @param [in]	lpdwBufferLength	= lpBufferTCYA܂ꂽiKvȁjTCYԂ
 * @return	
*//***********************************************************************/
BOOL CInternet::QueryOption (DWORD dwOption, LPVOID lpBuffer, LPDWORD lpdwBufferLength)
{
	return InternetQueryOption (m_hInternet, dwOption, lpBuffer, lpdwBufferLength);
}
/// CInternet::QueryOption Q
BOOL CInternet::QueryOptionA(DWORD dwOption, LPVOID lpBuffer, LPDWORD lpdwBufferLength)
{
	return InternetQueryOptionA(m_hInternet, dwOption, lpBuffer, lpdwBufferLength);
}
/// CInternet::QueryOption Q
BOOL CInternet::QueryOptionW(DWORD dwOption, LPVOID lpBuffer, LPDWORD lpdwBufferLength)
{
	return InternetQueryOptionW(m_hInternet, dwOption, lpBuffer, lpdwBufferLength);
}

/**********************************************************************//**
 *
 * IvV̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	dwOption			= IvV(INTERNET_OPTION_***)
 * @param [in]	lpBuffer			= ̓obt@
 * @param [in]	dwBufferLength		= ̓obt@
 * @return	
*//***********************************************************************/
BOOL CInternet::SetOption (DWORD dwOption, LPVOID lpBuffer, DWORD dwBufferLength)
{
	return InternetSetOption (m_hInternet, dwOption, lpBuffer, dwBufferLength);
}
/// CInternet::QueryOption Q
BOOL CInternet::SetOptionA(DWORD dwOption, LPVOID lpBuffer, DWORD dwBufferLength)
{
	return InternetSetOptionA(m_hInternet, dwOption, lpBuffer, dwBufferLength);
}
/// CInternet::QueryOption Q
BOOL CInternet::SetOptionW(DWORD dwOption, LPVOID lpBuffer, DWORD dwBufferLength)
{
	return InternetSetOptionW(m_hInternet, dwOption, lpBuffer, dwBufferLength);
}

/**********************************************************************//**
 *
 * IvV̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	dwOption			= IvV(INTERNET_OPTION_***)
 * @param [in]	lpBuffer			= ̓obt@
 * @param [in]	dwBufferLength		= ̓obt@
 * @param [in]	dwFlags				= 
 * @return	
*//***********************************************************************/
BOOL CInternet::SetOptionEx (DWORD dwOption, LPVOID lpBuffer, DWORD dwBufferLength, DWORD dwFlags)
{
	return InternetSetOptionEx (m_hInternet, dwOption, lpBuffer, dwBufferLength, dwFlags);
}
/// CInternet::QueryOption Q
BOOL CInternet::SetOptionExA(DWORD dwOption, LPVOID lpBuffer, DWORD dwBufferLength, DWORD dwFlags)
{
	return InternetSetOptionExA(m_hInternet, dwOption, lpBuffer, dwBufferLength, dwFlags);
}
/// CInternet::QueryOption Q
BOOL CInternet::SetOptionExW(DWORD dwOption, LPVOID lpBuffer, DWORD dwBufferLength, DWORD dwFlags)
{
	return InternetSetOptionExW(m_hInternet, dwOption, lpBuffer, dwBufferLength, dwFlags);
}

}	// end of namespace wx
}	// end of namespace iris
