//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXFTP.cpp
 * @brief		FTPNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXFTP_CPP_

//======================================================================
// include
#include "WXFTP.h"

//======================================================================
#pragma comment ( lib, "wininet.lib" )

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CFTP::CFTP(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hConnect		= ֘Atnh
*//***********************************************************************/
CFTP::CFTP(HINTERNET hConnect)
: CInetBase(hConnect)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CFTP::~CFTP(void)
{
}

/**********************************************************************//**
 *
 * t@C
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszSearchFile	= t@C(nullptr\)
 * @param [in]	lpFindFileData	= 
 * @param [in]	dwFlags			= tO(INTERNET_FLAG_***)
 * @param [in]	dwContext		= R[obN֐ɓnl
 * @return	
*//***********************************************************************/
HINTERNET CFTP::FindFirstFileA(LPCSTR  lpszSearchFile, LPWIN32_FIND_DATAA lpFindFileData, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::FtpFindFirstFileA(m_hInternet, lpszSearchFile, lpFindFileData, dwFlags, dwContext);
}
/// CFTP::FindFirstFileA Q
HINTERNET CFTP::FindFirstFileW(LPCWSTR lpszSearchFile, LPWIN32_FIND_DATAW lpFindFileData, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::FtpFindFirstFileW(m_hInternet, lpszSearchFile, lpFindFileData, dwFlags, dwContext);
}

/**********************************************************************//**
 *
 * [gt@C擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszRemoteFile	= [g̃t@C
 * @param [in]	lpszNewFile		= ]t@C
 * @param [in]	bExists			= [JɊɑ݂ꍇɃG[ɂꍇ́ATRUE
 * @param [in]	dwAttributes	= FILE_ATTRIBUTE_***
 * @param [in]	dwFlags			= tO(FTP_TRANSFER_TYPE_*** or INTERNET_FLAG_***)
 * @param [in]	dwContext		= R[obN֐ɓnl
 * @return	
*//***********************************************************************/
BOOL CFTP::GetFile (LPCTSTR lpszRemoteFile, LPCTSTR lpszNewFile, BOOL bExists, DWORD dwAttributes, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::FtpGetFile (m_hInternet, lpszRemoteFile, lpszNewFile, bExists, dwAttributes, dwFlags, dwContext);
}
/// CFTP::GetFile Q
BOOL CFTP::GetFileA(LPCSTR  lpszRemoteFile, LPCSTR  lpszNewFile, BOOL bExists, DWORD dwAttributes, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::FtpGetFileA(m_hInternet, lpszRemoteFile, lpszNewFile, bExists, dwAttributes, dwFlags, dwContext);
}
/// CFTP::GetFile Q
BOOL CFTP::GetFileW(LPCWSTR lpszRemoteFile, LPCWSTR lpszNewFile, BOOL bExists, DWORD dwAttributes, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::FtpGetFileW(m_hInternet, lpszRemoteFile, lpszNewFile, bExists, dwAttributes, dwFlags, dwContext);
}
/// CFTP::GetFile Q
BOOL CFTP::GetFileEx(LPCSTR lpszRemoteFile, LPCWSTR lpszNewFile, BOOL bExists, DWORD dwAttributes, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::FtpGetFileEx(m_hInternet, lpszRemoteFile, lpszNewFile, bExists, dwAttributes, dwFlags, dwContext);
}

/**********************************************************************//**
 *
 * [J烊[g̃t@C]
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszLocalFile			= [Jt@C
 * @param [in]	lpszNewRemoteFile		= ]t@C
 * @param [in]	dwFlags					= tO(INTERNET_FLAG_***)
 * @param [in]	dwContext				= R[obN֐ɓnl
 * @return	
*//***********************************************************************/
BOOL CFTP::PutFile (LPCTSTR lpszLocalFile, LPCTSTR lpszNewRemoteFile, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::FtpPutFile (m_hInternet, lpszLocalFile, lpszNewRemoteFile, dwFlags, dwContext);
}
/// CFTP::PutFile Q
BOOL CFTP::PutFileA(LPCSTR  lpszLocalFile, LPCSTR  lpszNewRemoteFile, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::FtpPutFileA(m_hInternet, lpszLocalFile, lpszNewRemoteFile, dwFlags, dwContext);
}
/// CFTP::PutFile Q
BOOL CFTP::PutFileW(LPCWSTR lpszLocalFile, LPCWSTR lpszNewRemoteFile, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::FtpPutFileW(m_hInternet, lpszLocalFile, lpszNewRemoteFile, dwFlags, dwContext);
}
/// CFTP::PutFile Q
BOOL CFTP::PutFileEx(LPCWSTR lpszLocalFile, LPCSTR lpszNewRemoteFile, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::FtpPutFileEx(m_hInternet, lpszLocalFile, lpszNewRemoteFile, dwFlags, dwContext);
}

/**********************************************************************//**
 *
 * t@C폜
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszFileName	= t@C
 * @return	
*//***********************************************************************/
BOOL CFTP::DeleteFileA(LPCSTR  lpszFileName)
{
	return ::FtpDeleteFileA(m_hInternet, lpszFileName);
}
/// CFTP::DeleteFileA Q
BOOL CFTP::DeleteFileW(LPCWSTR lpszFileName)
{
	return ::FtpDeleteFileW(m_hInternet, lpszFileName);
}

/**********************************************************************//**
 *
 * l[
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszExisting	= ̃t@C
 * @param [in]	lpszNew			= VKt@C
 * @return	
*//***********************************************************************/
BOOL CFTP::RenameFile (LPCTSTR lpszExisting, LPCTSTR lpszNew)
{
	return ::FtpRenameFile (m_hInternet, lpszExisting, lpszNew);
}
/// CFTP::RenameFile Q
BOOL CFTP::RenameFileA(LPCSTR  lpszExisting, LPCSTR  lpszNew)
{
	return ::FtpRenameFileA(m_hInternet, lpszExisting, lpszNew);
}
/// CFTP::RenameFile Q
BOOL CFTP::RenameFileW(LPCWSTR lpszExisting, LPCWSTR lpszNew)
{
	return ::FtpRenameFileW(m_hInternet, lpszExisting, lpszNew);
}

/**********************************************************************//**
 *
 * t@CJ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszFileName	= t@C
 * @param [in]	dwAccess		= ANZXtO(GENERIC_READ, GENERIC_WRITE)
 * @param [in]	dwFlags			= tO((FTP_TRANSFER_TYPE_*** or INTERNET_FLAG_***))
 * @param [in]	dwContext		= R[obN֐ɓnl
 * @return	
*//***********************************************************************/
HINTERNET CFTP::OpenFile (LPCTSTR lpszFileName, DWORD dwAccess, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::FtpOpenFile (m_hInternet, lpszFileName, dwAccess, dwFlags, dwContext);
}
/// CFTP::OpenFile Q
HINTERNET CFTP::OpenFileA(LPCSTR  lpszFileName, DWORD dwAccess, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::FtpOpenFileA(m_hInternet, lpszFileName, dwAccess, dwFlags, dwContext);
}
/// CFTP::OpenFile Q
HINTERNET CFTP::OpenFileW(LPCWSTR lpszFileName, DWORD dwAccess, DWORD dwFlags, DWORD_PTR dwContext)
{
	return ::FtpOpenFileW(m_hInternet, lpszFileName, dwAccess, dwFlags, dwContext);
}

/**********************************************************************//**
 *
 * fBNg쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszDirectory	= fBNg
 * @return	
*//***********************************************************************/
BOOL CFTP::CreateDirectoryA(LPCSTR  lpszDirectory)
{
	return ::FtpCreateDirectoryA(m_hInternet, lpszDirectory);
}
/// CFTP::CreateDirectoryA Q
BOOL CFTP::CreateDirectoryW(LPCWSTR lpszDirectory)
{
	return ::FtpCreateDirectoryW(m_hInternet, lpszDirectory);
}

/**********************************************************************//**
 *
 * fBNg폜
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszDirectory	= fBNg
 * @return	
*//***********************************************************************/
BOOL CFTP::RemoveDirectoryA(LPCSTR  lpszDirectory)
{
	return ::FtpRemoveDirectoryA(m_hInternet, lpszDirectory);
}
/// CFTP::RemoveDirectoryA Q
BOOL CFTP::RemoveDirectoryW(LPCWSTR lpszDirectory)
{
	return ::FtpRemoveDirectoryW(m_hInternet, lpszDirectory);
}

/**********************************************************************//**
 *
 * JgfBNgύX
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszDirectory	= JgfBNg
 * @return	
*//***********************************************************************/
BOOL CFTP::SetCurrentDirectoryA(LPCSTR  lpszDirectory)
{
	return ::FtpSetCurrentDirectoryA(m_hInternet, lpszDirectory);
}
/// CFTP::SetCurrentDirectoryA Q
BOOL CFTP::SetCurrentDirectoryW(LPCWSTR lpszDirectory)
{
	return ::FtpSetCurrentDirectoryW(m_hInternet, lpszDirectory);
}

/**********************************************************************//**
 *
 * JgfBNg擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszDirectory	= óBJgfBNg
 * @param [in]	lpdwSize		= obt@TCYíj݃TCYiój
 * @return	
*//***********************************************************************/
BOOL CFTP::GetCurrentDirectoryA(LPSTR  lpszDirectory, LPDWORD lpdwSize)
{
	return ::FtpGetCurrentDirectoryA(m_hInternet, lpszDirectory, lpdwSize);
}
/// CFTP::GetCurrentDirectoryA Q
BOOL CFTP::GetCurrentDirectoryW(LPWSTR lpszDirectory, LPDWORD lpdwSize)
{
	return ::FtpGetCurrentDirectoryW(m_hInternet, lpszDirectory, lpdwSize);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	fExpectResponse	= 
 * @param [in]	dwFlags			= 
 * @param [in]	lpszCommand		= 
 * @param [in]	dwContext		= R[obN֐ɓnl
 * @param [in]	phFtpCommand	= 
 * @return	
*//***********************************************************************/
BOOL CFTP::Command (BOOL fExpectResponse, DWORD dwFlags, LPCTSTR lpszCommand, DWORD_PTR dwContext, HINTERNET *phFtpCommand)
{
	return ::FtpCommand (m_hInternet, fExpectResponse, dwFlags, lpszCommand, dwContext, phFtpCommand);
}
/// CFTP::Command Q
BOOL CFTP::CommandA(BOOL fExpectResponse, DWORD dwFlags, LPCSTR  lpszCommand, DWORD_PTR dwContext, HINTERNET *phFtpCommand)
{
	return ::FtpCommandA(m_hInternet, fExpectResponse, dwFlags, lpszCommand, dwContext, phFtpCommand);
}
/// CFTP::Command Q
BOOL CFTP::CommandW(BOOL fExpectResponse, DWORD dwFlags, LPCWSTR lpszCommand, DWORD_PTR dwContext, HINTERNET *phFtpCommand)
{
	return ::FtpCommandW(m_hInternet, fExpectResponse, dwFlags, lpszCommand, dwContext, phFtpCommand);
}

/**********************************************************************//**
 *
 * t@CTCY擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpdwFileSizeHigh	= 
 * @return	
*//***********************************************************************/
DWORD CFTP::FtpGetFileSize(LPDWORD lpdwFileSizeHigh)
{
	return ::FtpGetFileSize(m_hInternet, lpdwFileSizeHigh);
}

}	// end of namespace wx
}	// end of namespace iris
