//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXIMM.cpp
 * @brief		IMMNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXIMM_CPP_

//======================================================================
// include
#include "WXIMM.h"

//======================================================================
// link
#pragma comment( lib, "imm32.lib" )

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CIMM::CIMM(void)
: m_hImc(nullptr)
, m_hWnd(nullptr)
, m_dwThread(0)	// JgXbh
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CIMM::~CIMM(void)
{
	Close();
	Destroy();
}

/**********************************************************************//**
 *
 * HKL̎擾
 *
*//***********************************************************************/
HKL CIMM::GetHKL(void)
{
	return GetKeyboardLayout(m_dwThread);
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	
*//***********************************************************************/
BOOL CIMM::Open(HWND hWnd)
{
	Close();
	Destroy();
	m_hImc = ImmGetContext(hWnd);
	if( m_hImc == nullptr ) return FALSE;
	m_hWnd = hWnd;
	return TRUE;
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CIMM::Close(void)
{
	if( m_hWnd == nullptr ) return TRUE;
	if( m_hImc == nullptr ) return TRUE;
	BOOL ret = ImmReleaseContext(m_hWnd, m_hImc);
	m_hImc = nullptr;
	m_hWnd = nullptr;
	return ret;
}

/**********************************************************************//**
 *
 * 쐬
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CIMM::Create(void)
{
	Close();
	Destroy();
	m_hImc = ImmCreateContext();
	if( m_hImc == nullptr ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * 폜
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CIMM::Destroy(void)
{
	if( m_hImc == nullptr ) return TRUE;
	if( m_hWnd != nullptr ) return TRUE;	// CreateĂȂ
	BOOL ret = ImmDestroyContext(m_hImc);
	m_hImc = nullptr;
	return ret;
}

/**********************************************************************//**
 *
 * G[擾
 *
 ----------------------------------------------------------------------
 * @param [in]	dwIndex		= KChC̎(GGL_***)
 * @param [in]	lpBuffer	= o(GGL_STRING, GGL_PRIVATÊƂK{)
 * @param [in]	dwBufLen	= o̓obt@TCY
 * @retval	GGL_STRING or GGL_PRIVATE	= ݃TCYidwBufLen = 0̂ƂAKvTCYj
 * @retval	GGL_LEVEL					= GL_LEVEL_***
 * @retval	GGL_INDEX					= GL_ID_***
*//***********************************************************************/
DWORD CIMM::GetGuideLine (DWORD dwIndex, LPTSTR lpBuffer, DWORD dwBufLen)
{
	return ImmGetGuideLine (m_hImc, dwIndex, lpBuffer, dwBufLen);
}
/// CIMM::GetGuideLine Q
DWORD CIMM::GetGuideLineA(DWORD dwIndex, LPSTR  lpBuffer, DWORD dwBufLen)
{
	return ImmGetGuideLineA(m_hImc, dwIndex, lpBuffer, dwBufLen);
}
/// CIMM::GetGuideLine Q
DWORD CIMM::GetGuideLineW(DWORD dwIndex, LPWSTR lpBuffer, DWORD dwBufLen)
{
	return ImmGetGuideLineW(m_hImc, dwIndex, lpBuffer, dwBufLen);
}

/**********************************************************************//**
 *
 * IME̊JԎ擾
 *
 ----------------------------------------------------------------------
 * @return	J
*//***********************************************************************/
BOOL CIMM::GetOpenStatus(void)
{
	return ImmGetOpenStatus(m_hImc);
}

/**********************************************************************//**
 *
 * IME̊J
 *
 ----------------------------------------------------------------------
 * @param [in]	Status	= J
 * @return	
*//***********************************************************************/
BOOL CIMM::SetOpenStatus(BOOL Status)
{
	return ImmSetOpenStatus(m_hImc, Status);
}

/**********************************************************************//**
 *
 * ϊԂ擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpdwCnversion	= ̓[h
 * @param [in]	lpdwSentence	= ϊ[h
 * @return	
*//***********************************************************************/
BOOL CIMM::GetConversionStatus(LPDWORD lpdwCnversion, LPDWORD lpdwSentence)
{
	return ImmGetConversionStatus(m_hImc, lpdwCnversion, lpdwSentence);
}

/**********************************************************************//**
 *
 * ϊԂݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	dwCnversion	= ̓[h
 * @param [in]	dwSentence	= ϊ[h
 * @return	
*//***********************************************************************/
BOOL CIMM::SetConversionStatus(DWORD dwCnversion, DWORD dwSentence)
{
	return ImmSetConversionStatus(m_hImc, dwCnversion, dwSentence);
}

/**********************************************************************//**
 *
 * ܂͒P̕ϊʈꗗ擾
 *	(IME ֘ÃbZ[Wؐ܂)
 *
 ----------------------------------------------------------------------
 * @param [in]	lpSrc			= ϊΏە
 * @param [in]	lpCandidateList	= o
 * @param [in]	dwBufLen		= o̓obt@TCY
 * @param [in]	uFlag			= ANVtO(GCL_***)
 * @return	݃TCYidwBufLen = 0̂ƂAKvTCYj
*//***********************************************************************/
DWORD CIMM::GetConversionList (LPTSTR lpSrc, LPCANDIDATELIST lpCandidateList, DWORD dwBufLen, UINT uFlag)
{
	return ImmGetConversionList (GetHKL(), m_hImc, lpSrc, lpCandidateList, dwBufLen, uFlag);
}
/// CIMM::GetConversionList Q
DWORD CIMM::GetConversionListA(LPSTR  lpSrc, LPCANDIDATELIST lpCandidateList, DWORD dwBufLen, UINT uFlag)
{
	return ImmGetConversionListA(GetHKL(), m_hImc, lpSrc, lpCandidateList, dwBufLen, uFlag);
}
/// CIMM::GetConversionList Q
DWORD CIMM::GetConversionListW(LPWSTR lpSrc, LPCANDIDATELIST lpCandidateList, DWORD dwBufLen, UINT uFlag)
{
	return ImmGetConversionListW(GetHKL(), m_hImc, lpSrc, lpCandidateList, dwBufLen, uFlag);
}

/**********************************************************************//**
 *
 * ͒̕擾
 *
 ----------------------------------------------------------------------
 * @param [in]	dwAction	= ʒmR[h(NI_***)
 * @param [in]	dwIndex		= ꗗ̃CfbNX(NI_COMPOSITIONSTR ̂Ƃ́ACPS_***)
 * @param [in]	dwValue		= dwAction p[^Ɏw肵lɉāAꗗ̃CfbNX܂0
 * @return	擾obt@TCY
*//***********************************************************************/
BOOL CIMM::NotifyIME(DWORD dwAction, DWORD dwIndex, DWORD dwValue)
{
	return ImmNotifyIME(m_hImc, dwAction, dwIndex, dwValue);
}

/**********************************************************************//**
 *
 * ͒̕擾
 *
 ----------------------------------------------------------------------
 * @param [in]	dwType		= 擾^Cv(GCS_***)
 * @param [in]	lpBuffer	= o̓obt@
 * @param [in]	dwSize		= o̓obt@TCY
 * @return	擾obt@TCY
*//***********************************************************************/
LONG CIMM::GetCompositionString (DWORD dwType, LPVOID lpBuffer, DWORD dwSize)
{
	return ImmGetCompositionString (m_hImc, dwType, lpBuffer, dwSize);
}
/// CIMM::GetCompositionString Q
LONG CIMM::GetCompositionStringA(DWORD dwType, LPVOID lpBuffer, DWORD dwSize)
{
	return ImmGetCompositionStringA(m_hImc, dwType, lpBuffer, dwSize);
}
/// CIMM::GetCompositionString Q
LONG CIMM::GetCompositionStringW(DWORD dwType, LPVOID lpBuffer, DWORD dwSize)
{
	return ImmGetCompositionStringW(m_hImc, dwType, lpBuffer, dwSize);
}

/**********************************************************************//**
 *
 * ͒̕ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	dwIndex		= SCS_***
 * @param [in]	lpComp		= ϊ
 * @param [in]	dwCompLen	= ϊTCY
 * @param [in]	lpRead		= ǂݕ
 * @param [in]	dwReadLen	= ǂݕTCY
 * @return	
*//***********************************************************************/
BOOL CIMM::SetCompositionString (DWORD dwIndex, LPVOID lpComp, DWORD dwCompLen, LPVOID lpRead, DWORD dwReadLen)
{
	return ImmSetCompositionString (m_hImc, dwIndex, lpComp, dwCompLen, lpRead, dwReadLen);
}
/// CIMM::SetCompositionString Q
BOOL CIMM::SetCompositionStringA(DWORD dwIndex, LPVOID lpComp, DWORD dwCompLen, LPVOID lpRead, DWORD dwReadLen)
{
	return ImmSetCompositionStringA(m_hImc, dwIndex, lpComp, dwCompLen, lpRead, dwReadLen);
}
/// CIMM::SetCompositionString Q
BOOL CIMM::SetCompositionStringW(DWORD dwIndex, LPVOID lpComp, DWORD dwCompLen, LPVOID lpRead, DWORD dwReadLen)
{
	return ImmSetCompositionStringW(m_hImc, dwIndex, lpComp, dwCompLen, lpRead, dwReadLen);
}

/**********************************************************************//**
 *
 * ϊEBhEł̃tHg擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lplf	= o
 * @return	
*//***********************************************************************/
BOOL CIMM::GetCompositionFont (LPLOGFONT  lplf)
{
	return ImmGetCompositionFont (m_hImc, lplf);
}
/// CIMM::GetCompositionFont Q
BOOL CIMM::GetCompositionFontA(LPLOGFONTA lplf)
{
	return ImmGetCompositionFontA(m_hImc, lplf);
}
/// CIMM::GetCompositionFont Q
BOOL CIMM::GetCompositionFontW(LPLOGFONTW lplf)
{
	return ImmGetCompositionFontW(m_hImc, lplf);
}

/**********************************************************************//**
 *
 * ϊEBhEł̃tHgݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lplf	= 
 * @return	
*//***********************************************************************/
BOOL CIMM::SetCompositionFont (LPLOGFONT  lplf)
{
	return ImmSetCompositionFont (m_hImc, lplf);
}
/// CIMM::SetCompositionFont Q
BOOL CIMM::SetCompositionFontA(LPLOGFONTA lplf)
{
	return ImmSetCompositionFontA(m_hImc, lplf);
}
/// CIMM::SetCompositionFont Q
BOOL CIMM::SetCompositionFontW(LPLOGFONTW lplf)
{
	return ImmSetCompositionFontW(m_hImc, lplf);
}

/**********************************************************************//**
 *
 * ϊEBhȄ擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpCompForm	= o
 * @return	
*//***********************************************************************/
BOOL CIMM::GetCompositionWindow(LPCOMPOSITIONFORM lpCompForm)
{
	return ImmGetCompositionWindow(m_hImc, lpCompForm);
}

/**********************************************************************//**
 *
 * ϊEBhȄݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpCompForm	= 
 * @return	
*//***********************************************************************/
BOOL CIMM::SetCompositionWindow(LPCOMPOSITIONFORM lpCompForm)
{
	return ImmSetCompositionWindow(m_hImc, lpCompForm);
}

/**********************************************************************//**
 *
 * ꗗŜ̃obt@TCY擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpdwListCount		= ꗗŜ̃obt@TCY
 * @return	ꗗŜ󂯎邽߂ɕKvƂȂoCg
*//***********************************************************************/
DWORD CIMM::GetCandidateListCount (LPDWORD lpdwListCount)
{
	return ImmGetCandidateListCount (m_hImc, lpdwListCount);
}
/// CIMM::GetCandidateListCount Q
DWORD CIMM::GetCandidateListCountA(LPDWORD lpdwListCount)
{
	return ImmGetCandidateListCountA(m_hImc, lpdwListCount);
}
/// CIMM::GetCandidateListCount Q
DWORD CIMM::GetCandidateListCountW(LPDWORD lpdwListCount)
{
	return ImmGetCandidateListCountW(m_hImc, lpdwListCount);
}

/**********************************************************************//**
 *
 * ꗗobt@ɃRs[
 *
 ----------------------------------------------------------------------
 * @param [in]	deIndex			= ꗗ̃CfbNX
 * @param [in]	lpCandidateList	= o
 * @param [in]	dwBufLen		= o̓obt@TCY
 * @return	݃TCYidwBufLen = 0̂ƂAKvTCYj
*//***********************************************************************/
DWORD CIMM::GetCandidateList (DWORD deIndex, LPCANDIDATELIST lpCandidateList, DWORD dwBufLen)
{
	return ImmGetCandidateList (m_hImc, deIndex, lpCandidateList, dwBufLen);
}
/// CIMM::GetCandidateList Q
DWORD CIMM::GetCandidateListA(DWORD deIndex, LPCANDIDATELIST lpCandidateList, DWORD dwBufLen)
{
	return ImmGetCandidateListA(m_hImc, deIndex, lpCandidateList, dwBufLen);
}
/// CIMM::GetCandidateList Q
DWORD CIMM::GetCandidateListW(DWORD deIndex, LPCANDIDATELIST lpCandidateList, DWORD dwBufLen)
{
	return ImmGetCandidateListW(m_hImc, deIndex, lpCandidateList, dwBufLen);
}

/**********************************************************************//**
 *
 * ꗗEBhEɊւ擾
 *
 ----------------------------------------------------------------------
 * @param [in]	dwBufLen			= 󂯎obt@̃TCY
 * @param [in]	lpCandidateForm		= o
 * @return	
*//***********************************************************************/
BOOL CIMM::GetCandidateWindow(DWORD dwBufLen, LPCANDIDATEFORM lpCandidateForm)
{
	return ImmGetCandidateWindow(m_hImc, dwBufLen, lpCandidateForm);
}

/**********************************************************************//**
 *
 * ꗗEBhEɊւݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpCandidateForm		= 
 * @return	
*//***********************************************************************/
BOOL CIMM::SetCandidateWindow(LPCANDIDATEFORM lpCandidateForm)
{
	return ImmSetCandidateWindow(m_hImc, lpCandidateForm);
}

/**********************************************************************//**
 *
 * IME 镶擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lpString	= o͕
 * @param [in]	uLength		= TCY
 * @return	݃TCY
*//***********************************************************************/
UINT CIMM::GetDescription (LPTSTR lpString, UINT uLength)
{
#ifdef UNICODE
	return GetDescriptionW(lpString, uLength);
#else
	return GetDescriptionA(lpString, uLength);
#endif
}
/// CIMM::GetDescription Q
UINT CIMM::GetDescriptionA(LPSTR  lpString, UINT uLength)
{
	return ImmGetDescriptionA(GetHKL(), lpString, uLength);
}
/// CIMM::GetDescription Q
UINT CIMM::GetDescriptionW(LPWSTR lpString, UINT uLength)
{
	return ImmGetDescriptionW(GetHKL(), lpString, uLength);
}

/**********************************************************************//**
 *
 * Xe[^XEBhËʒu擾
 *
 ----------------------------------------------------------------------
 * @param [in]	lppt	= o
 * @return	
*//***********************************************************************/
BOOL CIMM::GetStatusWindowPos(LPPOINT lppt)
{
	return ImmGetStatusWindowPos(m_hImc, lppt);
}

/**********************************************************************//**
 *
 * Xe[^XEBhËʒuݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	lppt	= 
 * @return	
*//***********************************************************************/
BOOL CIMM::SetStatusWindowPos(LPPOINT lppt)
{
	return ImmSetStatusWindowPos(m_hImc, lppt);
}

/**********************************************************************//**
 *
 * IME j[ɓo^Ă郁j[ڎ擾
 *
 ----------------------------------------------------------------------
 * @param [in]	dwFlags			= tO( 0 or IGIMIF_RIGHTMENU )
 * @param [in]	dwType			= 擾郁j[̎(IGIMII_***)
 * @param [in]	lpParentMenu	= óBej[
 * @param [in]	lpMenu			= óB󂯎郁j[z
 * @param [in]	dwSize 			= lpMenu ̔z
 * @return	擾j[񐔁ilpMenu = nullptrɂƁAYj
*//***********************************************************************/
DWORD CIMM::GetImeMenuItems (DWORD dwFlags, DWORD dwType
							 , LPIMEMENUITEMINFO  lpParentMenu, LPIMEMENUITEMINFO  lpMenu, DWORD dwSize)
{
	return ImmGetImeMenuItems (m_hImc, dwFlags, dwType, lpParentMenu, lpMenu, dwSize);
}
/// CIMM::GetImeMenuItems Q
DWORD CIMM::GetImeMenuItemsA(DWORD dwFlags, DWORD dwType
							 , LPIMEMENUITEMINFOA lpParentMenu, LPIMEMENUITEMINFOA lpMenu, DWORD dwSize)
{
	return ImmGetImeMenuItemsA(m_hImc, dwFlags, dwType, lpParentMenu, lpMenu, dwSize);
}
/// CIMM::GetImeMenuItems Q
DWORD CIMM::GetImeMenuItemsW(DWORD dwFlags, DWORD dwType
							 , LPIMEMENUITEMINFOW lpParentMenu, LPIMEMENUITEMINFOW lpMenu, DWORD dwSize)
{
	return ImmGetImeMenuItemsW(m_hImc, dwFlags, dwType, lpParentMenu, lpMenu, dwSize);
}

/**********************************************************************//**
 *
 * e IME ɌŗL̃Tu֐s
 *
 ----------------------------------------------------------------------
 * @param [in]	uEscape	= Tu֐̃CfbNX
 * @param [in]	lpData	= w肵Tu֐p̃f[^
 * @return	LRESULTl
*//***********************************************************************/
LRESULT CIMM::Escape (UINT uEscape, LPVOID lpData)
{
	return ImmEscape(GetHKL(), m_hImc, uEscape, lpData);
}
/// CIMM::Escape Q
LRESULT CIMM::EscapeA(UINT uEscape, LPVOID lpData)
{
	return ImmEscapeA(GetHKL(), m_hImc, uEscape, lpData);
}
/// CIMM::Escape Q
LRESULT CIMM::EscapeW(UINT uEscape, LPVOID lpData)
{
	return ImmEscapeW(GetHKL(), m_hImc, uEscape, lpData);
}

/**********************************************************************//**
 *
 * IME̐ݒp_CAO{bNX̕\
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= eEBhEnh
 * @param [in]	dwMode	= [h(IME_CONFIG_***)
 * @param [in]	lpData	= dwMode IME_CONFIG_REGISTERWORD w肵ꍇAREGISTERWORD̃|C^
 * @return	
*//***********************************************************************/
BOOL CIMM::ConfigureIME (HWND hWnd, DWORD dwMode, LPVOID lpData)
{
	return ImmConfigureIME (GetHKL(), hWnd, dwMode, lpData);
}
/// CIMM::ConfigureIME Q
BOOL CIMM::ConfigureIMEA(HWND hWnd, DWORD dwMode, LPVOID lpData)
{
	return ImmConfigureIMEA(GetHKL(), hWnd, dwMode, lpData);
}
/// CIMM::ConfigureIME Q
BOOL CIMM::ConfigureIMEW(HWND hWnd, DWORD dwMode, LPVOID lpData)
{
	return ImmConfigureIMEW(GetHKL(), hWnd, dwMode, lpData);
}

}	// end of namespace wx
}	// end of namespace iris
