//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXIconFile.cpp
 * @brief		ACRt@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXIconFile_CPP_

//======================================================================
// include
#include "WXIconFile.h"
#include "fnd/io/FndFile.h"
#include "iris_debug.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CIconFile::CIconFile(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CIconFile::~CIconFile(void)
{
	Release();
}

/**********************************************************************//**
 *
 * Ǎ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpFileName	= t@C
 * @return	
*//***********************************************************************/
bool CIconFile::Load (LPCTSTR lpFileName)
{
#ifdef UNICODE
	return LoadW(lpFileName);
#else
	return LoadA(lpFileName);
#endif
}
/// CIconFile::Load Q
bool CIconFile::LoadA(LPCSTR  lpFileName)
{
	fnd::CFile file;
	if( !file.OpenA(lpFileName, IRIS_TEXTA("rb")) ) return false;
	Alloc(file.GetSize());
	if( m_pBuffer == nullptr ) return false;
	file.Read(m_pBuffer, m_Size, 1);
	LPICONDIR p = GetHeader();
	if( p->idReserved != 0 || p->idType != 1 )
	{
		Release();
		return false;
	}
	return true;
}
/// CIconFile::Load Q
bool CIconFile::LoadW(LPCWSTR lpFileName)
{
	fnd::CFile file;
	if( !file.OpenW(lpFileName, IRIS_TEXTW("rb")) ) return false;
	Alloc(file.GetSize());
	if( m_pBuffer == nullptr ) return false;
	file.Read(m_pBuffer, m_Size, 1);
	LPICONDIR p = GetHeader();
	if( p->idReserved != 0 || p->idType != 1 )
	{
		Release();
		return false;
	}
	return true;
}

/**********************************************************************//**
 *
 * obt@Rs[
 *
 -----------------------------------------------------------------------
 * @param [in]	lpBuffer	= ̓obt@
 * @param [in]	size		= obt@TCY
 * @return	
*//***********************************************************************/
bool CIconFile::DuplicateOnMemory(const void* lpBuffer, u32 size)
{
	Release();
	Alloc(size);
	if( m_pBuffer == nullptr ) return false;
	memcpy(m_pBuffer, lpBuffer, size);
	LPICONDIR p = GetHeader();
	if( p->idReserved != 0 || p->idType != 1 )
	{
		Release();
		return false;
	}
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CIconFile::Release(void)
{
	Dealloc();
}

/**********************************************************************//**
 *
 * ACRGg[̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	index	= ACRCfbNX
 * @return	Gg[
*//***********************************************************************/
LPICONDIRENTRY CIconFile::GetEntry(int index)
{
	LPICONDIR p = GetHeader();
	IRIS_ASSERT( p != nullptr );
	IRIS_ASSERT( index >= 0 );
	if( index >= p->idCount ) return nullptr;
	return &p->idEntries[index];
}

/**********************************************************************//**
 *
 * ACRC[W̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	index		= ACRCfbNX
 * @param [out]	pIconImage	= o̓ACRC[W
 * @return	
*//***********************************************************************/
bool CIconFile::GetImage(int index, LPICONIMAGE pIconImage)
{
	IRIS_ASSERT( pIconImage != nullptr );
	LPICONDIRENTRY pEntry = GetEntry(index);
	if( pEntry == nullptr ) return false;
	u8* image = reinterpret_cast<u8*>(m_pBuffer) + pEntry->dwImageOffset;
	fnd::LPBMPINFOHEADER bmp = reinterpret_cast<fnd::LPBMPINFOHEADER>(image);
	image += bmp->biSize;
	pIconImage->pBmpInfo= bmp;
	pIconImage->pPalette= bmp->biClrUsed ? reinterpret_cast<IrisRGBQUAD*>(image) : nullptr;
	pIconImage->pXOR	= image + bmp->biClrUsed * sizeof(RGBQUAD);
	pIconImage->pAND	= pIconImage->pXOR + bmp->biSizeImage;
	return true;
}

/**********************************************************************//**
 *
 * t@CɊ܂܂ĂACR擾
 *
 ----------------------------------------------------------------------
 * @return	ACR
*//***********************************************************************/
WORD CIconFile::GetIconNum(void) const
{
	LPICONDIR p = GetHeader();
	IRIS_ASSERT( p != nullptr );
	return p->idCount;
}

/**********************************************************************//**
 *
 * }XNf[^̃TCY̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	pbi	= vZΏۃACR̃rbg}bvwb_
 * @return	}XNf[^̃TCY
*//***********************************************************************/
u32 CIconFile::GetMaskSize(fnd::LPBMPINFOHEADER pbi)
{
	IRIS_ASSERT( pbi != nullptr );
	return (IRIS_RoundUp4B((pbi->biWidth+7)>>3) * pbi->biHeight) >> 1;
}

}	// end of namespace wx
}	// end of namespace iris
