//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXGdiObject.h
 * @brief		GDIIuWFNgx[XNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXGdiObject_H_
#define _IRIS_WXGdiObject_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris {
namespace wx
{

//======================================================================
// declare
class CGDIObject;
class CGDISelectObject;

//======================================================================
// class
//! GDIIuWFNgNXev[g
template<typename _TN>
class CGDIObjectBase : public INonCopyObject
{
protected:
	typedef _TN					_MyObj;
	typedef CGDIObjectBase<_TN>	_Myt;
protected:
	_TN		m_hObj;	//!< GDIIuWFNg
public:
	/// RXgN^
	CGDIObjectBase(void) : m_hObj(nullptr) {}
	/// RXgN^
	CGDIObjectBase(_TN hObj) : m_hObj(nullptr) 	{ Attach(hObj); }
	/// RXgN^
	CGDIObjectBase(_Myt& rObj) : m_hObj(nullptr){ Attach(rObj); }

	/// fXgN^
	virtual ~CGDIObjectBase(void)				{ Delete(); }

public:

	_TN					GetObject(void)		{ return m_hObj; }
			operator	_TN (void)			{ return GetObject(); }
	_Myt&	operator	= (_TN hObj)		{ Attach(hObj); return *this; }
	_Myt&	operator	= (_Myt& rObj)		{ Attach(rObj); return *this; }

public:
	/// GDIIuWFNg̊֘At
	BOOL	Attach(_TN hObj)	{ if( hObj == nullptr || m_hObj != nullptr ) return FALSE; m_hObj = hObj; return TRUE; }
	/// ֘At̉
	_TN		Detach(void)		{ _TN hPre = m_hObj; m_hObj = nullptr; return hPre; }

public:
	/// IuWFNg̍폜
	BOOL	Delete(void)	{ return DeleteObject(Detach()); }

public:
	/// ev[g^ϊ
	template<typename _Type>
	CGDIObjectBase(CGDIObjectBase<_Type>& rGDI)			{ Attach(rGDI); }
	/// ev[g^ϊ
	template<typename _Type>
	void	operator	= (CGDIObjectBase<_Type>& rObj)	{ Attach(rObj); }
};

//! GDIIuWFNgNX
class CGDIObject : public CGDIObjectBase<HGDIOBJ>
{
	typedef CGDIObjectBase<HGDIOBJ>	_Base;
public:
	// RXgN^
	CGDIObject(void)	{}

#ifdef STRICT
	// ^̌ɑΉ
	/// RXgN^
	CGDIObject(HBRUSH	hObj) : _Base(hObj) 		{}
	CGDIObject(HBITMAP	hObj) : _Base(hObj) 		{}
	CGDIObject(HPEN		hObj) : _Base(hObj) 		{}

			operator	HBRUSH	(void)		{ return static_cast<HBRUSH>(GetObject()); }
			operator	HBITMAP	(void)		{ return static_cast<HBITMAP>(GetObject()); }
			operator	HPEN	(void)		{ return static_cast<HPEN>(GetObject()); }

	CGDIObject&	operator	= (HBRUSH	hObj)	{ Attach(hObj); return *this; }
	CGDIObject&	operator	= (HBITMAP	hObj)	{ Attach(hObj); return *this; }
	CGDIObject&	operator	= (HPEN		hObj)	{ Attach(hObj); return *this; }
#endif
};

//! HDC,GDIIuWFNgselectNX
class CGDISelectObject : public INonCopyObject
{
protected:
	HDC			m_hDC;	//!< HDC
	HGDIOBJ		m_hOld;	//!< ȑOGDIIuWFNg

public:
	// RXgN^
	CGDISelectObject(void);
	CGDISelectObject(HDC hDC);
	CGDISelectObject(HDC hDC, HGDIOBJ hObj);

	// fXgN^
	~CGDISelectObject(void);

public:
	// GDIIuWFNg̊֘At
	BOOL	Attach(HDC hDC);
	// ֘At̉
	HDC		Detach(void);

public:
	// GDIIuWFNg̑I
	HGDIOBJ	SelectObject(HGDIOBJ hObj);
	HGDIOBJ	SelectObject(HDC hDC, HGDIOBJ hObj);
	// 
	void	Release(void);

public:
	/// ȑÕIuWFNg擾
	HGDIOBJ	GetOld(void)	{ return m_hOld; }
};

}	// end of namespace wx
}	// end of namespace iris

#endif
