//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXGdiGL.cpp
 * @brief		wgl gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXGdiGL_CPP_

//======================================================================
// include
#include "WXGdiGL.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 * 
*//***********************************************************************/
CWglContext::CWglContext(void)
: m_hRC(nullptr)
, m_hDC(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 * 
*//***********************************************************************/
CWglContext::~CWglContext(void)
{
	Delete();
}

/**********************************************************************//**
 *
 * 쐬
 * 
 ----------------------------------------------------------------------
 * @param [in]	hDC	= foCXReLXg
 * @return	
*//***********************************************************************/
BOOL CWglContext::Create(HDC hDC)
{
	HGLRC hRC = wglCreateContext(hDC);
	if( !Attach(hDC, hRC) )
	{
		wglDeleteContext(hRC);
		return FALSE;
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * 
 * 
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CWglContext::Delete(void)
{
	return wglDeleteContext( Detach() );
}

/**********************************************************************//**
 *
 * JgReLXgɐݒ
 * 
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CWglContext::PushCurrent(void)
{
	return wglMakeCurrent(m_hDC, m_hRC);
}

/**********************************************************************//**
 *
 * JgReLXg͂
 * 
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CWglContext::PopCurrent(void)
{
	HDC		hDC = wglGetCurrentDC();
	HGLRC	hRC = wglGetCurrentContext();
	if( hDC != m_hDC ) return FALSE;
	if( hRC != m_hRC ) return FALSE;
	return wglMakeCurrent(nullptr, nullptr);
}

/**********************************************************************//**
 *
 * ֘At
 * 
 ----------------------------------------------------------------------
 * @param [in]	hDC	= ֘Atnh
 * @param [in]	hRC	= ֘Atnh
 * @return	
*//***********************************************************************/
BOOL CWglContext::Attach(HDC hDC, HGLRC hRC)
{
	if( m_hRC != nullptr ) return FALSE;
	if( m_hDC != nullptr ) return FALSE;
	if( hRC == nullptr ) return FALSE;
	if( hDC == nullptr ) return FALSE;
	m_hRC = hRC;
	m_hDC = hDC;
	return TRUE;
}

/**********************************************************************//**
 *
 * ֘At̉
 * 
 ----------------------------------------------------------------------
 * @return	֘AtĂReLXg
*//***********************************************************************/
HGLRC CWglContext::Detach(void)
{
	HGLRC hPre = m_hRC;
	m_hRC = nullptr;
	m_hDC = nullptr;
	return hPre;
}

}	// end of namespace wx
}	// end of namespace iris
