//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXGdiFont.h
 * @brief		GDItHgIuWFNgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXGdiFont_CPP_

//======================================================================
// include
#include "WXGdiFont.h"

namespace iris {
namespace wx
{

//======================================================================
// class

// CGDIFont
/**********************************************************************//**
 *
 * tHg̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	nHeight			= 
 * @param [in]	nWidth			= 
 * @param [in]	nEscapement		= 
 * @param [in]	nOrientation	= 
 * @param [in]	nWeight			= 
 * @param [in]	bItalic			= 
 * @param [in]	bUnderline		= 
 * @param [in]	bStrikeOut		= 
 * @param [in]	iCharSet		= 
 * @param [in]	iOutPrecision	= 
 * @param [in]	iClipPrecision	= 
 * @param [in]	iQuality		= 
 * @param [in]	iPitchAndFamily	= 
 * @param [in]	pszFaceName		= 
 * @return	
*//***********************************************************************/
BOOL CGDIFont::Create (int nHeight, int nWidth, int nEscapement, int nOrientation, int nWeight
				, DWORD bItalic, DWORD bUnderline, DWORD bStrikeOut
				, DWORD iCharSet, DWORD iOutPrecision, DWORD iClipPrecision
				, DWORD iQuality, DWORD iPitchAndFamily, LPCTSTR  pszFaceName)
{
#ifdef UNICODE
	return CreateW(nHeight, nWidth, nEscapement, nOrientation, nWeight
		, bItalic, bUnderline, bStrikeOut, iCharSet, iOutPrecision, iClipPrecision
		, iQuality, iPitchAndFamily, pszFaceName);
#else
	return CreateA(nHeight, nWidth, nEscapement, nOrientation, nWeight
		, bItalic, bUnderline, bStrikeOut, iCharSet, iOutPrecision, iClipPrecision
		, iQuality, iPitchAndFamily, pszFaceName);
#endif
}
/// CGDIFont::Create Q
BOOL CGDIFont::CreateA(int nHeight, int nWidth, int nEscapement, int nOrientation, int nWeight
				, DWORD bItalic, DWORD bUnderline, DWORD bStrikeOut
				, DWORD iCharSet, DWORD iOutPrecision, DWORD iClipPrecision
				, DWORD iQuality, DWORD iPitchAndFamily, LPCSTR  pszFaceName)
{
#if	defined(IRIS_WIN32_WCE)
	LOGFONTA lf;
	lf.lfCharSet		= iCharSet;
	lf.lfClipPrecision	= iClipPrecision;
	lf.lfEscapement		= nEscapement;
	lf.lfHeight			= nHeight;
	lf.lfItalic			= bItalic;
	lf.lfOrientation	= nOrientation;
	lf.lfOutPrecision	= iOutPrecision;
	lf.lfPitchAndFamily	= iPitchAndFamily;
	lf.lfQuality		= iQuality;
	lf.lfStrikeOut		= bStrikeOut;
	lf.lfUnderline		= bUnderline;
	lf.lfWeight			= nWeight;
	lf.lfWidth			= nWidth;
	strcpy_s(lf.lfFaceName, sizeof(lf.lfFaceName), pszFaceName);
	return CreateIndirectA(&lf);
#else
	HFONT hFont = CreateFontA(nHeight, nWidth, nEscapement, nOrientation, nWeight
		, bItalic, bUnderline, bStrikeOut
		, iCharSet, iOutPrecision, iClipPrecision
		, iQuality, iPitchAndFamily, pszFaceName);
	if( !Attach(hFont) )
	{
		DeleteObject(hFont);
		return FALSE;
	}
	return TRUE;
#endif
}
/// CGDIFont::Create Q
BOOL CGDIFont::CreateW(int nHeight, int nWidth, int nEscapement, int nOrientation, int nWeight
				, DWORD bItalic, DWORD bUnderline, DWORD bStrikeOut
				, DWORD iCharSet, DWORD iOutPrecision, DWORD iClipPrecision
				, DWORD iQuality, DWORD iPitchAndFamily, LPCWSTR pszFaceName)
{
#if	defined(IRIS_WIN32_WCE)
	LOGFONTW lf;
	lf.lfCharSet		= iCharSet;
	lf.lfClipPrecision	= iClipPrecision;
	lf.lfEscapement		= nEscapement;
	lf.lfHeight			= nHeight;
	lf.lfItalic			= bItalic;
	lf.lfOrientation	= nOrientation;
	lf.lfOutPrecision	= iOutPrecision;
	lf.lfPitchAndFamily	= iPitchAndFamily;
	lf.lfQuality		= iQuality;
	lf.lfStrikeOut		= bStrikeOut;
	lf.lfUnderline		= bUnderline;
	lf.lfWeight			= nWeight;
	lf.lfWidth			= nWidth;
	wcscpy_s(lf.lfFaceName, sizeof(lf.lfFaceName), pszFaceName);
	return CreateIndirectW(&lf);
#else
	HFONT hFont = CreateFontW(nHeight, nWidth, nEscapement, nOrientation, nWeight
		, bItalic, bUnderline, bStrikeOut
		, iCharSet, iOutPrecision, iClipPrecision
		, iQuality, iPitchAndFamily, pszFaceName);
	if( !Attach(hFont) )
	{
		DeleteObject(hFont);
		return FALSE;
	}
	return TRUE;
#endif
}

/**********************************************************************//**
 *
 * tHg̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	lplf	= tHg
 * @return	
*//***********************************************************************/
BOOL CGDIFont::CreateIndirect (const LOGFONT*  lplf)
{
#ifdef UNICODE
	return CreateIndirectW(lplf);
#else
	return CreateIndirectA(lplf);
#endif
}
/// CGDIFont::CreateIndirect Q
BOOL CGDIFont::CreateIndirectA(const LOGFONTA* lplf)
{
	HFONT hFont = CreateFontIndirectA(lplf);
	if( !Attach(hFont) )
	{
		DeleteObject(hFont);
		return FALSE;
	}
	return TRUE;
}
/// CGDIFont::CreateIndirect Q
BOOL CGDIFont::CreateIndirectW(const LOGFONTW* lplf)
{
	HFONT hFont = CreateFontIndirectW(lplf);
	if( !Attach(hFont) )
	{
		DeleteObject(hFont);
		return FALSE;
	}
	return TRUE;
}

}	// end of namespace wx
}	// end of namespace iris
