//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXGdiBrush.h
 * @brief		GDIuVIuWFNgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXGdiBrush_CPP_

//======================================================================
// include
#include "WXGdiBrush.h"

namespace iris {
namespace wx
{

//======================================================================
// class

// CGDIBrush
/**********************************************************************//**
 *
 * uV̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	color	= F
 * @return	
*//***********************************************************************/
BOOL CGDIBrush::CreateSolid(COLORREF color)
{
	if( m_hObj != nullptr ) return FALSE;
	_MyObj hObj = CreateSolidBrush(color);
	if( !Attach(hObj)  ) 
	{
		::DeleteObject(hObj);
		return FALSE;
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * uV̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	nHatch	= nb`X^C(HS_***)
 * @param [in]	color	= F
 * @return	
*//***********************************************************************/
BOOL CGDIBrush::CreateHatch(int nHatch, COLORREF color)
{
	if( m_hObj != nullptr ) return FALSE;
	_MyObj hObj = CreateHatchBrush(nHatch, color);
	if( !Attach(hObj)  ) 
	{
		::DeleteObject(hObj);
		return FALSE;
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * uV̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	nStyle	= X^C
 * @param [in]	Hatch	= nStyleBS_DIB***w肵Ƃ́ADIBBBS_HATCHED̂Ƃ́Anb`X^C(HS_***)
 * @param [in]	color	= F
 * @return	
*//***********************************************************************/
BOOL CGDIBrush::Create(UINT nStyle, ULONG_PTR Hatch, COLORREF color)
{
	LOGBRUSH log;
	log.lbStyle		= nStyle;
	log.lbHatch		= Hatch;
	log.lbColor		= color;
	return Create(&log);
}

/**********************************************************************//**
 *
 * uV̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	lppen	= y
 * @return	
*//***********************************************************************/
BOOL CGDIBrush::Create(const PLOGBRUSH lpbrush)
{
	if( m_hObj != nullptr ) return FALSE;
	_MyObj hObj = CreateBrushIndirect(lpbrush);
	if( !Attach(hObj)  ) 
	{
		::DeleteObject(hObj);
		return FALSE;
	}
	return TRUE;
}

}	// end of namespace wx
}	// end of namespace iris
