//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDeviceContext.h
 * @brief		foCXReLXgt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXDeviceContext_H_
#define _IRIS_WXDeviceContext_H_

//======================================================================
// include
#include "fnd/image/FndImage.h"

namespace iris {
namespace wx
{

//======================================================================
// define

//======================================================================
// class
//! foCXReLXgNX
class CDeviceContext : public fnd::IImage
{
protected:
	HDC		m_hDC;	//!< foCXReLXg
public:
	// RXgN^
	CDeviceContext(void);
	CDeviceContext(HDC hdc);
	// fXgN^
	~CDeviceContext(void);

public:
    // foCXReLXg֘At
    bool		Attach(HDC hDC);
    // foCXReLXg̊֘At𕪗
    HDC			Detach(void);
    // foCXƃeLXgƌ݊̂郁foCXReLXg̍쐬
    HDC			CreateCompatibleDC(void);
    // foCXReLXgj
    BOOL		DeleteDC(void);

public:
	// NbsO
	// ̃NbsO[WAw肳ꂽ`O
	int			ExcludeClipRect(int left, int top, int right, int bottom);
	int			ExcludeClipRect(LPRECT lprc)	{ return ExcludeClipRect(lprc->left, lprc->top, lprc->right, lprc->bottom); }
	// ݂̃NbsO[WɁA`
	int			IntersectClipRect(int left, int top, int right, int bottom);
	int			IntersectClipRect(LPRECT lprc)	{ return IntersectClipRect(lprc->left, lprc->top, lprc->right, lprc->bottom); }
	// ݂̃[Wƍ
	int			ExtSelectClipRgn(HRGN hRgn, int mode);
	// ݂̃pXƃ[W
#if	!defined(IRIS_WIN32_WCE)
	BOOL		SelectClipPath(int mode);
#endif
	// [Wݒ
	int			SelectClipRgn(HRGN hRgn);
	// foCX̍ŏ̉`擾
	int			GetClipBox(LPRECT lprc) const;
	// ݂̃[W擾
	BOOL		GetClipRgn(HRGN hRgn) const;
	// ݂̃^̈̎擾
	BOOL		GetMetaRgn(HRGN hRgn) const;
	// VXeNbsO[WRs[
	BOOL		GetRandomRgn(HRGN hRgn) const;
	// NbsO[Ẅړ
	int			OffsetClipRgn(int x, int y);
	// wWNbsO[Wɂ邩ǂ
	BOOL		PtVisible(int x, int y) const;
	// w`NbsO[Wɂ邩ǂ
	BOOL		RectVisible(const LPRECT lprc) const;

public:
    // foCXReLXgɃIuWFNgI
    HGDIOBJ		SelectObject(HGDIOBJ hGDI);
    // foCXReLXgփrbg}bvRs[
    BOOL		BitBlt(int x, int y, int nWidth, int nHeight, HDC SrcDC, int xSrc, int ySrc, DWORD dwRop);
    // rbg}bvgEkăRs[
    BOOL		StretchBlt(int x, int y, int nWidth, int nHeight, HDC SrcDC, int xSrc, int ySrc, int nSrcWidth, int nSrcHeight, DWORD dwRop);

public:
	// wiJ[
	COLORREF	SetBkColor(COLORREF color);
	COLORREF	GetBkColor(void) const;
	// wi[h
	int			SetBkMode(int mode);
	int			GetBkMode(void) const;

public:
	// eLXgJ[
	COLORREF	SetTextColor(COLORREF color);
	COLORREF	GetTextColor(void) const;
    // eLXgẅʒuɏo͂
    BOOL		TextOutA(int x, int y, LPCSTR lpszString, int nCount);
	BOOL		TextOutA(int x, int y, LPCSTR lpszString, ...);
	// eLXg`
	BOOL		DrawTextA(LPRECT lprc, UINT format, LPCSTR lpszString, int nCount);
	BOOL		DrawTextA(LPRECT lprc, UINT format, LPCSTR lpszString, ...);

public:
	// _ړ
	BOOL		MoveToEx(int x, int y, LPPOINT lppt=nullptr);

	// 
	BOOL		LineTo(int x, int y);
	// A
	BOOL		PolylineTo(const POINT* apt, DWORD cpt);
	BOOL		Polyline(const POINT* apt, DWORD cpt);		// Jg|WVύXȂ
	// ̘A
	BOOL		PolyPolyline(const POINT* apt, const DWORD *asz, DWORD csz);
	// xWFȐ̕`
	BOOL		PolyBezierTo(const POINT* apt, DWORD cpt);	// Jg|WV_ɕ`
	BOOL		PolyBezier(const POINT* apt, DWORD cpt);	// Jg|WV̉e󂯂Ȃ

	// ~̕`
	BOOL		Ellipse(int left, int top, int right, int bottom);
	BOOL		Ellipse(const RECT* lprc)	{ return Ellipse(lprc->left, lprc->top, lprc->right, lprc->bottom); }
	// ʂ̕`
#if	!defined(IRIS_WIN32_WCE)
	BOOL		Arc	 (int left, int top, int right, int bottom, int sx, int sy, int ex, int ey);
	BOOL		Pie	 (int left, int top, int right, int bottom, int sx, int sy, int ex, int ey);
	BOOL		Chord(int left, int top, int right, int bottom, int sx, int sy, int ex, int ey);
#endif
	BOOL		Arc	 (const RECT* lprc, int sx, int sy, int ex, int ey)	{ return Arc(lprc->left, lprc->top, lprc->right, lprc->bottom, sx, sy, ex, ey); }
	BOOL		Pie	 (const RECT* lprc, int sx, int sy, int ex, int ey)	{ return Pie(lprc->left, lprc->top, lprc->right, lprc->bottom, sx, sy, ex, ey); }
	BOOL		Chord(const RECT* lprc, int sx, int sy, int ex, int ey)	{ return Chord(lprc->left, lprc->top, lprc->right, lprc->bottom, sx, sy, ex, ey); }

	// `̕`
	BOOL		Rectangle(int left, int top, int right, int bottom);
	BOOL		Rectangle(const RECT* lprc)	{ return Rectangle(lprc->left, lprc->top, lprc->right, lprc->bottom); }
	// pے`̕`
	BOOL		RoundRect(int left, int top, int right, int bottom, int width, int height);
	BOOL		RoundRect(const RECT* lprc, int width, int height) { return RoundRect(lprc->left, lprc->top, lprc->right, lprc->bottom, width, height); }
	// p`̕`
	BOOL		Polygon(const POINT* apt, int cpt);
	// p`hԂ[h
	int			SetPolyFillMode(int mode);
	int			GetPolyFillMode(void);

	// hԂ
	BOOL		FillRect(const RECT* lprc, HBRUSH hbr);
	BOOL		FrameRect(const RECT* lprc, HBRUSH hbr);	// g
	// [W`
	BOOL		FillRgn(HRGN hrgn, HBRUSH hbr);
	BOOL		PaintRgn(HRGN hrgn);	// DC̃uVgp
	BOOL		FrameRgn(HRGN hrgn, HBRUSH hbr, int width, int height);	// g

	// sNZ`
	BOOL		SetPixel(int x, int y, COLORREF color);
	BOOL		SetPixelV(int x, int y, COLORREF color);
	// sNZJ[̎擾
	COLORREF	GetPixel(int x, int y) const;

public:
	// X^Iy[V
	int			SetROP2(int rop2);
	int			GetROP2(void) const;

public:
	// ݂̃uVŃT[tFCXhԂ
	BOOL		FloodFill(int x, int y, COLORREF color);
	// ݂̃uVŃT[tFCXhԂ
	BOOL		ExtFloodFill(int x, int y, COLORREF color, UINT uFillType);

	// `ƎOp`hԂ
	BOOL		GradientFill(LPTRIVERTEX lpVertex, ULONG nVertex, LPVOID pMesh, ULONG nMesh, ULONG ulMode);

public:
	// ݑIĂ DIB ZNṼrbg}bṽJ[e[ũGgF擾
	UINT		GetDIBColorTable(UINT uStartIndex, UINT uEntryies, LPRGBQUAD lpColors) const;
	// rbg}bvLk[h擾
	int			GetStretchBltMode(void) const;
	// rbg}bvLk[hݒ
	int			SetStretchBltMode(int mode);

public:
	// ̎擾
	virtual s32	GetWidth(void)	const;
	// ̎擾
	virtual s32	GetHeight(void)	const;
	
public:
	// sNZJ[̎擾
	virtual bool		GetPixelRGBA8888(s32 x, s32 y, IrisRGBA8888& rgba) const;
	// sNZJ[̐ݒ
	virtual bool		SetPixelRGBA8888(s32 x, s32 y, const IrisRGBA8888& rgba);

public:
	// set,get
    // foCXReLXg̎擾
	HDC			GetDC(void)			{ return m_hDC; }
    // foCXReLXg̎擾
	operator	HDC (void)			{ return m_hDC; }
};

}	// end of namespace wx
}	// end of namespace iris

#endif

