//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSplashWindow.cpp
 * @brief		AvP[Vʒm_CAO
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXSplashWindow_CPP_

//======================================================================
// include
#include "WXSplashWindow.h"
#include "../../control/WXProgressBar.h"
#include "../../control/WXStaticCtrl.h"
#include "../../resource/WXVersionInfo.h"
#include <commctrl.h>

#include "../../debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace wx
{

//======================================================================
// define
// Rg[ƃRg[̏c
#define SHELLINITWND_CTRL_H		(4)

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
ISplashWindow::ISplashWindow(void)
: m_hParent(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
ISplashWindow::~ISplashWindow(void)
{
	for( CtrlMap::iterator it = m_Controls.begin(); it != m_Controls.end(); )
	{
		CWindow* p = it->second;
		it = m_Controls.erase(it);
		delete p;
	}
}

/**********************************************************************//**
 *
 * EBhEvV[W
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	uMsg	= sꂽbZ[W
 * @param [in]	wParam	= sꂽbZ[W@
 * @param [in]	lParam	= sꂽbZ[WA
 * @return	LRESULTl
*//***********************************************************************/
LRESULT ISplashWindow::WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch( uMsg )
	{
	case WM_CREATE:
		break;
	case WM_PAINT:
		{
			PAINTSTRUCT ps;
			HDC hdc = BeginPaint(hWnd,&ps);
			FillRect(hdc,&ps.rcPaint,(HBRUSH)(COLOR_BTNFACE+1));
			EndPaint(hWnd,&ps);
		}
		break;
	}
	return CWindow::WndProc(hWnd, uMsg, wParam, lParam);
}

/**********************************************************************//**
 *
 * Rg[̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	uFlag	= tO
 * @return	Rg[NX
*//***********************************************************************/
CWindow* ISplashWindow::GetControl(UINT uFlag)
{
	CtrlMap::iterator it = m_Controls.find(uFlag);
	if( it == m_Controls.end() ) return nullptr;
	if( it->first != uFlag ) return nullptr;
	return it->second;
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	hInstance	= CX^Xnh
 * @param [in]	hParent		= eEBhE
 * @param [in]	width		= EBhE
 * @param [in]	height		= EBhE
 * @param [in]	uFlags		= ݒtO
 * @param [in]	uIcon		= ACRID
 * @param [in]	uBitmap		= rbg}bvID
 * @param [in]	hFont		= tHginullptȑꍇADEFAULT_GUI_FONTj
 * @return	
*//***********************************************************************/
bool ISplashWindow::Init(HINSTANCE hInstance, HWND hParent
							, int width, int height
							, s32 uFlags, UINT uIcon, UINT uBitmap
							, HGDIOBJ hFont )
{

	DWORD dwStyle = WS_POPUP|WS_CHILD;
	if(hParent == nullptr) 
	{
		dwStyle = WS_OVERLAPPED;
		height += GetSystemMetrics(SM_CYCAPTION);
	}
	// fXNgbv̒Sɕ\
	RECT rc, wrc;
	LONG w = width;
	LONG h = height;
	LONG curr_bottom = 0;
	LONG curr_right	 = w;
	::GetWindowRect(GetDesktopWindow(), &rc);
	LONG dw = rc.right-rc.left;
	LONG dh = rc.bottom-rc.top;
	rc.left		= (dw-w)/2;
	rc.right	= (dw+w)/2;
	rc.top		= (dh-h)/2;
	rc.bottom	= (dh+h)/2;
	::AdjustWindowRect(&rc, dwStyle, FALSE);
	// EBhE쐬
	HWND hWnd = CDlgBase::Create(WC_WXWINDOW
						, TEXT("WXSellInitWindow")
						, dwStyle
						, rc
						, hParent
						, 0
						, nullptr
						, nullptr
						);
	if( hWnd == nullptr ) return false;
	::GetWindowRect(hWnd, &wrc);
	int borderX = GetSystemMetrics( SM_CXBORDER );

	// ʃtHg
	HGDIOBJ hCmnFont = GetStockObject(DEFAULT_GUI_FONT);
	if( hFont == nullptr ) hFont = hCmnFont;

	// rbg}bv
	if( uFlags & INITWND_BITMAP )
	{
		CStaticCtrl* pCtrl = new CStaticCtrl;
		m_Controls.insert(CtrlPair(INITWND_BITMAP, pCtrl));
		rc.top		= curr_bottom+SHELLINITWND_CTRL_H;
		rc.bottom	= rc.top  + 24;
		rc.left		= borderX + 4;
		rc.right	= rc.left + 24;
		pCtrl->CreateImage( 0
			, WS_CHILD|SS_BITMAP
			, uBitmap
			, rc
			, hWnd
			, 0
			, hInstance
			);
		RECT trc;
		pCtrl->GetWindowRect(&trc);
		LONG bmw = trc.right-trc.left;
		curr_bottom = rc.top+trc.bottom-trc.top;
		if( curr_right < rc.left+bmw) 
		{
			curr_right = rc.left+bmw;
		}
		else
		{
			// SɈړ
			pCtrl->SetWindowPos(nullptr, (curr_right-bmw)/2, rc.top, 0);
		}
	}

	// ACR+o[W
	{
		LONG temp_bottom = 0;
		LONG icon_right	= 0;
		if( uFlags & INITWND_ICON )
		{
			CStaticCtrl* pCtrl = new CStaticCtrl;
			m_Controls.insert(CtrlPair(INITWND_ICON, pCtrl));
			rc.top		= curr_bottom+SHELLINITWND_CTRL_H;
			rc.bottom	= rc.top  + 24;
			rc.left		= borderX + 4;
			rc.right	= rc.left + 24;
			pCtrl->CreateImage( 0
				, WS_CHILD|SS_ICON
				, uIcon
				, rc
				, hWnd
				, 0
				, hInstance
				);
			RECT trc;
			pCtrl->GetWindowRect(&trc);
			temp_bottom = rc.top+trc.bottom-trc.top;
			icon_right = rc.left+trc.right-trc.left;
		}
		if( uFlags & INITWND_VI )
		{
			CVersionInfo vi;
			LPTSTR pStr;
			if( vi.Open() )
			{
				// AvP[V
				if( uFlags & INITWND_APPNAME )
				{
					CStaticCtrl* pCtrl = new CStaticCtrl;
					m_Controls.insert(CtrlPair(INITWND_APPNAME, pCtrl));
					rc.top		= curr_bottom+SHELLINITWND_CTRL_H;
					rc.bottom	= rc.top + 12;
					rc.left		= icon_right + 4;
					rc.right	= curr_right - borderX - 4;
					vi.GetProductName(&pStr);
					pCtrl->Create(WS_CHILD|SS_RIGHT
						, pStr
						, rc
						, hWnd
						, 0
						, hInstance
						);
					curr_bottom = rc.bottom;
					pCtrl->SetFont(hFont,FALSE);
				}
				if( temp_bottom < curr_bottom ) icon_right = 0;
				// o[W
				if( uFlags & INITWND_VERSION )
				{
					CStaticCtrl* pCtrl = new CStaticCtrl;
					m_Controls.insert(CtrlPair(INITWND_VERSION, pCtrl));
					rc.top		= curr_bottom+SHELLINITWND_CTRL_H;
					rc.bottom	= rc.top + 12;
					rc.left		= icon_right + 4;
					rc.right	= curr_right - borderX - 4;
					vi.GetFileVersion(&pStr);
					pCtrl->Create(WS_CHILD|SS_RIGHT
						, pStr
						, rc
						, hWnd
						, 0
						, hInstance
						);
					curr_bottom = rc.bottom;
					pCtrl->SetFont(hFont,FALSE);
				}
				if( temp_bottom < curr_bottom ) icon_right = 0;
				// Copyright
				if( uFlags & INITWND_COPYRIGHT )
				{
					CStaticCtrl* pCtrl = new CStaticCtrl;
					m_Controls.insert(CtrlPair(INITWND_COPYRIGHT, pCtrl));
					rc.top		= curr_bottom+SHELLINITWND_CTRL_H;
					rc.bottom	= rc.top + 12;
					rc.left		= icon_right + 4;
					rc.right	= curr_right - borderX - 4;
					vi.GetLegalCopyright(&pStr);
					pCtrl->Create(WS_CHILD|SS_RIGHT
						, pStr
						, rc
						, hWnd
						, 0
						, hInstance
						);
					curr_bottom = rc.bottom;
					pCtrl->SetFont(hFont,FALSE);
				}
				// Company
				if( uFlags & INITWND_COMPANYNAME )
				{
					CStaticCtrl* pCtrl = new CStaticCtrl;
					m_Controls.insert(CtrlPair(INITWND_COMPANYNAME, pCtrl));
					rc.top		= curr_bottom+SHELLINITWND_CTRL_H;
					rc.bottom	= rc.top + 12;
					rc.left		= icon_right + 4;
					rc.right	= curr_right - borderX - 4;
					vi.GetCompanyName(&pStr);
					pCtrl->Create(WS_CHILD|SS_RIGHT
						, pStr
						, rc
						, hWnd
						, 0
						, hInstance
						);
					curr_bottom = rc.bottom;
					pCtrl->SetFont(hFont,FALSE);
				}
			}
			if( curr_bottom < temp_bottom ) curr_bottom = temp_bottom;
		}
	}

	// eLXg1
	if( uFlags & INITWND_TEXT1 )
	{
		CStaticCtrl* pCtrl = new CStaticCtrl;
		m_Controls.insert(CtrlPair(INITWND_TEXT1, pCtrl));
		rc.top		= curr_bottom+SHELLINITWND_CTRL_H;
		rc.bottom	= rc.top + 16;
		rc.left		= borderX + 4;
		rc.right	= curr_right - borderX - 4;
		pCtrl->Create(WS_CHILD|SS_LEFT
			, nullptr
			, rc
			, hWnd
			, 0
			, hInstance
			);
		curr_bottom = rc.bottom;
		pCtrl->SetFont(hFont,FALSE);
	}
	// eLXg2
	if( uFlags & INITWND_TEXT2 )
	{
		CStaticCtrl* pCtrl = new CStaticCtrl;
		m_Controls.insert(CtrlPair(INITWND_TEXT2, pCtrl));
		rc.top		= curr_bottom+SHELLINITWND_CTRL_H;
		rc.bottom	= rc.top + 16;
		rc.left		= borderX + 4;
		rc.right	= curr_right - borderX - 4;
		pCtrl->Create(WS_CHILD|SS_LEFT
			, nullptr
			, rc
			, hWnd
			, 0
			, hInstance
			);
		curr_bottom = rc.bottom;
		pCtrl->SetFont(hFont,FALSE);
	}

	// vOXo[쐬
	if( uFlags & INITWND_PROGRESS)
	{
		CProgressBar* pCtrl = new CProgressBar;
		m_Controls.insert(CtrlPair(INITWND_PROGRESS, pCtrl));
		rc.top		= curr_bottom+SHELLINITWND_CTRL_H;
		rc.bottom	= rc.top + 12;
		rc.right	= curr_right - borderX - 4;
		rc.left		= borderX + 4;
		pCtrl->Create(WS_CHILD|PBS_SMOOTH, TEXT("WXSplashWindow:Progress")
			, rc
			, hWnd
			, 0
			, nullptr
			, nullptr
			);
		pCtrl->SetRange32(0, 10000);
		curr_bottom = rc.bottom;
	}

	curr_bottom += 4;
	// EBhETCY𒲐
	rc.left		= (dw-curr_right)/2;
	rc.right	= (dw+curr_right)/2;
	rc.top		= (dh-curr_bottom)/2;
	rc.bottom	= (dh+curr_bottom)/2;
	MoveWindow(rc.left, rc.top, curr_right, curr_bottom, TRUE);

	// ̎_ł͔\ATu͕\
	for( CtrlMap::iterator it = m_Controls.begin(), end = m_Controls.end(); it != end; ++it )
	{
		CWindow* p = it->second;
		p->ShowWindow(SW_SHOW);
	}
	ShowWindow(SW_HIDE);
	m_hParent = hParent;

	// j
	DeleteObject(hCmnFont);
	return true;
}

/**********************************************************************//**
 *
 * s
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
INT_PTR ISplashWindow::Exec(void)
{
	// XbhJn
	CreateStart();
	// őOʂ
	SetForegroundWindow();
	// [_Ŏs
	ModalDialogBox();
	// eEBhEtH[JX
	::SetFocus(m_hParent);
	return m_ExitCode;
}

/**********************************************************************//**
 *
 * vOXo[ʒu̐ݒu
 *
 ----------------------------------------------------------------------
 * @param [in]	ratio	= 100
*//***********************************************************************/
void ISplashWindow::SetProgressRatio(float ratio)
{
	if( m_hWnd == nullptr ) return;
	int nMin=0, nMax=0;
	CProgressBar* pCtrl = dcast<CProgressBar*>(GetControl(INITWND_PROGRESS));
	if( pCtrl == nullptr ) return;
	pCtrl->GetRange(nMin, nMax);
	int nRange = nMax-nMin;
	pCtrl->SetPos((int)(nRange*ratio/100.0f)+nMin);
}

/**********************************************************************//**
 *
 * vOXo[ʒủZ
 *
 ----------------------------------------------------------------------
 * @param [in]	ratio	= 100
*//***********************************************************************/
void ISplashWindow::AddProgressRatio(float ratio)
{
	if( m_hWnd == nullptr ) return;
	int nMin=0, nMax=0;
	CProgressBar* pCtrl = dcast<CProgressBar*>(GetControl(INITWND_PROGRESS));
	if( pCtrl == nullptr ) return;
	pCtrl->GetRange(nMin, nMax);
	int nRange = nMax-nMin;
	int nPos = pCtrl->GetPos();
	pCtrl->SetPos((int)(nRange*ratio/100.0f)+nMin+nPos);
}

/**********************************************************************//**
 *
 * eLXgݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	uFlag		= tO
 * @param [in]	lpszText	= eLXg
 * @return	
*//***********************************************************************/
BOOL ISplashWindow::SetText(UINT uFlag, LPCTSTR lpszText)
{
	if( m_hWnd == nullptr ) return 0;
	CWindow* pCtrl = GetControl(uFlag);
	if( pCtrl == nullptr ) return 0;
	return pCtrl->SetWindowText(lpszText);
}

/**********************************************************************//**
 *
 * tHgݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	uFlag		= tO
 * @param [in]	hFont	= tHg
 * @param [in]	Redraw	= ĕ`tO
*//***********************************************************************/
void ISplashWindow::SetFont(UINT uFlag, HGDIOBJ hFont, BOOL Redraw)
{
	if( m_hWnd == nullptr ) return;
	CWindow* pCtrl = GetControl(uFlag);
	if( pCtrl == nullptr ) return;
	pCtrl->SetFont(hFont,Redraw);
}

/**********************************************************************//**
 *
 * Sleep
 *
 ----------------------------------------------------------------------
 * @param [in]	dwMilliseconds		= ~b
*//***********************************************************************/
void ISplashWindow::Sleep(DWORD dwMilliseconds)
{
	if( m_hWnd != nullptr ) ::Sleep(dwMilliseconds);
}

}	// end of namespace wx
}	// end of namespace iris


#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../debug/unittest/WXDebugUnitTest.h"
#include "iris.h"
#include "../../wx.h"

//======================================================================
// class
class CWXSplashWindowUnitTest : public iris::unit::CUnitTest<CWXSplashWindowUnitTest>
{
public:
	// pFunctor
	typedef struct InitFunctor
	{
		DWORD operator()(CWXSplashWindowUnitTest* p, void* arg) { return (DWORD)p->OnInit(arg); }
	} InitFunctor;
public:
	DWORD	OnInit(void* arg)
	{
		LPSplashWindow pInit = static_cast<LPSplashWindow>(arg);
		pInit->SetProgressRatio(0.0f);
		pInit->SetText(ISplashWindow::INITWND_TEXT2, TEXT(""));
		pInit->SetText(ISplashWindow::INITWND_TEXT1, TEXT(""));

		for( int i=1, step=100; i < step; ++i )
		{
			TCHAR text[32];
			wsprintf(text, TEXT("Step %d."), i );
			pInit->SetProgressRatio(100.0f/step*i);
			pInit->SetText(ISplashWindow::INITWND_TEXT1, text);

			Sleep(50);
		}

		pInit->SetText(ISplashWindow::INITWND_TEXT1, TEXT("Finish"));
		return 1;
	}
};

//======================================================================
// test
IRIS_UNITTEST_FIX(CWXSplashWindowUnitTest, WXSplashWindowUnitTest)
{
	WXInit();

	CWXSplashWindowUnitTest* pUT = CWXSplashWindowUnitTest::GetCurrent();
	// EBhE
	CSplashWindow<CWXSplashWindowUnitTest, CWXSplashWindowUnitTest::InitFunctor> InitWnd(pUT);

	// s
	InitWnd.Init( GetModuleHandle(nullptr), nullptr
		, 300, 300
		, ISplashWindow::INITWND_ALL
#ifdef IDI_ICON1
		, IDI_ICON1
#else
		, 0
#endif

#ifdef IDB_BITMAP1
		, IDB_BITMAP1
#else
		, 0
#endif
		);
	INT_PTR ret = InitWnd.Exec();

	WXTerm();
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
