//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDesktopProfile.h
 * @brief		Desktop.iniNX
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXDesktopProfile_H_
#define _IRIS_WXDesktopProfile_H_

//======================================================================
// include
#include "../../registry/WXProfile.h"

namespace iris {
namespace wx 
{

//======================================================================
// function
// ǂݍ
BOOL	ReadDesktopProfile (LPCTSTR lpszDirectory, LPTSTR lpszImagePath, DWORD dwImagePathSize
								, LPDWORD lpdwTextColor, LPDWORD lpdwTextBkColor);
BOOL	ReadDesktopProfileA(LPCSTR  lpszDirectory, LPSTR  lpszImagePath, DWORD dwImagePathSize
								, LPDWORD lpdwTextColor, LPDWORD lpdwTextBkColor);
BOOL	ReadDesktopProfileW(LPCWSTR lpszDirectory, LPWSTR lpszImagePath, DWORD dwImagePathSize
								, LPDWORD lpdwTextColor, LPDWORD lpdwTextBkColor);

// 
BOOL	WriteDesktopProfile (LPCTSTR lpszDirectory, LPCTSTR lpszImagePath, LPDWORD lpdwTextColor, LPDWORD lpdwTextBkColor);
BOOL	WriteDesktopProfileA(LPCSTR  lpszDirectory, LPCSTR  lpszImagePath, LPDWORD lpdwTextColor, LPDWORD lpdwTextBkColor);
BOOL	WriteDesktopProfileW(LPCWSTR lpszDirectory, LPCWSTR lpszImagePath, LPDWORD lpdwTextColor, LPDWORD lpdwTextBkColor);

// NA
BOOL	ClearDesktopProfile (LPCTSTR lpszDirectory);
BOOL	ClearDesktopProfileA(LPCSTR  lpszDirectory);
BOOL	ClearDesktopProfileW(LPCWSTR lpszDirectory);

//======================================================================
// class
//! DesktopPrivateProfileNX
class CDesktopProfile : public CPrivateProfile
{
private:
	TCHAR	m_ImagePath[MAX_PATH];
	DWORD	m_dwTextColor;
	DWORD	m_dwTextBkColor;
public:
	// RXgN^
	CDesktopProfile(void);
	// fXgN^
	~CDesktopProfile(void);

public:
	// ǂݍ
	BOOL	Read(LPCTSTR lpszDirectory);
	// 
	BOOL	Write(LPCTSTR lpszDirectory);
	// 
	BOOL	Write(LPCTSTR lpszDirectory, bool bImage, bool bColor, bool bBkColor);
	// NA
	BOOL	Clear(LPCTSTR lpszDirectory);

public:
	// get, set
	LPTSTR	GetImagePath(void)				{ return m_ImagePath; }
	LPCTSTR	GetImagePath(void)	const		{ return m_ImagePath; }
	void	SetImagePath(LPCTSTR lpszPath);
	DWORD	GetTextColor(void)				{ return m_dwTextColor; }
	void	SetTextColor(DWORD dwColor)		{ m_dwTextColor = dwColor; }
	DWORD	GetTextBkColor(void)			{ return m_dwTextBkColor; }
	void	SetTextBkColor(DWORD dwColor)	{ m_dwTextBkColor = dwColor; }

};

}	// end of namespace wx
}	// end of namespace iris

#endif
