//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXPlugin.h
 * @brief		vOCNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXPlugin_H_
#define _IRIS_WXPlugin_H_

//======================================================================
// include
#include "fnd/utility/FndUID.h"
#include <map>

namespace iris {
namespace wx
{

//======================================================================
// class
//! vOCx[XNX
class IPluginBase : public INonCopyObject
{
	friend class CPluginManegr;
private:
	s32	m_ID;	//!< vOCBID
public:
	// RXgN^
	IPluginBase(void) : m_ID(0) {}
	// fXgN^
	~IPluginBase(void) {}

public:
	// vOCo^̏
	virtual	bool			OnCreate(void)	{ return true; }
	// vOC폜̏
	virtual	void			OnDelete(void)	{}

public:
	// UID̎擾
	int				GetID(void)	{ return m_ID; }
};

//! vOCǗNX
class CPluginManegr : public INonCopyObject
{
public:
	typedef std::map<u32, IPluginBase*>		PluginMap;
	typedef std::pair<u32, IPluginBase*>	PluginPair;
	typedef PluginMap::iterator				iterator;

	typedef std::map<u32, HMODULE>		ModuleMap;
	typedef std::pair<u32, HMODULE>		ModulePair;

private:
	PluginMap	m_Plugins;
	ModuleMap	m_Modules;
	fnd::CUIDGenerator<1024, 10800>	m_UID;
public:
	// RXgN^
	CPluginManegr(void);
	// fXgN^
	~CPluginManegr(void);

public:
	// 
	bool	Initialize(void);
	// 
	void	Release(void);
	// vOCdll̓Ǎ
	s32		LoadPulgin(LPCTSTR fname);
	// vOC̉
	bool	UnloadPulgin(u32 id);

public:
	// vOCNX̎擾
	iterator	begin(void);
	// vOCNX̎擾
	iterator	end(void);
};

}	// end of namespace wx
}	// end of namespace iris

//======================================================================
// function
EXTERN_C_BEGIN

IRIS_DLLEXPORT iris::wx::IPluginBase* WINAPI CreatePluginInstance(void);
IRIS_DLLEXPORT void WINAPI DeletePluginInstance(iris::wx::IPluginBase* lpPlugin);

EXTERN_C_END

#endif
