//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXCustomAccel.h
 * @brief		ANZ[^L[JX^}CY
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXCustomAccel_H_
#define _IRIS_WXCustomAccel_H_

//======================================================================
// include
#include "../../app/WXDlgBase.h"
#include "../../control/WXHotKey.h"
#include "../../control/WXButton.h"
#include "../../control/WXTabCtrl.h"

namespace iris {
namespace wx 
{

//======================================================================
// define
// ₷悤ɒ`
#define FK	FVIRTKEY
#define FS	FSHIFT
#define FC	FCONTROL
#define FA	FALT

//======================================================================
// class
//! JX^ANZ[^NX
class CCustomAccel : public INonCopyObject
{
public:
	//! ANZ[^L[
	typedef struct ACCELINFO
	{
		int		group;	//!< ^uO[v
		WORD	resID;	//!< \[XID
		BYTE	key;	//!< L[
		BYTE	fv;		//!< ⏕L[
		bool	flag;	//!< gptO
		LPTSTR	comm;	//!< Rg
	} ACCELINFO;

	//! ANZ[^̃^Cv
	typedef enum ACCELTYPE
	{
		eTYPE_EDIT = 0,		//!< ҏW\
		eTYPE_CONST,		//!< ҏWsiinit@Cɂ͕ۑj
		eTYPE_STATICCONST,	//!< ҏWs
		eTYPE_NUM,

		eTYPE_SAVENUM = eTYPE_NUM-1,

		eTYPE_TERM
	} ACCELTYPE;
private:
	// ANZ[^L[
	int		m_AccelNum;
	// ANZ[^L[
	int		m_AccelTypeNum[eTYPE_NUM];
	// O[vő吔
	int		m_GroupMaxNum;
	int		m_GroupNum;	//!< O[v

	// ҏW\ANZ[^L[
	ACCELINFO*	m_pAccel[eTYPE_NUM];
	ACCELINFO*	m_pTempAccel;

protected:
	// edit
	HINSTANCE	m_hInst;			//!< CX^Xnh
	HMENU		m_hMenu;			//!< ANZ[^L[̏Ԃ𔽉f郁j[nh
	CDlgBase	m_Dlg;				//!< ҏW_CAONX
	int			m_EditS, m_EditE;
	int			m_EditMenuGroup;	//!< ҏW̃O[v
	TCHAR**		m_ppGroupName;		//!< O[vi^uj

	WINDOWPLACEMENT	m_WndPlace;		//!< ҏW_CAȌ

	//! `FbN{^
	CButton*	m_pButton;
	//! zbgL[
	CHotKey*	m_pHotkey;
	//! ^uRg[
	CTabCtrl	m_Tab;
	//! ^uEBhE
	CSubClass	m_TabWindow;

public:
	// RXgN^
	CCustomAccel(void);
	// fXgN^
	~CCustomAccel(void);

public:

	// (nullptr)
	bool			Initialize(HINSTANCE hInst, HMENU hMenu, HICON hIcon
								,ACCELINFO* pEdit, int EditNum
								,ACCELINFO* pConst, int ConstNum
								,ACCELINFO* pStaticConst, int StaticConstNum
								);
	// O[vo^
	bool			SetGroupName(int group, LPCTSTR name, size_t size);
	bool			SetGroupName(TCHAR** ppArray, int size);
	bool			AutoSetGroupName(void);
	// 
	void			Release(void);

private:
	// O[vԍCfbNXɕϊ
	int				GroupToIndex(int group);
	// CfbNXO[vԍɕϊ
	int				IndexToGroup(int index);
public:

	// ANZ[^L[̓ǂݍ
	bool			Load(LPCTSTR path);
	// ANZ[^L[̕ۑ
	bool			Save(LPCTSTR path);
	// ANZ[^L[̐ݒ
	HACCEL			SetAccel(HACCEL hAccel);
	// ANZ[^L[̃j[f
	void			SetMenu(HMENU hMenu);

	// ҏW_CAÕI[v
	INT_PTR			OpneDlg(HWND hParent, LPTSTR title=nullptr);

public:

	LRESULT CALLBACK DlgProc	(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
	LRESULT CALLBACK TabDlgProc	(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);

};

}	// end of namespace wx
}	// end of namespace iris

#endif
