//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXWab.h
 * @brief		WABt@C
 *
 *
 * @note		TODO: WCHAR ΏKviMicrosoft̃oOΏj
 *				WCHAR̍Ē`ŃG[ƂȂ邽߁AYӏRgAEgȂǂĂB
 *
 * @author		t.sirayanagi
 * @version		1.0
 * @ingroup		wab
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXWab_H_
#define _IRIS_WXWab_H_

//======================================================================
// include
#include "iris_object.h"
// WCHAR̍Ē`ŃG[ƂȂ̂ŁA`Ȃ悤Ή
#if	IRIS_MSC_AT_LESS(_MSC_VER_VC9)
#  define	UNIX
#endif
#include <wab.h>
#if	IRIS_MSC_AT_LESS(_MSC_VER_VC9)
#  undef	UNIX
#endif

namespace iris {
namespace wx
{

//======================================================================
// class
/** 
 *	@class		iris::wx::CWab
 *	@brief		wabNX
*/
class CWab : public INonCopyObject
{
protected:
	// ֐`
	typedef HRESULT (WINAPI *WABOpenProc)(LPADRBOOK*,LPWABOBJECT*,LPWAB_PARAM,DWORD);
	typedef void	(WINAPI *WABGetValueProc)(LPSPropValue lpPropValue, ULONG row_idx, ULONG prop_idx, LPVOID args);

private:
	// CũCX^X
	static HINSTANCE	s_hLibWab;
	// ֐|C^
	static WABOpenProc	s_WABOpenProc;
private:
	// 
	LPADRBOOK	m_lpAdrBook;
	LPWABOBJECT m_lpWABObject;
	ULONG		m_lpcbEntryID;
	LPENTRYID	m_lpEntryID;
	ULONG		m_ulObjType;
	LPUNKNOWN	m_lpUnk;

public:
	// RXgN^
	CWab(void);
	// fXgN^
	~CWab(void);

public:
	// CX^X
	static bool LoadInstance();
	// CX^Xj
	static void UnloadInstance();
	
public:
	// get
	LPADRBOOK		GetAdrBook(void)	{ return m_lpAdrBook; }
	LPWABOBJECT		GetWabObject(void)	{ return m_lpWABObject; }
	ULONG			GetcbEntryID(void)	{ return m_lpcbEntryID; }
	LPENTRYID		GetEntryID(void)	{ return m_lpEntryID; }
	ULONG			GetObjType(void)	{ return m_ulObjType; }
	LPUNKNOWN		GetUnkown(void)		{ return m_lpUnk; }

public:
	// wab func
	bool		WABOpen(LPWAB_PARAM lpWabParam, DWORD Reserved2);
	bool		WABEntry(void);
	LPSRowSet	GetABSRows(void);
	HRESULT		FreeBuffer(LPVOID buf)	{ return m_lpWABObject->FreeBuffer(buf); }

public:
	// open
	bool		Open(LPSTR path, HWND hWnd=nullptr, ULONG ulFlag=0, DWORD Reserved2=0);
	// f[^擾
	bool		GetValue(WABGetValueProc func, LPVOID args);

};

}	// end of namespace wx
}	// end of namespace iris

#endif	// #ifndef _WXWab_H_
