//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXFindHeap.cpp
 * @brief		Heap NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXFindHeap_CPP_

//======================================================================
// include
#include "WXFindHeap.h"
#include <tchar.h>

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CFindHeap::CFindHeap(void)
{
	SecureZeroMemory(&m_Entry, sizeof(m_Entry));
	m_Entry.dwSize = sizeof(m_Entry);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CFindHeap::~CFindHeap(void)
{
}

/**********************************************************************//**
 *
 * vZXID猟
 *
 -----------------------------------------------------------------------
 * @param [in]	dwProcessId	= vZXID
 * @param [in]	ulHeapId	= q[vID
 * @return	q[vnh
*//***********************************************************************/
HANDLE CFindHeap::FindHeap(DWORD dwProcessId, ULONG_PTR ulHeapId)
{
	CToolHelp toolhelp = CToolHelp::CreateImplement();
	if( toolhelp.Heap32First(&m_Entry, dwProcessId, ulHeapId) )
	{
		return m_Entry.hHandle;
	}
	return 0;
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @return	q[vnh
*//***********************************************************************/
HANDLE CFindHeap::FindHeapNext(void)
{
	CToolHelp toolhelp = CToolHelp::CreateImplement();
	while(1)
	{
		if( !toolhelp.Heap32Next(&m_Entry) ) break;
		return m_Entry.hHandle;
	}
	return 0;
}

}	// end of namespace wx
}	// end of namespace iris

#if	(defined(_IRIS_SUPPORT_GOOGLETEST) || defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "iris.h"

TEST(CFindHeapTest, Function)
{
	CFindHeap find;
	ASSERT_EQ( (HANDLE)0, find.FindHeap(::GetCurrentProcessId(), 0) );
}

#endif