//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDirectoryEntry.h
 * @brief		DIRECTORY ENTRY t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXDirectoryEntry_H_
#define _IRIS_WXDirectoryEntry_H_

//======================================================================
// include
#include "iris_object.h"
#include <dbghelp.h>

//======================================================================
// link
#pragma	comment(lib,"dbghelp.lib")

namespace iris {
namespace wx
{

//======================================================================
// class
template<USHORT DirectoryEntry>
class CDirectoryEntry : public IIrisObject
{
	template<USHORT DE>struct type_impl { typedef PVOID	type; }
	template<>struct type_impl<IMAGE_DIRECTORY_ENTRY_IMPORT> { typedef PIMAGE_IMPORT_DESCRIPTOR	type; }

public:
	typedef typename type_impl<DirectoryEntry>::type	type;

public:
	/// f[^擾
	type	ToData(PVOID pBase, BOOLEAN bMappedAsImage, PULONG pSize)
	{
		return (type)(ImageDirectoryEntryToData(pBase, bMappedAsImage, DirectoryEntry, pSize);
	}
	/// f[^擾
	type	ToData(PVOID pBase, BOOLEAN bMappedAsImage)
	{
		ULONG uSize = 0;
		return ToData(pBase, bMappedAsImage, &uSize);
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif
