//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXToolBar.h
 * @brief		ToolBart@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXToolBar_H_
#define _IRIS_WXToolBar_H_

//======================================================================
// include
#include "WXSubClass.h"
#include <commctrl.h>

namespace iris {
namespace wx
{

//======================================================================
// declare 
class CToolBar;

//======================================================================
// define
#ifndef LPTBSAVEPARAMSW
#define	LPTBSAVEPARAMSW	LPTBSAVEPARAMW	// TODO:commctrl̃oOH
#endif

//======================================================================
// function
// C[W̒ǉ
int			ToolBar_AddBitmap(HWND hWnd, int nButtons, LPTBADDBITMAP ptabm);
// {^̒ǉ
BOOL		ToolBar_AddButtons (HWND hWnd, int nButtons, LPTBBUTTON lptb);
BOOL		ToolBar_AddButtonsA(HWND hWnd, int nButtons, LPTBBUTTON lptb);
BOOL		ToolBar_AddButtonsW(HWND hWnd, int nButtons, LPTBBUTTON lptb);
// 񃊃Xgɕǉ
int			ToolBar_AddString (HWND hWnd, HINSTANCE hInst, LPCTSTR lpString);
int			ToolBar_AddStringA(HWND hWnd, HINSTANCE hInst, LPCSTR  lpString);
int			ToolBar_AddStringW(HWND hWnd, HINSTANCE hInst, LPCWSTR lpString);
// TCY𒲐
void		ToolBar_AutoSize(HWND hWnd);
// {^̑擾
int			ToolBar_ButtonCount(HWND hWnd);
// TBBUTTON\̂̃TCYʒm
LRESULT		ToolBar_ButtonStructSize(HWND hWnd);
// {^̃rbg}bvύX
BOOL		ToolBar_ChangeBitmap(HWND hWnd, int idButton, int nBitmap);
// {^̃`FbNԂݒ
BOOL		ToolBar_CheckButton(HWND hWnd, int nIndex, BOOL bCheck);
// {^Ɋ֘AtꂽR}hCfbNX擾
int			ToolBar_CommandToIndex(HWND hWnd, int nButtonID);
// c[o[̃JX^}CY_CAO {bNX\
void		ToolBar_Customize(HWND hWnd);
// {^폜
BOOL		ToolBar_DeleteButton(HWND hWnd, int nIndex);
// {^̗LEݒ
BOOL		ToolBar_EnableButton(HWND hWnd, int idButton, BOOL bEnable);
// AJ[̋\ݒ擾
BOOL		ToolBar_GetAnchorHighlight(HWND hWnd);
// {^Ɋ֘AÂꂽrbg}bṽCfbNX擾
int			ToolBar_GetBitmap(HWND hWnd, int idButton);
// {^擾
BOOL		ToolBar_GetButton(HWND hWnd, int nIndex, LPTBBUTTON lptb);
// {^TCY̎擾
DWORD		ToolBar_GetButtonSize(HWND hWnd);
// {^eLXg̎擾
int			ToolBar_GetButtonText (HWND hWnd, int nIndex, LPTSTR lpString);
int			ToolBar_GetButtonTextA(HWND hWnd, int nIndex, LPSTR  lpString);
int			ToolBar_GetButtonTextW(HWND hWnd, int nIndex, LPWSTR lpString);
// Rg[̔zF擾
BOOL		ToolBar_GetColorScheme(HWND hWnd, LPCOLORSCHEME lpClrScheme);
// Ԃ̃C[WXg擾
HIMAGELIST	ToolBar_GetDisabledImageList(HWND hWnd);
// gX^C̎擾
DWORD		ToolBar_GetExtendedStyle(HWND hWnd);
// zbgԂ̃C[WXg擾
HIMAGELIST	ToolBar_GetHotImageList(HWND hWnd);
// zbgACẽCfbNX擾
int			ToolBar_GetHotItem(HWND hWnd);
// ftHgԂ̃C[WXg擾
HIMAGELIST	ToolBar_GetImageList(HWND hWnd);
// }}[N擾
void		ToolBar_GetInsertMark(HWND hWnd, LPTBINSERTMARK lptbim);
// }}[N̐F擾
COLORREF	ToolBar_GetInsertMarkColor(HWND hWnd);
// {^̃TCY擾
BOOL		ToolBar_GetItemRect(HWND hWnd, int nIndex, LPRECT lprc);
// \\ȃ{^Ƌ؂L̍vTCY擾
BOOL		ToolBar_GetMaxSize(HWND hWnd, LPSIZE lpSize);
// 
LRESULT		ToolBar_GetObject(HWND hWnd, WPARAM iid, LPVOID* ppvObject);
// ѐ̖ߍ݂擾
DWORD		ToolBar_GetPadding(HWND hWnd);
// {^̈̎擾
LRESULT		ToolBar_GetRect(HWND hWnd, int nID, LPRECT lprc);
// ݕ\Ă{^̍s擾
int			ToolBar_GetRows(HWND hWnd);
// {^Ԃ̎擾
DWORD		ToolBar_GetState(HWND hWnd, int nIndex);
// 擾
int			ToolBar_GetString (HWND hWnd, int nIndex, LPTSTR lpString, int cchMaxLen);
int			ToolBar_GetStringA(HWND hWnd, int nIndex, LPSTR  lpString, int cchMaxLen);
int			ToolBar_GetStringW(HWND hWnd, int nIndex, LPWSTR lpString, int cchMaxLen);
// X^C̎擾
DWORD		ToolBar_GetStyle(HWND hWnd);
// {^ɕ\\ȃeLXg̍s擾
int			ToolBar_GetTextRows(HWND hWnd);
// c[`bv擾
HWND		ToolBar_GetToolTips(HWND hWnd);
// 
BOOL		ToolBar_GetUnicodeFormat(HWND hWnd);
// {^̕\Ԃݒ
BOOL		ToolBar_HideButton(HWND hWnd, int nIndex, BOOL bHide);
// qbgeXg
int			ToolBar_HitTest(HWND hWnd, LPPOINT lppt);
// {^̏Ԃݒ
BOOL		ToolBar_InDeterminate(HWND hWnd, int nIndex, BOOL bInd);
// {^}
BOOL		ToolBar_InsertButton (HWND hWnd, int nIndex, LPTBBUTTON lptb);
BOOL		ToolBar_InsertButtonA(HWND hWnd, int nIndex, LPTBBUTTON lptb);
BOOL		ToolBar_InsertButtonW(HWND hWnd, int nIndex, LPTBBUTTON lptb);
// c[ o[̍WʒuɊւ}}[N擾
BOOL		ToolBar_InsertMarkHitTest(HWND hWnd, LPPOINT lppt, LPTBINSERTMARK lptbim);
// {^̃`FbNԂ擾
BOOL		ToolBar_IsButtonChecked(HWND hWnd, int idButton);
// {^̗LE擾
BOOL		ToolBar_IsButtonEnable(HWND hWnd, int nIndex);
// {^̕\Ԃ擾
BOOL		ToolBar_IsButtonHidden(HWND hWnd, int nIndex);
// {^̃nCCgԂ擾
BOOL		ToolBar_IsButtonHighLighted(HWND hWnd, int nIndex);
// {^̏Ԃ擾
BOOL		ToolBar_IsButtonInDeterminate(HWND hWnd, int nIndex);
// {^̉Ԃ擾
BOOL		ToolBar_IsButtonPressed(HWND hWnd, int nIndex);
// VXe`̃C[WC[WXgɒǉ
int			ToolBar_LoadImages(HWND hWnd, int nBitmapID, HINSTANCE hInst);
// ANZ[^{^Ɋ蓖Ă
BOOL		ToolBar_MapAccelerator (HWND hWnd, TCHAR Accel, UINT* lpIDBtn);
BOOL		ToolBar_MapAcceleratorA(HWND hWnd, CHAR  Accel, UINT* lpIDBtn);
BOOL		ToolBar_MapAcceleratorW(HWND hWnd, WCHAR Accel, UINT* lpIDBtn);
// {^̏Ԃݒ
BOOL		ToolBar_MarkButton(HWND hWnd, int nIndex, BOOL bMark);
// {^ʂ̃CfbNXɈړ
BOOL		ToolBar_MoveButton(HWND hWnd, UINT uOldIndex, UINT uNewIndex);
// {^̉Ԃݒ
BOOL		ToolBar_PressButton(HWND hWnd, int nIndex, BOOL bPress);
// ̃rbg}bvVrbg}bvŒu
BOOL		ToolBar_ReplaceBitmap(HWND hWnd, LPTBREPLACEBITMAP lptbrb);
// {^̕ۑƕ
LRESULT		ToolBar_SavereStore (HWND hWnd, BOOL bSave, LPTBSAVEPARAMS  lptbsp);
LRESULT		ToolBar_SavereStoreA(HWND hWnd, BOOL bSave, LPTBSAVEPARAMSA lptbsp);
LRESULT		ToolBar_SavereStoreW(HWND hWnd, BOOL bSave, LPTBSAVEPARAMSW lptbsp);
// AJ[̋\ݒݒ
BOOL		ToolBar_SetAnchorHighlight(HWND hWnd, BOOL bAnchor);
// Bitmap̑傫w
BOOL		ToolBar_SetBitmapSize(HWND hWnd, int nWidth, int nHeight);
// {^̑傫w
BOOL		ToolBar_SetButtonSize(HWND hWnd, int nWidth, int nHeight);
// {^̐ݒ
LRESULT		ToolBar_SetButtonWidth(HWND hWnd, int Min, int Max);
// R}h ID ݒ
BOOL		ToolBar_SetCmdID(HWND hWnd, UINT uIndex, UINT uCmdID);
// Rg[̔zFݒ
void		ToolBar_SetColorScheme(HWND hWnd, LPCOLORSCHEME lpClrScheme);
// Ԃ̃C[WXgݒ
HIMAGELIST	ToolBar_SetDisabledImageList(HWND hWnd, int nImageID, HIMAGELIST hImage);
// DrawText̃tOݒ
DWORD		ToolBar_SetDrawTextFlags(HWND hWnd, DWORD dwMask, DWORD dwDTFlags);
// gX^C̐ݒ
DWORD		ToolBar_SetExtendedStyle(HWND hWnd, DWORD dwExStyle);
// zbgԂ̃C[WXgݒ
HIMAGELIST	ToolBar_SetHotImageList(HWND hWnd, int nImageID, HIMAGELIST hImage);
// ACezbgԂɂ
int			ToolBar_SetHotItem(HWND hWnd, int nIndex);
// ftHgԂ̃C[WXgݒ
HIMAGELIST	ToolBar_SetImageList(HWND hWnd, int nImageID, HIMAGELIST hImage);
// ŏ̃{^̃Cfgݒ
BOOL		ToolBar_SetIndent(HWND hWnd, int nIndent);
// }}[N̐ݒ
void		ToolBar_SetInsertMark(HWND hWnd, LPTBINSERTMARK lptbim);
// }}[N̐Fݒ
COLORREF	ToolBar_SetInsertMarkColor(HWND hWnd, COLORREF color);
// {^ɕ\eLXg̍ősݒ
BOOL		ToolBar_SetMaxTextRows(HWND hWnd, int nMaxRows);
// ѐ̖ߍ݂ݒ
DWORD		ToolBar_SetPadding(HWND hWnd, int cx, int cy);
// 
LRESULT		ToolBar_SetParent(HWND hWnd, WPARAM wParam, LPARAM lParam);
// ѕ̕ύX
LRESULT		ToolBar_SetRows(HWND hWnd, int nCount, BOOL bFlag, LPRECT lprc);
// {^Ԃ̐ݒ
BOOL		ToolBar_SetState(HWND hWnd, int nIndex, DWORD dwState);
// X^C̕ύX
LRESULT		ToolBar_SetStyle(HWND hWnd, DWORD dwStyle);
// c[`bvݒ
LRESULT		ToolBar_SetToolTips(HWND hWnd, HWND hWndTT);
// 
BOOL		ToolBar_SetUnicodeFormat(HWND hWnd, BOOL bUnicode);


// hbv_Ej[̕\
void		ToolBar_DropDownMenu(HWND hWnd, HWND hFrom, HMENU hMenu, LPNMTOOLBAR lpnmTB);

//======================================================================
// class
//! {^Rg[
class CToolBar : public CSubClass
{
public:
	// RXgN^
	CToolBar(void);
	CToolBar(HWND hWnd);
	// fXgN^
	~CToolBar(void);

public:
    // EBhE̍쐬
    virtual HWND Create(DWORD dwStyle
					 , const RECT &rRect
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void *pParam = nullptr );
    virtual HWND Create(DWORD dwStyle
					 , int x, int y, int w, int h
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void *pParam = nullptr );
    // EBhE̍쐬
    virtual HWND CreateEx(DWORD dwExStyle
					 , DWORD dwStyle
					 , const RECT &rRect
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void *pParam = nullptr );
    virtual HWND CreateEx(DWORD dwExStyle
					 , DWORD dwStyle
					 , int x, int y, int w, int h
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void *pParam = nullptr );

    virtual HWND CreateEx(HWND hWndParent, DWORD dwStyle, UINT uID, int nBitmaps,
                        HINSTANCE hBMInst, UINT_PTR wBMID, LPCTBBUTTON lpButtons,
                        int iNumButtons, int dxButton, int dyButton,
                        int dxBitmap, int dyBitmap, UINT uStructSize=sizeof(TBBUTTON));

public:
	// evV[W󂯂bZ[WM
	virtual	LRESULT	RecvParentMessage(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
public:
	// wrap
	// C[W̒ǉ
	int			AddBitmap(int nButtons, LPTBADDBITMAP ptabm);
	// {^̒ǉ
	BOOL		AddButtons (int nButtons, LPTBBUTTON lptb);
	BOOL		AddButtonsA(int nButtons, LPTBBUTTON lptb);
	BOOL		AddButtonsW(int nButtons, LPTBBUTTON lptb);
	// 񃊃Xgɕǉ
	int			AddString (HINSTANCE hInst, LPCTSTR lpString);
	int			AddStringA(HINSTANCE hInst, LPCSTR  lpString);
	int			AddStringW(HINSTANCE hInst, LPCWSTR lpString);
	// TCY𒲐
	void		AutoSize(void);
	// {^̑擾
	int			ButtonCount(void);
	// TBBUTTON\̂̃TCYʒm
	LRESULT		ButtonStructSize(void);
	// {^̃rbg}bvύX
	BOOL		ChangeBitmap(int idButton, int nBitmap);
	// {^̃`FbNԂݒ
	BOOL		CheckButton(int nIndex, BOOL bCheck);
	// {^Ɋ֘AtꂽR}hCfbNX擾
	int			CommandToIndex(int nButtonID);
	// c[o[̃JX^}CY_CAO {bNX\
	void		Customize(void);
	// {^폜
	BOOL		DeleteButton(int nIndex);
	// {^̗LEݒ
	BOOL		EnableButton(int idButton, BOOL bEnable);
	// AJ[̋\ݒ擾
	BOOL		GetAnchorHighlight(void);
	// {^Ɋ֘AÂꂽrbg}bṽCfbNX擾
	int			GetBitmap(int idButton);
	// {^擾
	BOOL		GetButton(int nIndex, LPTBBUTTON lptb);
	// {^TCY̎擾
	DWORD		GetButtonSize(void);
	// {^eLXg̎擾
	int			GetButtonText (int nIndex, LPTSTR lpString);
	int			GetButtonTextA(int nIndex, LPSTR  lpString);
	int			GetButtonTextW(int nIndex, LPWSTR lpString);
	// Rg[̔zF擾
	BOOL		GetColorScheme(LPCOLORSCHEME lpClrScheme);
	// Ԃ̃C[WXg擾
	HIMAGELIST	GetDisabledImageList(void);
	// gX^C̎擾
	DWORD		GetExtendedStyle(void);
	// zbgԂ̃C[WXg擾
	HIMAGELIST	GetHotImageList(void);
	// zbgACẽCfbNX擾
	int			GetHotItem(void);
	// ftHgԂ̃C[WXg擾
	HIMAGELIST	GetImageList(void);
	// }}[N擾
	void		GetInsertMark(LPTBINSERTMARK lptbim);
	// }}[N̐F擾
	COLORREF	GetInsertMarkColor(void);
	// {^̃TCY擾
	BOOL		GetItemRect(int nIndex, LPRECT lprc);
	// \\ȃ{^Ƌ؂L̍vTCY擾
	BOOL		GetMaxSize(LPSIZE lpSize);
	// 
	LRESULT		GetObject(WPARAM iid, LPVOID* ppvObject);
	// ѐ̖ߍ݂擾
	DWORD		GetPadding(void);
	// {^̈̎擾
	LRESULT		GetRect(int nID, LPRECT lprc);
	// ݕ\Ă{^̍s擾
	int			GetRows(void);
	// {^Ԃ̎擾
	DWORD		GetState(int nIndex);
	// 擾
	int			GetString (int nIndex, LPTSTR lpString, int cchMaxLen);
	int			GetStringA(int nIndex, LPSTR  lpString, int cchMaxLen);
	int			GetStringW(int nIndex, LPWSTR lpString, int cchMaxLen);
	// X^C̎擾
	DWORD		GetStyle(void);
	// {^ɕ\\ȃeLXg̍s擾
	int			GetTextRows(void);
	// c[`bv擾
	HWND		GetToolTips(void);
	// 
	BOOL		GetUnicodeFormat(void);
	// {^̕\Ԃݒ
	BOOL		HideButton(int nIndex, BOOL bHide);
	// qbgeXg
	int			HitTest(LPPOINT lppt);
	// {^̏Ԃݒ
	BOOL		InDeterminate(int nIndex, BOOL bInd);
	// {^}
	BOOL		InsertButton (int nIndex, LPTBBUTTON lptb);
	BOOL		InsertButtonA(int nIndex, LPTBBUTTON lptb);
	BOOL		InsertButtonW(int nIndex, LPTBBUTTON lptb);
	// c[ o[̍WʒuɊւ}}[N擾
	BOOL		InsertMarkHitTest(LPPOINT lppt, LPTBINSERTMARK lptbim);
	// {^̃`FbNԂ擾
	BOOL		IsButtonChecked(int idButton);
	// {^̗LE擾
	BOOL		IsButtonEnable(int nIndex);
	// {^̕\Ԃ擾
	BOOL		IsButtonHidden(int nIndex);
	// {^̃nCCgԂ擾
	BOOL		IsButtonHighLighted(int nIndex);
	// {^̏Ԃ擾
	BOOL		IsButtonInDeterminate(int nIndex);
	// {^̉Ԃ擾
	BOOL		IsButtonPressed(int nIndex);
	// VXe`̃C[WC[WXgɒǉ
	int			LoadImages(int nBitmapID, HINSTANCE hInst);
	// ANZ[^{^Ɋ蓖Ă
	BOOL		MapAccelerator (TCHAR Accel, UINT* lpIDBtn);
	BOOL		MapAcceleratorA(CHAR  Accel, UINT* lpIDBtn);
	BOOL		MapAcceleratorW(WCHAR Accel, UINT* lpIDBtn);
	// {^̏Ԃݒ
	BOOL		MarkButton(int nIndex, BOOL bMark);
	// {^ʂ̃CfbNXɈړ
	BOOL		MoveButton(UINT uOldIndex, UINT uNewIndex);
	// {^̉Ԃݒ
	BOOL		PressButton(int nIndex, BOOL bPress);
	// ̃rbg}bvVrbg}bvŒu
	BOOL		ReplaceBitmap(LPTBREPLACEBITMAP lptbrb);
	// {^̕ۑƕ
	LRESULT		SavereStore (BOOL bSave, LPTBSAVEPARAMS  lptbsp);
	LRESULT		SavereStoreA(BOOL bSave, LPTBSAVEPARAMSA lptbsp);
	LRESULT		SavereStoreW(BOOL bSave, LPTBSAVEPARAMSW lptbsp);
	// AJ[̋\ݒݒ
	BOOL		SetAnchorHighlight(BOOL bAnchor);
	// Bitmap̑傫w
	BOOL		SetBitmapSize(int nWidth, int nHeight);
	// {^̑傫w
	BOOL		SetButtonSize(int nWidth, int nHeight);
	// {^̐ݒ
	LRESULT		SetButtonWidth(int Min, int Max);
	// R}h ID ݒ
	BOOL		SetCmdID(UINT uIndex, UINT uCmdID);
	// Rg[̔zFݒ
	void		SetColorScheme(LPCOLORSCHEME lpClrScheme);
	// Ԃ̃C[WXgݒ
	HIMAGELIST	SetDisabledImageList(int nImageID, HIMAGELIST hImage);
	// DrawText̃tOݒ
	DWORD		SetDrawTextFlags(DWORD dwMask, DWORD dwDTFlags);
	// gX^C̐ݒ
	DWORD		SetExtendedStyle(DWORD dwExStyle);
	// zbgԂ̃C[WXgݒ
	HIMAGELIST	SetHotImageList(int nImageID, HIMAGELIST hImage);
	// ACezbgԂɂ
	int			SetHotItem(int nIndex);
	// ftHgԂ̃C[WXgݒ
	HIMAGELIST	SetImageList(int nImageID, HIMAGELIST hImage);
	// ŏ̃{^̃Cfgݒ
	BOOL		SetIndent(int nIndent);
	// }}[N̐ݒ
	void		SetInsertMark(LPTBINSERTMARK lptbim);
	// }}[N̐Fݒ
	COLORREF	SetInsertMarkColor(COLORREF color);
	// {^ɕ\eLXg̍ősݒ
	BOOL		SetMaxTextRows(int nMaxRows);
	// ѐ̖ߍ݂ݒ
	DWORD		SetPadding(int cx, int cy);
	// 
	LRESULT		SetParent(WPARAM wParam, LPARAM lParam);
	// ѕ̕ύX
	LRESULT		SetRows(int nCount, BOOL bFlag, LPRECT lprc);
	// {^Ԃ̐ݒ
	BOOL		SetState(int nIndex, DWORD dwState);
	// X^C̕ύX
	LRESULT		SetStyle(DWORD dwStyle);
	// c[`bvݒ
	LRESULT		SetToolTips(HWND hWndTT);
	// 
	BOOL		SetUnicodeFormat(BOOL bUnicode);
	// hbv_Ej[̕\
	void		DropDownMenu(HWND hFrom, HMENU hMenu, LPNMTOOLBAR lpnmTB);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
