//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXToolBar.h
 * @brief		ToolBart@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXToolBar_CPP_

//======================================================================
// include
#include "WXToolBar.h"
#include <windowsx.h>
#include "WXComControl.h"

namespace iris {
namespace wx
{

//======================================================================
// function
/**********************************************************************//**
 *
 * C[WXgɃC[Wǉ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	nButtons	= ptabm̔z
 * @param [in]	ptabm		= TBADDBITMAP\̂̃AhX
 * @return	ǉꂽCfbNX
*//***********************************************************************/
int			ToolBar_AddBitmap(HWND hWnd, int nButtons, LPTBADDBITMAP ptabm)
{
	return (int)SendMessage(hWnd, TB_ADDBITMAP, (WPARAM)nButtons, (LPARAM)ptabm);
}
/**********************************************************************//**
 *
 * {^ǉ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	nButtons	= lptb̔z
 * @param [in]	lptb		= TBBUTTON\̂̃AhX
 * @return	
*//***********************************************************************/
BOOL		ToolBar_AddButtons (HWND hWnd, int nButtons, LPTBBUTTON lptb)
{
	return (BOOL)SendMessage(hWnd, TB_ADDBUTTONS , (WPARAM)nButtons, (LPARAM)lptb);
}
/// iris::wx::ToolBar_AddButtons Q
BOOL		ToolBar_AddButtonsA(HWND hWnd, int nButtons, LPTBBUTTON lptb)
{
#if (_WIN32_IE >= 0x0400)
	return (BOOL)SendMessage(hWnd, TB_ADDBUTTONSA, (WPARAM)nButtons, (LPARAM)lptb);
#else
	return (BOOL)SendMessage(hWnd, TB_ADDBUTTONS , (WPARAM)nButtons, (LPARAM)lptb);
#endif
}
/// iris::wx::ToolBar_AddButtons Q
BOOL		ToolBar_AddButtonsW(HWND hWnd, int nButtons, LPTBBUTTON lptb)
{
#if (_WIN32_IE >= 0x0500)
	return (BOOL)SendMessage(hWnd, TB_ADDBUTTONSW, (WPARAM)nButtons, (LPARAM)lptb);
#else
	return (BOOL)SendMessage(hWnd, TB_ADDBUTTONS , (WPARAM)nButtons, (LPARAM)lptb);
#endif
}
/**********************************************************************//**
 *
 * 񃊃Xgɕǉ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	hInst		= \[X܂ރW[̃CX^X
 * @param [in]	lpString	= hInst==nullptr̂Ƃ́ABȊO̓\[XID
 * @return	ǉꂽCfbNX
*//***********************************************************************/
int			ToolBar_AddString (HWND hWnd, HINSTANCE hInst, LPCTSTR lpString)
{
	return (int)SendMessage(hWnd, TB_ADDSTRING , (WPARAM)hInst, (LPARAM)lpString);
}
/// iris::wx::ToolBar_AddString Q
int			ToolBar_AddStringA(HWND hWnd, HINSTANCE hInst, LPCSTR  lpString)
{
	return (int)SendMessage(hWnd, TB_ADDSTRINGA, (WPARAM)hInst, (LPARAM)lpString);
}
/// iris::wx::ToolBar_AddString Q
int			ToolBar_AddStringW(HWND hWnd, HINSTANCE hInst, LPCWSTR lpString)
{
	return (int)SendMessage(hWnd, TB_ADDSTRINGW, (WPARAM)hInst, (LPARAM)lpString);
}
/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
*//***********************************************************************/
void		ToolBar_AutoSize(HWND hWnd)
{
	SendMessage(hWnd, TB_AUTOSIZE, 0, 0);
}
/**********************************************************************//**
 *
 * {^̑擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @return	{^
*//***********************************************************************/
int			ToolBar_ButtonCount(HWND hWnd)
{
	return (int)SendMessage(hWnd, TB_BUTTONCOUNT, 0, 0);
}
/**********************************************************************//**
 *
 * TBBUTTON\̂̃TCYʒm
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @return	
*//***********************************************************************/
LRESULT		ToolBar_ButtonStructSize(HWND hWnd)
{
	return SendMessage(hWnd, TB_BUTTONSTRUCTSIZE, sizeof(TBBUTTON), 0);
}
/**********************************************************************//**
 *
 * {^̃rbg}bvύX
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	idButton	= {^̃R}hID
 * @param [in]	nBitmap		= C[WXg̃CfbNX
 * @return	
*//***********************************************************************/
BOOL		ToolBar_ChangeBitmap(HWND hWnd, int idButton, int nBitmap)
{
	return (BOOL)SendMessage(hWnd, TB_CHANGEBITMAP, (WPARAM)idButton, MAKELPARAM(nBitmap,0));
}
/**********************************************************************//**
 *
 * {^̃`FbNԂݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	nIndex	= {^CfbNX
 * @param [in]	bCheck	= ݒ
 * @return	
*//***********************************************************************/
BOOL		ToolBar_CheckButton(HWND hWnd, int nIndex, BOOL bCheck)
{
	return (BOOL)SendMessage(hWnd, TB_CHECKBUTTON, (WPARAM)nIndex, (LPARAM)bCheck);
}
/**********************************************************************//**
 *
 * {^Ɋ֘AtꂽR}hCfbNX擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	nButtonID	= R}hID
 * @return	CfbNX
*//***********************************************************************/
int			ToolBar_CommandToIndex(HWND hWnd, int nButtonID)
{
	return (int)SendMessage(hWnd, TB_COMMANDTOINDEX, (WPARAM)nButtonID, 0);
}
/**********************************************************************//**
 *
 * c[o[̃JX^}CY_CAO {bNX\
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
*//***********************************************************************/
void		ToolBar_Customize (HWND hWnd)
{
	SendMessage(hWnd, TB_CUSTOMIZE, 0, 0);
}
/**********************************************************************//**
 *
 * {^폜
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	nIndex	= {^CfbNX
 * @return	
*//***********************************************************************/
BOOL		ToolBar_DeleteButton(HWND hWnd, int nIndex)
{
	return (BOOL)SendMessage(hWnd, TB_DELETEBUTTON, (WPARAM)nIndex, 0);
}
/**********************************************************************//**
 *
 * {^̗LEݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	idButton	= {^ID
 * @param [in]	bEnable		= ݒ
 * @return	
*//***********************************************************************/
BOOL		ToolBar_EnableButton(HWND hWnd, int idButton, BOOL bEnable)
{
	return (BOOL)SendMessage(hWnd, TB_ENABLEBUTTON, (WPARAM)idButton, (LPARAM)bEnable);
}
/**********************************************************************//**
 *
 * AJ[̋\ݒ擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @return	\ݒ
*//***********************************************************************/
BOOL		ToolBar_GetAnchorHighlight(HWND hWnd)
{
	return (BOOL)SendMessage(hWnd, TB_GETANCHORHIGHLIGHT, 0, 0);
}
/**********************************************************************//**
 *
 * {^Ɋ֘AÂꂽrbg}bṽCfbNX擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	idButton	= {^̃R}hID
 * @return	rbg}bṽCfbNX
*//***********************************************************************/
int			ToolBar_GetBitmap(HWND hWnd, int idButton)
{
	return (int)SendMessage(hWnd, TB_GETBITMAP, (WPARAM)idButton, 0);
}
/**********************************************************************//**
 *
 * {^̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	nIndex		= {^CfbNX
 * @param [out]	lptb		= o
 * @return	
*//***********************************************************************/
BOOL		ToolBar_GetButton(HWND hWnd, int nIndex, LPTBBUTTON lptb)
{
	return (BOOL)SendMessage(hWnd, TB_GETBUTTON, (WPARAM)nIndex, (LPARAM)lptb);
}
/**********************************************************************//**
 *
 * {^̃TCY擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @return	ƍ
*//***********************************************************************/
DWORD		ToolBar_GetButtonSize(HWND hWnd)
{
#if (_WIN32_IE >= 0x0300)
	return (DWORD)SendMessage(hWnd, TB_GETBUTTONSIZE, 0, 0);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * {^eLXg̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	nIndex		= {^CfbNX
 * @param [out]	lpString	= o
 * @return	
*//***********************************************************************/
int			ToolBar_GetButtonText (HWND hWnd, int nIndex, LPTSTR lpString)
{
	return (int)SendMessage(hWnd, TB_GETBUTTONTEXT , (WPARAM)nIndex, (LPARAM)lpString);
}
/// iris::wx::ToolBar_GetButtonText Q
int			ToolBar_GetButtonTextA(HWND hWnd, int nIndex, LPSTR	 lpString)
{
	return (int)SendMessage(hWnd, TB_GETBUTTONTEXTA, (WPARAM)nIndex, (LPARAM)lpString);
}
/// iris::wx::ToolBar_GetButtonText Q
int			ToolBar_GetButtonTextW(HWND hWnd, int nIndex, LPWSTR lpString)
{
	return (int)SendMessage(hWnd, TB_GETBUTTONTEXTW, (WPARAM)nIndex, (LPARAM)lpString);
}
/**********************************************************************//**
 *
 * Rg[̔zF擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [out]	lpClrScheme	= zF
 * @return	
*//***********************************************************************/
BOOL	ToolBar_GetColorScheme(HWND hWnd, LPCOLORSCHEME lpClrScheme)
{
	return ComControl_GetColorScheme(hWnd, lpClrScheme);
}
/**********************************************************************//**
 *
 * Ԃ̃C[WXg擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @return	Ԃ̃C[WXg
*//***********************************************************************/
HIMAGELIST	ToolBar_GetDisabledImageList(HWND hWnd)
{
#if (_WIN32_IE >= 0x0300)
	return (HIMAGELIST)SendMessage(hWnd, TB_GETDISABLEDIMAGELIST, 0, 0);
#else
	return nullptr;
#endif
}
/**********************************************************************//**
 *
 * gX^C̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @return	X^C
*//***********************************************************************/
DWORD		ToolBar_GetExtendedStyle(HWND hWnd)
{
#if (_WIN32_IE >= 0x0400)
	return (DWORD)SendMessage(hWnd, TB_GETEXTENDEDSTYLE, 0, 0);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * zbgԂ̃C[WXg擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @return	zbgԂ̃C[WXg
*//***********************************************************************/
HIMAGELIST	ToolBar_GetHotImageList(HWND hWnd)
{
#if (_WIN32_IE >= 0x0300)
	return (HIMAGELIST)SendMessage(hWnd, TB_GETHOTIMAGELIST, 0, 0);
#else
	return nullptr;
#endif
}
/**********************************************************************//**
 *
 * zbgACẽCfbNX擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @return	
*//***********************************************************************/
int			ToolBar_GetHotItem(HWND hWnd)
{
#if (_WIN32_IE >= 0x0400)
	return (int)SendMessage(hWnd, TB_GETHOTITEM, 0, 0);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * ftHgԂ̃C[WXg擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @return	ftHgԂ̃C[WXg
*//***********************************************************************/
HIMAGELIST	ToolBar_GetImageList(HWND hWnd)
{
#if (_WIN32_IE >= 0x0300)
	return (HIMAGELIST)SendMessage(hWnd, TB_GETIMAGELIST, 0, 0);
#else
	return nullptr;
#endif
}
/**********************************************************************//**
 *
 * }}[N擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [out]	lptbim	= o
*//***********************************************************************/
void		ToolBar_GetInsertMark(HWND hWnd, LPTBINSERTMARK lptbim)
{
#if (_WIN32_IE >= 0x0400)
	SendMessage(hWnd, TB_GETINSERTMARK, 0, (LPARAM)lptbim);
#endif
}
/**********************************************************************//**
 *
 * }}[N̐F擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @return	F
*//***********************************************************************/
COLORREF	ToolBar_GetInsertMarkColor(HWND hWnd)
{
#if (_WIN32_IE >= 0x0400)
	return (COLORREF)SendMessage(hWnd, TB_GETINSERTMARKCOLOR, 0, 0);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * {^̃TCY擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	nIndex	= {^CfbNX
 * @param [out]	lprc	= óB̈
 * @return	
*//***********************************************************************/
BOOL		ToolBar_GetItemRect(HWND hWnd, int nIndex, LPRECT lprc)
{
	return (BOOL)SendMessage(hWnd, TB_GETITEMRECT, (WPARAM)nIndex, (LPARAM)lprc);
}
/**********************************************************************//**
 *
 * \\ȃ{^Ƌ؂L̍vTCY擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [out]	lpSize	= óBTCY
 * @return	
*//***********************************************************************/
BOOL		ToolBar_GetMaxSize(HWND hWnd, LPSIZE lpSize)
{
	return (BOOL)SendMessage(hWnd, TB_GETMAXSIZE, 0, (LPARAM)lpSize);
}
/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	iid			= 
 * @param [out]	ppvObject	= 
 * @return	
*//***********************************************************************/
LRESULT		ToolBar_GetObject(HWND hWnd, WPARAM iid, LPVOID* ppvObject)
{
#if (_WIN32_IE >= 0x0400)
	return SendMessage(hWnd, TB_GETOBJECT, iid, (LPARAM)ppvObject);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * ѐ̖ߍ݂擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @return	ʂɐEʂɐ̒lԂ
*//***********************************************************************/
DWORD		ToolBar_GetPadding(HWND hWnd)
{
#if (_WIN32_IE >= 0x0400)
	return (DWORD)SendMessage(hWnd, TB_GETPADDING, 0, 0);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * {^̈̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	nID		= {^ID
 * @param [out]	lprc	= óB̈
 * @return	
*//***********************************************************************/
LRESULT		ToolBar_GetRect(HWND hWnd, int nID, LPRECT lprc)
{
	return SendMessage(hWnd, TB_GETRECT, (WPARAM)nID, (LPARAM)lprc);
}
/**********************************************************************//**
 *
 * ݕ\Ă{^̍s擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @return	s
*//***********************************************************************/
int			ToolBar_GetRows(HWND hWnd)
{
	return (int)SendMessage(hWnd, TB_GETROWS, 0, 0);
}
/**********************************************************************//**
 *
 * {^Ԃ̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	nIndex	= {^CfbNX
 * @return	
*//***********************************************************************/
DWORD		ToolBar_GetState(HWND hWnd, int nIndex)
{
	return (DWORD)SendMessage(hWnd, TB_GETSTATE, (WPARAM)nIndex, 0);
}
/**********************************************************************//**
 *
 * ̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	nIndex		= CfbNX
 * @param [out]	lpString	= o̓obt@
 * @param [in]	cchMaxLen	= o̓obt@TCY
 * @return	
*//***********************************************************************/
int			ToolBar_GetString (HWND hWnd, int nIndex, LPTSTR lpString, int cchMaxLen)
{
#if (_WIN32_IE >= 0x0500)
	return (int)SendMessage(hWnd, TB_GETSTRING , MAKEWPARAM(cchMaxLen, nIndex), (LPARAM)lpString);
#else
	return -1;
#endif
}
/// iris::wx::ToolBar_GetString Q
int			ToolBar_GetStringA(HWND hWnd, int nIndex, LPSTR	 lpString, int cchMaxLen)
{
#if (_WIN32_IE >= 0x0500)
	return (int)SendMessage(hWnd, TB_GETSTRINGA, MAKEWPARAM(cchMaxLen, nIndex), (LPARAM)lpString);
#else
	return -1;
#endif
}
/// iris::wx::ToolBar_GetString Q
int			ToolBar_GetStringW(HWND hWnd, int nIndex, LPWSTR lpString, int cchMaxLen)
{
#if (_WIN32_IE >= 0x0500)
	return (int)SendMessage(hWnd, TB_GETSTRINGW, MAKEWPARAM(cchMaxLen, nIndex), (LPARAM)lpString);
#else
	return -1;
#endif
}
/**********************************************************************//**
 *
 * X^C̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @return	X^C
*//***********************************************************************/
DWORD		ToolBar_GetStyle(HWND hWnd)
{
#if (_WIN32_IE >= 0x0300)
	return (DWORD)SendMessage(hWnd, TB_GETSTYLE, 0, 0);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * {^ɕ\\ȃeLXg̍s擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @return	s
*//***********************************************************************/
int			ToolBar_GetTextRows(HWND hWnd)
{
#if (_WIN32_IE >= 0x0300)
	return (int)SendMessage(hWnd, TB_GETTEXTROWS, 0, 0);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * c[`bv擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @return	c[`bvEBhEnh
*//***********************************************************************/
HWND		ToolBar_GetToolTips(HWND hWnd)
{
	return (HWND)SendMessage(hWnd, TB_GETTOOLTIPS, 0, 0);
}
/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @return	
*//***********************************************************************/
BOOL		ToolBar_GetUnicodeFormat(HWND hWnd)
{
	return ComConrtol_GetUnicodeFormat(hWnd);
}
/**********************************************************************//**
 *
 * {^̕\Ԃݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	nIndex	= {^CfbNX
 * @param [in]	bHide	= ݒ
 * @return	
*//***********************************************************************/
BOOL		ToolBar_HideButton(HWND hWnd, int nIndex, BOOL bHide)
{
	return (BOOL)SendMessage(hWnd, TB_HIDEBUTTON, (WPARAM)nIndex, (LPARAM)bHide);
}
/**********************************************************************//**
 *
 * qbgeXg
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	lppt	= eXgW
 * @retval	>= 0	CfbNX
 * @retval	<  0	W̓c[o[ɂȂBiΒl=ł߂CfbNXj
*//***********************************************************************/
int			ToolBar_HitTest(HWND hWnd, LPPOINT lppt)
{
#if (_WIN32_IE >= 0x0400)
	return (int)SendMessage(hWnd, TB_HITTEST, 0, (LPARAM)lppt);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * {^̏Ԃݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	nIndex	= {^CfbNX
 * @param [in]	bInd	= ݒ
 * @return	
*//***********************************************************************/
BOOL		ToolBar_InDeterminate(HWND hWnd, int nIndex, BOOL bInd)
{
	return (BOOL)SendMessage(hWnd, TB_INDETERMINATE, (WPARAM)nIndex, (LPARAM)bInd);
}
/**********************************************************************//**
 *
 * {^}
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	nIndex	= {^CfbNXĩCfbNX̍ɑ}j
 * @param [in]	bInd	= {^
 * @return	
*//***********************************************************************/
BOOL		ToolBar_InsertButton (HWND hWnd, int nIndex, LPTBBUTTON lptb)
{
	return (BOOL)SendMessage(hWnd, TB_INSERTBUTTON , (WPARAM)nIndex, (LPARAM)lptb);
}
/// iris::wx::ToolBar_InsertButton Q
BOOL		ToolBar_InsertButtonA(HWND hWnd, int nIndex, LPTBBUTTON lptb)
{
#if (_WIN32_IE >= 0x0400)
	return (BOOL)SendMessage(hWnd, TB_INSERTBUTTONA, (WPARAM)nIndex, (LPARAM)lptb);
#else
	return (BOOL)SendMessage(hWnd, TB_INSERTBUTTON , (WPARAM)nIndex, (LPARAM)lptb);
#endif
}
/// iris::wx::ToolBar_InsertButton Q
BOOL		ToolBar_InsertButtonW(HWND hWnd, int nIndex, LPTBBUTTON lptb)
{
#if (_WIN32_IE >= 0x0500)
	return (BOOL)SendMessage(hWnd, TB_INSERTBUTTONW, (WPARAM)nIndex, (LPARAM)lptb);
#else
	return (BOOL)SendMessage(hWnd, TB_INSERTBUTTON , (WPARAM)nIndex, (LPARAM)lptb);
#endif
}
/**********************************************************************//**
 *
 * c[ o[̍WʒuɊւ}}[N擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	lppt	= eXgW
 * @param [out]	lptbim	= o
 * @return	
*//***********************************************************************/
BOOL		ToolBar_InsertMarkHitTest(HWND hWnd, LPPOINT lppt, LPTBINSERTMARK lptbim)
{
#if (_WIN32_IE >= 0x0400)
	return (BOOL)SendMessage(hWnd, TB_INSERTMARKHITTEST, (WPARAM)lppt, (LPARAM)lptbim);
#else
	return FALSE;
#endif
}
/**********************************************************************//**
 *
 * {^̃`FbNԂ擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	nIndex	= {^ID
 * @return	
*//***********************************************************************/
BOOL		ToolBar_IsButtonChecked(HWND hWnd, int idButton)
{
	return (BOOL)SendMessage(hWnd, TB_ISBUTTONCHECKED, (WPARAM)idButton, 0);
}
/**********************************************************************//**
 *
 * {^̗LE擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	nIndex	= {^CfbNX
 * @return	
*//***********************************************************************/
BOOL		ToolBar_IsButtonEnable(HWND hWnd, int nIndex)
{
	return (BOOL)SendMessage(hWnd, TB_ISBUTTONENABLED, (WPARAM)nIndex, 0);
}
/**********************************************************************//**
 *
 * {^̕\Ԃ擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	nIndex	= {^CfbNX
 * @return	
*//***********************************************************************/
BOOL		ToolBar_IsButtonHidden(HWND hWnd, int nIndex)
{
	return (BOOL)SendMessage(hWnd, TB_ISBUTTONHIDDEN, (WPARAM)nIndex, 0);
}
/**********************************************************************//**
 *
 * {^̃nCCgԂ擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	nIndex	= {^CfbNX
 * @return	
*//***********************************************************************/
BOOL		ToolBar_IsButtonHighLighted(HWND hWnd, int nIndex)
{
	return (BOOL)SendMessage(hWnd, TB_ISBUTTONHIGHLIGHTED, (WPARAM)nIndex, 0);
}
/**********************************************************************//**
 *
 * {^̏Ԃ擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	nIndex	= {^CfbNX
 * @return	
*//***********************************************************************/
BOOL		ToolBar_IsButtonInDeterminate(HWND hWnd, int nIndex)
{
	return (BOOL)SendMessage(hWnd, TB_ISBUTTONINDETERMINATE, (WPARAM)nIndex, 0);
}
/**********************************************************************//**
 *
 * {^̉Ԃ擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	nIndex	= {^CfbNX
 * @return	
*//***********************************************************************/
BOOL		ToolBar_IsButtonPressed(HWND hWnd, int nIndex)
{
	return (BOOL)SendMessage(hWnd, TB_ISBUTTONPRESSED, (WPARAM)nIndex, 0);
}
/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	nBitmapID	= (IDB_STD_***) or (IDB_VIEW_**) or (IDB_HIST_***)
 * @param [in]	hInst		= HINST_COMMCTRL
 * @return	ǉꂽC[WXg̐擪CfbNX
*//***********************************************************************/
int			ToolBar_LoadImages(HWND hWnd, int nBitmapID, HINSTANCE hInst)
{
#if (_WIN32_IE >= 0x0300)
	return (int)SendMessage(hWnd, TB_LOADIMAGES, (WPARAM)nBitmapID, (LPARAM)hInst);
#else
	return -1;
#endif
}
/**********************************************************************//**
 *
 * ANZ[^{^Ɋ蓖Ă
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	Accel	= ANZ[^
 * @param [in]	lpIDBtn	= ANZ[^ɑΉ{^̃R}h ID 󂯎 UINT ւ̃|C^
 * @return	
*//***********************************************************************/
BOOL		ToolBar_MapAccelerator (HWND hWnd, TCHAR Accel, UINT* lpIDBtn)
{
#if (_WIN32_IE >= 0x0400)
	return (BOOL)SendMessage(hWnd, TB_MAPACCELERATOR , (WPARAM)Accel, (LPARAM)lpIDBtn);
#else
	return FLASE;
#endif
}
/// iris::wx::ToolBar_MapAccelerator Q
BOOL		ToolBar_MapAcceleratorA(HWND hWnd, CHAR	 Accel, UINT* lpIDBtn)
{
#if (_WIN32_IE >= 0x0400)
	return (BOOL)SendMessage(hWnd, TB_MAPACCELERATORA, (WPARAM)Accel, (LPARAM)lpIDBtn);
#else
	return FLASE;
#endif
}
/// iris::wx::ToolBar_MapAccelerator Q
BOOL		ToolBar_MapAcceleratorW(HWND hWnd, WCHAR Accel, UINT* lpIDBtn)
{
#if (_WIN32_IE >= 0x0400)
	return (BOOL)SendMessage(hWnd, TB_MAPACCELERATORW, (WPARAM)Accel, (LPARAM)lpIDBtn);
#else
	return FLASE;
#endif
}
/**********************************************************************//**
 *
 * {^̏Ԃݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	nIndex	= {^CfbNX
 * @param [in]	bMark	= ݒ
 * @return	
*//***********************************************************************/
BOOL		ToolBar_MarkButton(HWND hWnd, int nIndex, BOOL bMark)
{
#if (_WIN32_IE >= 0x0400)
	return (BOOL)SendMessage(hWnd, TB_MARKBUTTON, (WPARAM)nIndex, (LPARAM)bMark);
#else
	return FLASE;
#endif
}
/**********************************************************************//**
 *
 * {^ʂ̃CfbNXɈړ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	uOldIndex	= {^CfbNX
 * @param [in]	uNewIndex	= ړ̃{^CfbNX
 * @return	
*//***********************************************************************/
BOOL		ToolBar_MoveButton(HWND hWnd, UINT uOldIndex, UINT uNewIndex)
{
#if (_WIN32_IE >= 0x0400)
	return (BOOL)SendMessage(hWnd, TB_MOVEBUTTON, (WPARAM)uOldIndex, (LPARAM)uNewIndex);
#else
	return FLASE;
#endif
}
/**********************************************************************//**
 *
 * {^̏Ԃݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	nIndex	= {^CfbNX
 * @param [in]	bMark	= ݒ
 * @return	
*//***********************************************************************/
BOOL		ToolBar_PressButton(HWND hWnd, int nIndex, BOOL bPress)
{
	return (BOOL)SendMessage(hWnd, TB_PRESSBUTTON, (WPARAM)nIndex, (LPARAM)bPress);
}
/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	lptbrb	= 
 * @return	
*//***********************************************************************/
BOOL		ToolBar_ReplaceBitmap(HWND hWnd, LPTBREPLACEBITMAP lptbrb)
{
	return (BOOL)SendMessage(hWnd, TB_REPLACEBITMAP, 0, (LPARAM)lptbrb);
}
/**********************************************************************//**
 *
 * {^̕ۑƕ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	bSave	= ۑƂtrueAƂfalse
 * @param [io]	lptbsp	=
 * @return	
*//***********************************************************************/
LRESULT		ToolBar_SavereStore (HWND hWnd, BOOL bSave, LPTBSAVEPARAMS	lptbsp)
{
	return SendMessage(hWnd, TB_SAVERESTORE , (WPARAM)bSave, (LPARAM)lptbsp);
}
/// iris::wx::ToolBar_SavereStore Q
LRESULT	ToolBar_SavereStoreA(HWND hWnd, BOOL bSave, LPTBSAVEPARAMSA lptbsp)
{
	return SendMessage(hWnd, TB_SAVERESTOREA, (WPARAM)bSave, (LPARAM)lptbsp);
}
/// iris::wx::ToolBar_SavereStore Q
LRESULT		ToolBar_SavereStoreW(HWND hWnd, BOOL bSave, LPTBSAVEPARAMSW lptbsp)
{
	return SendMessage(hWnd, TB_SAVERESTOREW, (WPARAM)bSave, (LPARAM)lptbsp);
}
/**********************************************************************//**
 *
 * AJ[̋\ݒ擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	nHeight	= AJ[̋\ݒ
 * @return	ȑÕAJ[ݒ
*//***********************************************************************/
BOOL		ToolBar_SetAnchorHighlight(HWND hWnd, BOOL bAnchor)
{
#if (_WIN32_IE >= 0x0400)
	return (BOOL)SendMessage(hWnd, TB_SETANCHORHIGHLIGHT, (WPARAM)bAnchor, 0);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * Bitmap̑傫w
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	nWidth	= 
 * @param [in]	nHeight	= 
 * @return	
*//***********************************************************************/
BOOL		ToolBar_SetBitmapSize(HWND hWnd, int nWidth, int nHeight)
{
	return (BOOL)SendMessage(hWnd, TB_SETBITMAPSIZE, 0, MAKELPARAM(nHeight,nWidth));
}
/**********************************************************************//**
 *
 * {^̑傫w
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	nWidth	= 
 * @param [in]	nHeight	= 
 * @return	
*//***********************************************************************/
BOOL		ToolBar_SetButtonSize(HWND hWnd, int nWidth, int nHeight)
{
	return (BOOL)SendMessage(hWnd, TB_SETBUTTONSIZE, 0, MAKELPARAM(nHeight,nWidth));
}
/**********************************************************************//**
 *
 * {^̑傫w
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	nWidth	= 
 * @param [in]	nHeight	= 
 * @return	
*//***********************************************************************/
LRESULT		ToolBar_SetButtonWidth(HWND hWnd, int Min, int Max)
{
#if (_WIN32_IE >= 0x0300)
	return SendMessage(hWnd, TB_SETBUTTONWIDTH, 0, MAKELPARAM(Min,Max));
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * R}h ID ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	uCmdID	= 
 * @return	
*//***********************************************************************/
BOOL		ToolBar_SetCmdID(HWND hWnd, UINT uIndex, UINT uCmdID)
{
	return (BOOL)SendMessage(hWnd, TB_SETCMDID, (WPARAM)uIndex, (LPARAM)uCmdID);
}
/**********************************************************************//**
 *
 * Rg[̔zFݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	lpClrScheme	= zF
*//***********************************************************************/
void		ToolBar_SetColorScheme(HWND hWnd, LPCOLORSCHEME lpClrScheme)
{
	ComControl_SetColorScheme(hWnd, lpClrScheme);
}
/**********************************************************************//**
 *
 * Ԃ̃C[WXgݒ
 *
 * @note	TB_ADDBITMAPƂ̕psB
 *			TB_ADDBITMAP𑗐MCreateToolbarExƂ̕pł܂B
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	nImageID	= C[WXg̃CfbNX
 * @param [in]	hImage		= C[WXg
 * @return	ȑÕC[WXg
*//***********************************************************************/
HIMAGELIST	ToolBar_SetDisabledImageList(HWND hWnd, int nImageID, HIMAGELIST hImage)
{
#if (_WIN32_IE >= 0x0300)
	return (HIMAGELIST)SendMessage(hWnd, TB_SETDISABLEDIMAGELIST, (WPARAM)nImageID, (LPARAM)hImage);
#else
	return nullptr;
#endif
}
/**********************************************************************//**
 *
 * gX^C̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	dwMask		= eLXg̕`̃tO(DT_***)
 * @param [in]	dwDTFlags	= {^ eLXg̕`@(DT_***)
 * @return	ȑÕeLXg̕`tO
*//***********************************************************************/
DWORD	ToolBar_SetDrawTextFlags(HWND hWnd, DWORD dwMask, DWORD dwDTFlags)
{
#if (_WIN32_IE >= 0x0400)
	return (DWORD)SendMessage(hWnd, TB_SETDRAWTEXTFLAGS, (WPARAM)dwMask, (LPARAM)dwDTFlags);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * gX^C̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	dwExStyle	= gX^C
 * @return	ȑÕX^C
*//***********************************************************************/
DWORD	ToolBar_SetExtendedStyle(HWND hWnd, DWORD dwExStyle)
{
#if (_WIN32_IE >= 0x0400)
	return (DWORD)SendMessage(hWnd, TB_SETEXTENDEDSTYLE, 0, (LPARAM)dwExStyle);
#else
	return nullptr;
#endif
}
/**********************************************************************//**
 *
 * zbgԂ̃C[WXgݒ
 *
 * @note	TB_ADDBITMAPƂ̕psB
 *			TB_ADDBITMAP𑗐MCreateToolbarExƂ̕pł܂B
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	nImageID	= C[WXg̃CfbNX
 * @param [in]	hImage		= C[WXg
 * @return	ȑÕC[WXg
*//***********************************************************************/
HIMAGELIST	ToolBar_SetHotImageList(HWND hWnd, int nImageID, HIMAGELIST hImage)
{
#if (_WIN32_IE >= 0x0300)
	return (HIMAGELIST)SendMessage(hWnd, TB_SETHOTIMAGELIST, (WPARAM)nImageID, (LPARAM)hImage);
#else
	return nullptr;
#endif
}
/**********************************************************************//**
 *
 * ACezbgԂɂ
 *
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	nImageID	= C[WXg̃CfbNX
 * @return	ȑÕCfbNX
*//***********************************************************************/
int			ToolBar_SetHotItem(HWND hWnd, int nIndex)
{
#if (_WIN32_IE >= 0x0400)
	return (int)SendMessage(hWnd, TB_SETHOTITEM, (WPARAM)nIndex, 0);
#else
	return nullptr;
#endif
}
/**********************************************************************//**
 *
 * ftHgԂ̃C[WXgݒ
 *
 * @note	TB_ADDBITMAPƂ̕psB
 *			TB_ADDBITMAP𑗐MCreateToolbarExƂ̕pł܂B
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	nImageID	= C[WXg̃CfbNX
 * @param [in]	hImage		= C[WXg
 * @return	ȑÕC[WXg
*//***********************************************************************/
HIMAGELIST	ToolBar_SetImageList(HWND hWnd, int nImageID, HIMAGELIST hImage)
{
#if (_WIN32_IE >= 0x0300)
	return (HIMAGELIST)SendMessage(hWnd, TB_SETIMAGELIST, (WPARAM)nImageID, (LPARAM)hImage);
#else
	return nullptr;
#endif
}
/**********************************************************************//**
 *
 * ŏ̃{^̃Cfgݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	nIndent	= Cfg
 * @return	
*//***********************************************************************/
BOOL		ToolBar_SetIndent(HWND hWnd, int nIndent)
{
#if (_WIN32_IE >= 0x0300)
	return (BOOL)SendMessage(hWnd, TB_SETINDENT, (WPARAM)nIndent, 0);
#else
	return FALSE;
#endif
}
/**********************************************************************//**
 *
 * }}[N̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	lptbim	= ݒ
*//***********************************************************************/
void		ToolBar_SetInsertMark(HWND hWnd, LPTBINSERTMARK lptbim)
{
#if (_WIN32_IE >= 0x0400)
	SendMessage(hWnd, TB_SETINSERTMARK, 0, (LPARAM)lptbim);
#endif
}
/**********************************************************************//**
 *
 * }}[N̐Fݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	color	= F
 * @return	ȑO̐F
*//***********************************************************************/
COLORREF	ToolBar_SetInsertMarkColor(HWND hWnd, COLORREF color)
{
#if (_WIN32_IE >= 0x0400)
	return (COLORREF)SendMessage(hWnd, TB_SETINSERTMARKCOLOR, 0, (LPARAM)color);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * {^ɕ\eLXg̍ősݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	nMaxRows	= ős
 * @return	
*//***********************************************************************/
BOOL		ToolBar_SetMaxTextRows(HWND hWnd, int nMaxRows)
{
#if (_WIN32_IE >= 0x0300)
	return (BOOL)SendMessage(hWnd, TB_SETMAXTEXTROWS, (WPARAM)nMaxRows, 0);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * ѐ̖ߍ݂ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	cx		= ̖ߍ
 * @param [in]	cy		= ̖ߍ
 * @return	ȑO̒liʂɐEʂɐj
*//***********************************************************************/
DWORD		ToolBar_SetPadding(HWND hWnd, int cx, int cy)
{
#if (_WIN32_IE >= 0x0400)
	return (DWORD)SendMessage(hWnd, TB_SETPADDING, 0, MAKELPARAM(cx,cy));
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @return	
*//***********************************************************************/
LRESULT		ToolBar_SetParent(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	return SendMessage(hWnd, TB_SETPARENT, wParam, lParam);
}
/**********************************************************************//**
 *
 * ѕύX
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	nCount	= 
 * @param [in]	bFlag	= 
 * @param [in]	lprc	= ύẌ̗
 * @return	
*//***********************************************************************/
LRESULT		ToolBar_SetRows(HWND hWnd, int nCount, BOOL bFlag, LPRECT lprc)
{
	return SendMessage(hWnd, TB_SETPARENT, MAKEWPARAM(nCount,bFlag), (LPARAM)lprc);
}
/**********************************************************************//**
 *
 * X^C̕ύX
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	nIndex	= {^CfbNX
 * @param [in]	dwStyle	= 
 * @return	
*//***********************************************************************/
BOOL		ToolBar_SetState(HWND hWnd, int nIndex, DWORD dwState)
{
	return (BOOL)SendMessage(hWnd, TB_SETSTATE, (WPARAM)nIndex, (LPARAM)dwState);
}
/**********************************************************************//**
 *
 * X^C̕ύX
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	dwStyle	= X^C
 * @return	
*//***********************************************************************/
LRESULT		ToolBar_SetStyle(HWND hWnd, DWORD dwStyle)
{
#if (_WIN32_IE >= 0x0300)
	return SendMessage(hWnd, TB_SETSTYLE, 0, (LPARAM)dwStyle);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * c[`bvݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	hWndTT	= c[`bv
 * @return	
*//***********************************************************************/
LRESULT		ToolBar_SetToolTips(HWND hWnd, HWND hWndTT)
{
	return SendMessage(hWnd, TB_SETTOOLTIPS, (WPARAM)hWndTT, 0);
}
/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	bUnicode	= 
 * @return	ȑO̒l
*//***********************************************************************/
BOOL		ToolBar_SetUnicodeFormat(HWND hWnd, BOOL bUnicode)
{
	return ComControl_SetUnicodeFormat(hWnd, bUnicode);
}

/**********************************************************************//**
 *
 * hbv_Ej[̕\
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= eEBhEnh
 * @param [in]	hFrom	= c[o[EBhEnh
 * @param [in]	hMenu	= j[
 * @param [in]	lpnmTB	=
*//***********************************************************************/
void	ToolBar_DropDownMenu(HWND hWnd, HWND hFrom, HMENU hMenu, LPNMTOOLBAR lpnmTB)
{
	RECT rc;
	SendMessage(hFrom, TB_GETRECT, (WPARAM)lpnmTB->iItem, (LPARAM)&rc);
	MapWindowPoints(hFrom, HWND_DESKTOP, (LPPOINT)&rc, 2);						   

	TPMPARAMS tpm;
	tpm.cbSize = sizeof(TPMPARAMS);
	tpm.rcExclude = rc;

	TrackPopupMenuEx(hMenu,
	TPM_LEFTALIGN | TPM_LEFTBUTTON | TPM_VERTICAL,				 
	rc.left, rc.bottom, hWnd, &tpm);
}

//======================================================================
// class
// CToolBar
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CToolBar::CToolBar(void)
{
	CComCtrl::Initialize(ICC_BAR_CLASSES);
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
*//***********************************************************************/
CToolBar::CToolBar(HWND hWnd)
: CSubClass(hWnd)
{
	CComCtrl::Initialize(ICC_BAR_CLASSES);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CToolBar::~CToolBar(void)
{
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CToolBar::Create( DWORD dwStyle
					 , const RECT &rRect
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void *pParam)
{
	// EBhE̍쐬
	return CWindow::Create(TOOLBARCLASSNAME
		, nullptr
		, dwStyle|WS_CHILD
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}
/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CToolBar::Create( DWORD dwStyle
					 , int x, int y, int w, int h
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void *pParam)
{
	// EBhE̍쐬
	return CreateWindow(TOOLBARCLASSNAME
		, nullptr
		, dwStyle|WS_CHILD
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CToolBar::CreateEx( DWORD dwExStyle
					 , DWORD dwStyle
					 , const RECT &rRect
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void *pParam)
{
	// EBhE̍쐬
	return CWindow::CreateEx(dwExStyle
		, TOOLBARCLASSNAME
		, nullptr
		, dwStyle|WS_CHILD
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CToolBar::CreateEx( DWORD dwExStyle
					 , DWORD dwStyle
					 , int x, int y, int w, int h
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void *pParam)
{
	// EBhE̍쐬
	return CreateWindowEx(dwExStyle
		, TOOLBARCLASSNAME
		, nullptr
		, dwStyle|WS_CHILD
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 *
 * EBhE̍쐬(CreateToolbarEx)
 *
 ----------------------------------------------------------------------
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	nID				= j[ID
 * @param [in]	nBitmaps		= rbg}bv̐
 * @param [in]	hBMInst			= W[nh
 * @param [in]	wBMID			= \[XID܂̓rbg}bvnh
 * @param [in]	lpButtons		= TBBUTTON\
 * @param [in]	iNumButtons		= {^̐
 * @param [in]	dxButton		= {^xTCY
 * @param [in]	dyButton		= {^yTCY
 * @param [in]	dxBitmap		= rbg}bvxTCY
 * @param [in]	dyBitmap		= rbg}bvyTCY
 * @param [in]	uStructSize		= TBBUTTON\̂̃TCY
 * @return	EBhEnh
*//***********************************************************************/
HWND CToolBar::CreateEx(HWND hWndParent, DWORD dwStyle, UINT uID, int nBitmaps,
						HINSTANCE hBMInst, UINT_PTR wBMID, LPCTBBUTTON lpButtons,
						int iNumButtons, int dxButton, int dyButton,
						int dxBitmap, int dyBitmap, UINT uStructSize)
{
	if( m_hWnd != nullptr ) return m_hWnd;
	HWND hWnd = CreateToolbarEx(hWndParent
		, dwStyle
		, uID
		, nBitmaps
		, hBMInst
		, wBMID
		, lpButtons
		, iNumButtons
		, dxButton
		, dyButton
		, dxBitmap
		, dyBitmap
		, uStructSize);
	if( hWnd == nullptr ) return nullptr;
	Attach(hWnd);
	return hWnd;
}

/**********************************************************************//*
 *
 * ẽbZ[W
 *
*//***********************************************************************/
LRESULT CToolBar::RecvParentMessage(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch( uMsg )
	{
	case WM_SIZE:
		SendMessage(uMsg, wParam, lParam);
		break;
	}
	return CSubClass::RecvParentMessage(hWnd, uMsg, wParam, lParam);
}

/**********************************************************************//*
 *
 * wrap
 *
*//***********************************************************************/
int			CToolBar::AddBitmap(int nButtons, LPTBADDBITMAP ptabm)					{ return ToolBar_AddBitmap(m_hWnd, nButtons, ptabm); }
BOOL		CToolBar::AddButtons (int nButtons, LPTBBUTTON lptb)					{ return ToolBar_AddButtons (m_hWnd, nButtons, lptb); }
BOOL		CToolBar::AddButtonsA(int nButtons, LPTBBUTTON lptb)					{ return ToolBar_AddButtonsA(m_hWnd, nButtons, lptb); }
BOOL		CToolBar::AddButtonsW(int nButtons, LPTBBUTTON lptb)					{ return ToolBar_AddButtonsW(m_hWnd, nButtons, lptb); }
int			CToolBar::AddString (HINSTANCE hInst, LPCTSTR lpString)					{ return ToolBar_AddString (m_hWnd, hInst, lpString); }
int			CToolBar::AddStringA(HINSTANCE hInst, LPCSTR  lpString)					{ return ToolBar_AddStringA(m_hWnd, hInst, lpString); }
int			CToolBar::AddStringW(HINSTANCE hInst, LPCWSTR lpString)					{ return ToolBar_AddStringW(m_hWnd, hInst, lpString); }
void		CToolBar::AutoSize(void)												{ ToolBar_AutoSize(m_hWnd); }
int			CToolBar::ButtonCount(void)												{ return ToolBar_ButtonCount(m_hWnd); }
LRESULT		CToolBar::ButtonStructSize(void)										{ return ToolBar_ButtonStructSize(m_hWnd); }
BOOL		CToolBar::ChangeBitmap(int idButton, int nBitmap)						{ return ToolBar_ChangeBitmap(m_hWnd, idButton, nBitmap); }
BOOL		CToolBar::CheckButton(int nIndex, BOOL bCheck)							{ return ToolBar_CheckButton(m_hWnd, nIndex, bCheck); }
int			CToolBar::CommandToIndex(int nButtonID)									{ return ToolBar_CommandToIndex(m_hWnd, nButtonID); }
void		CToolBar::Customize(void)												{ ToolBar_Customize(m_hWnd); }
BOOL		CToolBar::DeleteButton(int nIndex)										{ return ToolBar_DeleteButton(m_hWnd, nIndex); }
BOOL		CToolBar::EnableButton(int idButton, BOOL bEnable)						{ return ToolBar_EnableButton(m_hWnd, idButton, bEnable); }
BOOL		CToolBar::GetAnchorHighlight(void)										{ return ToolBar_GetAnchorHighlight(m_hWnd); }
int			CToolBar::GetBitmap(int idButton)										{ return ToolBar_GetBitmap(m_hWnd, idButton); }
BOOL		CToolBar::GetButton(int nIndex, LPTBBUTTON lptb)						{ return ToolBar_GetButton(m_hWnd, nIndex, lptb); }
DWORD		CToolBar::GetButtonSize(void)											{ return ToolBar_GetButtonSize(m_hWnd); }
int			CToolBar::GetButtonText (int nIndex, LPTSTR lpString)					{ return ToolBar_GetButtonText (m_hWnd, nIndex, lpString); }
int			CToolBar::GetButtonTextA(int nIndex, LPSTR	lpString)					{ return ToolBar_GetButtonTextA(m_hWnd, nIndex, lpString); }
int			CToolBar::GetButtonTextW(int nIndex, LPWSTR lpString)					{ return ToolBar_GetButtonTextW(m_hWnd, nIndex, lpString); }
BOOL		CToolBar::GetColorScheme(LPCOLORSCHEME lpClrScheme)						{ return ToolBar_GetColorScheme(m_hWnd, lpClrScheme); }
HIMAGELIST	CToolBar::GetDisabledImageList(void)									{ return ToolBar_GetDisabledImageList(m_hWnd); }
DWORD		CToolBar::GetExtendedStyle(void)										{ return ToolBar_GetExtendedStyle(m_hWnd); }
HIMAGELIST	CToolBar::GetHotImageList(void)											{ return ToolBar_GetHotImageList(m_hWnd); }
int			CToolBar::GetHotItem(void)												{ return ToolBar_GetHotItem(m_hWnd); }
HIMAGELIST	CToolBar::GetImageList(void)											{ return ToolBar_GetImageList(m_hWnd); }
void		CToolBar::GetInsertMark(LPTBINSERTMARK lptbim)							{ return ToolBar_GetInsertMark(m_hWnd, lptbim); }
COLORREF	CToolBar::GetInsertMarkColor(void)										{ return ToolBar_GetInsertMarkColor(m_hWnd); }
BOOL		CToolBar::GetItemRect(int nIndex, LPRECT lprc)							{ return ToolBar_GetItemRect(m_hWnd, nIndex, lprc); }
BOOL		CToolBar::GetMaxSize(LPSIZE lpSize)										{ return ToolBar_GetMaxSize(m_hWnd, lpSize); }
LRESULT		CToolBar::GetObject(WPARAM iid, LPVOID* ppvObject)						{ return ToolBar_GetObject(m_hWnd, iid, ppvObject); }
DWORD		CToolBar::GetPadding(void)												{ return ToolBar_GetPadding(m_hWnd); }
LRESULT		CToolBar::GetRect(int nID, LPRECT lprc)									{ return ToolBar_GetRect(m_hWnd, nID, lprc); }
int			CToolBar::GetRows(void)													{ return ToolBar_GetRows(m_hWnd); }
DWORD		CToolBar::GetState(int nIndex)											{ return ToolBar_GetState(m_hWnd, nIndex); }
int			CToolBar::GetString (int nIndex, LPTSTR lpString, int cchMaxLen)		{ return ToolBar_GetString (m_hWnd, nIndex, lpString, cchMaxLen); }
int			CToolBar::GetStringA(int nIndex, LPSTR	lpString, int cchMaxLen)		{ return ToolBar_GetStringA(m_hWnd, nIndex, lpString, cchMaxLen); }
int			CToolBar::GetStringW(int nIndex, LPWSTR lpString, int cchMaxLen)		{ return ToolBar_GetStringW(m_hWnd, nIndex, lpString, cchMaxLen); }
DWORD		CToolBar::GetStyle(void)												{ return ToolBar_GetStyle(m_hWnd); }
int			CToolBar::GetTextRows(void)												{ return ToolBar_GetTextRows(m_hWnd); }
HWND		CToolBar::GetToolTips(void)												{ return ToolBar_GetToolTips(m_hWnd); }
BOOL		CToolBar::GetUnicodeFormat(void)										{ return ToolBar_GetUnicodeFormat(m_hWnd); }
BOOL		CToolBar::HideButton(int nIndex, BOOL bHide)							{ return ToolBar_HideButton(m_hWnd, nIndex, bHide); }
int			CToolBar::HitTest(LPPOINT lppt)											{ return ToolBar_HitTest(m_hWnd, lppt); }
BOOL		CToolBar::InDeterminate(int nIndex, BOOL bInd)							{ return ToolBar_InDeterminate(m_hWnd, nIndex, bInd); }
BOOL		CToolBar::InsertButton (int nIndex, LPTBBUTTON lptb)					{ return ToolBar_InsertButton (m_hWnd, nIndex, lptb); }
BOOL		CToolBar::InsertButtonA(int nIndex, LPTBBUTTON lptb)					{ return ToolBar_InsertButtonA(m_hWnd, nIndex, lptb); }
BOOL		CToolBar::InsertButtonW(int nIndex, LPTBBUTTON lptb)					{ return ToolBar_InsertButtonW(m_hWnd, nIndex, lptb); }
BOOL		CToolBar::InsertMarkHitTest(LPPOINT lppt, LPTBINSERTMARK lptbim)		{ return ToolBar_InsertMarkHitTest(m_hWnd, lppt, lptbim); }
BOOL		CToolBar::IsButtonChecked(int idButton)									{ return ToolBar_IsButtonChecked(m_hWnd, idButton); }
BOOL		CToolBar::IsButtonEnable(int nIndex)									{ return ToolBar_IsButtonEnable(m_hWnd, nIndex); }
BOOL		CToolBar::IsButtonHidden(int nIndex)									{ return ToolBar_IsButtonHidden(m_hWnd, nIndex); }
BOOL		CToolBar::IsButtonHighLighted(int nIndex)								{ return ToolBar_IsButtonHighLighted(m_hWnd, nIndex); }
BOOL		CToolBar::IsButtonInDeterminate(int nIndex)								{ return ToolBar_IsButtonInDeterminate(m_hWnd, nIndex); }
BOOL		CToolBar::IsButtonPressed(int nIndex)									{ return ToolBar_IsButtonPressed(m_hWnd, nIndex); }
int			CToolBar::LoadImages(int nBitmapID, HINSTANCE hInst)					{ return ToolBar_LoadImages(m_hWnd, nBitmapID, hInst); }
BOOL		CToolBar::MapAccelerator (TCHAR Accel, UINT* lpIDBtn)					{ return ToolBar_MapAccelerator (m_hWnd, Accel, lpIDBtn); }
BOOL		CToolBar::MapAcceleratorA(CHAR	Accel, UINT* lpIDBtn)					{ return ToolBar_MapAcceleratorA(m_hWnd, Accel, lpIDBtn); }
BOOL		CToolBar::MapAcceleratorW(WCHAR Accel, UINT* lpIDBtn)					{ return ToolBar_MapAcceleratorW(m_hWnd, Accel, lpIDBtn); }
BOOL		CToolBar::MarkButton(int nIndex, BOOL bMark)							{ return ToolBar_MarkButton(m_hWnd, nIndex, bMark); }
BOOL		CToolBar::MoveButton(UINT uOldIndex, UINT uNewIndex)					{ return ToolBar_MoveButton(m_hWnd, uOldIndex, uNewIndex); }
BOOL		CToolBar::PressButton(int nIndex, BOOL bPress)							{ return ToolBar_PressButton(m_hWnd, nIndex, bPress); }
BOOL		CToolBar::ReplaceBitmap(LPTBREPLACEBITMAP lptbrb)						{ return ToolBar_ReplaceBitmap(m_hWnd, lptbrb); }
LRESULT		CToolBar::SavereStore (BOOL bSave, LPTBSAVEPARAMS  lptbsp)				{ return ToolBar_SavereStore (m_hWnd, bSave, lptbsp); }
LRESULT		CToolBar::SavereStoreA(BOOL bSave, LPTBSAVEPARAMSA lptbsp)				{ return ToolBar_SavereStoreA(m_hWnd, bSave, lptbsp); }
LRESULT		CToolBar::SavereStoreW(BOOL bSave, LPTBSAVEPARAMSW lptbsp)				{ return ToolBar_SavereStoreW(m_hWnd, bSave, lptbsp); }
BOOL		CToolBar::SetAnchorHighlight(BOOL bAnchor)								{ return ToolBar_SetAnchorHighlight(m_hWnd, bAnchor); }
BOOL		CToolBar::SetBitmapSize(int nWidth, int nHeight)						{ return ToolBar_SetBitmapSize(m_hWnd, nWidth, nHeight); }
BOOL		CToolBar::SetButtonSize(int nWidth, int nHeight)						{ return ToolBar_SetButtonSize(m_hWnd, nWidth, nHeight); }
LRESULT		CToolBar::SetButtonWidth(int Min, int Max)								{ return ToolBar_SetButtonWidth(m_hWnd, Min, Max); }
BOOL		CToolBar::SetCmdID(UINT uIndex, UINT uCmdID)							{ return ToolBar_SetCmdID(m_hWnd, uIndex, uCmdID); }
void		CToolBar::SetColorScheme(LPCOLORSCHEME lpClrScheme)						{ return ToolBar_SetColorScheme(m_hWnd, lpClrScheme); }
HIMAGELIST	CToolBar::SetDisabledImageList(int nImageID, HIMAGELIST hImage)			{ return ToolBar_SetDisabledImageList(m_hWnd, nImageID, hImage); }
DWORD		CToolBar::SetDrawTextFlags(DWORD dwMask, DWORD dwDTFlags)				{ return ToolBar_SetDrawTextFlags(m_hWnd, dwMask, dwDTFlags); }
DWORD		CToolBar::SetExtendedStyle(DWORD dwExStyle)								{ return ToolBar_SetExtendedStyle(m_hWnd, dwExStyle); }
HIMAGELIST	CToolBar::SetHotImageList(int nImageID, HIMAGELIST hImage)				{ return ToolBar_SetHotImageList(m_hWnd, nImageID, hImage); }
int			CToolBar::SetHotItem(int nIndex)										{ return ToolBar_SetHotItem(m_hWnd, nIndex); }
HIMAGELIST	CToolBar::SetImageList(int nImageID, HIMAGELIST hImage)					{ return ToolBar_SetImageList(m_hWnd, nImageID, hImage); }
BOOL		CToolBar::SetIndent(int nIndent)										{ return ToolBar_SetIndent(m_hWnd, nIndent); }
void		CToolBar::SetInsertMark(LPTBINSERTMARK lptbim)							{ return ToolBar_SetInsertMark(m_hWnd, lptbim); }
COLORREF	CToolBar::SetInsertMarkColor(COLORREF color)							{ return ToolBar_SetInsertMarkColor(m_hWnd, color); }
BOOL		CToolBar::SetMaxTextRows(int nMaxRows)									{ return ToolBar_SetMaxTextRows(m_hWnd, nMaxRows); }
DWORD		CToolBar::SetPadding(int cx, int cy)									{ return ToolBar_SetPadding(m_hWnd, cx, cy); }
LRESULT		CToolBar::SetParent(WPARAM wParam, LPARAM lParam)						{ return ToolBar_SetParent(m_hWnd, wParam, lParam); }
LRESULT		CToolBar::SetRows(int nCount, BOOL bFlag, LPRECT lprc)					{ return ToolBar_SetRows(m_hWnd, nCount, bFlag, lprc); }
BOOL		CToolBar::SetState(int nIndex, DWORD dwState)							{ return ToolBar_SetState(m_hWnd, nIndex, dwState); }
LRESULT		CToolBar::SetStyle(DWORD dwStyle)										{ return ToolBar_SetStyle(m_hWnd, dwStyle); }
LRESULT		CToolBar::SetToolTips(HWND hWndTT)										{ return ToolBar_SetToolTips(m_hWnd, hWndTT); }
BOOL		CToolBar::SetUnicodeFormat(BOOL bUnicode)								{ return ToolBar_SetUnicodeFormat(m_hWnd, bUnicode); }

void		CToolBar::DropDownMenu(HWND hParent, HMENU hMenu, LPNMTOOLBAR lpnmTB)	{ return ToolBar_DropDownMenu(hParent, m_hWnd, hMenu, lpnmTB); }

}	// end of namespace wx
}	// end of namespace iris

