//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSubClass.cpp
 * @brief		TuNXx[XNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXSubClass_CPP_

//======================================================================
// include
#include "WXSubClass.h"

#include "../debug/WXDebug.h"
#include "../debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace wx
{

//======================================================================
// class
// CSubClass
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CSubClass::CSubClass(void)
: m_PreWndProc(nullptr)
//, m_OwnerWndProc(nullptr)
{
}
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
*//***********************************************************************/
CSubClass::CSubClass(HWND hWnd)
: m_PreWndProc(nullptr)
//, m_OwnerWndProc(nullptr)
{
	Attach(hWnd);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CSubClass::~CSubClass(void)
{
	Detach();
}

/**********************************************************************//**
 *
 * EBhEXgɕt
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @return  true:
 *          false:s
*//***********************************************************************/
bool CSubClass::Attach(HWND hWnd)
{
	// CWindow
	if( !CWindow::Attach( hWnd ) ) return false;
	// TuNX
	m_PreWndProc = (WNDPROC)(LONG_PTR)::GetWindowLongPtr(hWnd, GWL_WNDPROC);
	::SetWindowLongPtr(hWnd, GWL_WNDPROC, (__int3264)(LONG_PTR)_DefWindowProc);
	OnAttach(hWnd);
	return true;
}

/**********************************************************************//**
 *
 * EBhEXgO
 *
 ----------------------------------------------------------------------
 * @return  ֘AtĂEBhEnh
*//***********************************************************************/
HWND CSubClass::Detach(void)
{
	if( m_hWnd == nullptr ) return nullptr;
	// TuNX
	CWindow* pWindow = Find(m_hWnd);
	if( pWindow == nullptr ) return m_hWnd;
	CSubClass* p = dcast<CSubClass*>(pWindow);
	IRIS_ASSERT( p != nullptr );
	if( p->m_PreWndProc != nullptr )
	{
		::SetWindowLongPtr(m_hWnd, GWL_WNDPROC, (__int3264)(LONG_PTR)p->m_PreWndProc);
		p->m_PreWndProc = nullptr;
	}
	return CWindow::Detach();
}

/**********************************************************************//**
 *
 * EBhEvV[W
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	uMsg	= sꂽbZ[W
 * @param [in]	wParam	= sꂽbZ[W@
 * @param [in]	lParam	= sꂽbZ[WA
 * @return	LRESULTl
*//***********************************************************************/
LRESULT CSubClass::WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return PreWndProc(hWnd, uMsg, wParam, lParam);
}

/**********************************************************************//**
 *
 * ȑÕEBhEvV[WĂ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	uMsg	= sꂽbZ[W
 * @param [in]	wParam	= sꂽbZ[W@
 * @param [in]	lParam	= sꂽbZ[WA
 * @return	LRESULTl
*//***********************************************************************/
LRESULT CSubClass::PreWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	//if( m_OwnerWndProc != nullptr ) CallWindowProc(m_OwnerWndProc, hWnd, uMsg, wParam, lParam);
	return CallWindowProc(m_PreWndProc, hWnd, uMsg, wParam, lParam);
}

}	// end of namespace wx
}	// end of namespace iris
