//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXStatusBar.cpp
 * @brief		StatusBart@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXStatusBar_CPP_

//======================================================================
// include
#include "WXStatusBar.h"
#include "WXComControl.h"
#include <commctrl.h>

namespace iris {
namespace wx
{

//======================================================================
// function

/**********************************************************************//**
 *
 * SB_GETBORDERS
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [out]	pBorders	= óBRvfȏ̔zB(0:,1:,2:Zp[g)
 * @return	
*//***********************************************************************/
BOOL		StatusBar_GetBorders(HWND hWnd, int pBorders[])
{
	return (BOOL)SendMessage(hWnd, SB_GETBORDERS, 0, (LPARAM)pBorders);
}
/// iris::wx::StatusBar_GetBorders ̒l擾
int			StatusBar_GetHorizontalBorder(HWND hWnd)
{
	int borders[3];
	if( !StatusBar_GetBorders(hWnd, borders) ) return -1;
	return borders[0];
}
/// iris::wx::StatusBar_GetBorders ̒l擾
int			StatusBar_GetVerticalBorder(HWND hWnd)
{
	int borders[3];
	if( !StatusBar_GetBorders(hWnd, borders) ) return -1;
	return borders[1];
}
/// iris::wx::StatusBar_GetBorders Zp[g̒l擾
int			StatusBar_GetSeparateBorder(HWND hWnd)
{
	int borders[3];
	if( !StatusBar_GetBorders(hWnd, borders) ) return -1;
	return borders[2];
}
/**********************************************************************//**
 *
 * ACR̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nParts	= p[cԍ
 * @return	ACRnh
*//***********************************************************************/
HICON		StatusBar_GetIcon(HWND hWnd, int nParts)
{
#if (_WIN32_IE >= 0x0400)
	return (HICON)SendMessage(hWnd, SB_GETICON, (WPARAM)nParts, 0);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * p[c̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	nCount		= o͂p[c
 * @param [out]	pWidthArray	= óBep[ci[z(nullptr)
 * @return	Xe[^Xo[ɑ݂p[c
*//***********************************************************************/
int			StatusBar_GetParts(HWND hWnd, int nCount, int pWidthArray[])
{
	return (int)SendMessage(hWnd, SB_GETPARTS, (WPARAM)nCount, (LPARAM)pWidthArray);
}
/**********************************************************************//**
 *
 * p[c̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @return	Xe[^Xo[ɑ݂p[c
*//***********************************************************************/
int			StatusBar_GetPartsNum(HWND hWnd)
{
	return (int)SendMessage(hWnd, SB_GETPARTS, 0, 0);
}
/**********************************************************************//**
 *
 * p[c̗̈擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nParts	= p[cԍ
 * @param [out]	lprc	= óB̈
 * @return	
*//***********************************************************************/
BOOL		StatusBar_GetRect(HWND hWnd, int nParts, LPRECT lprc)
{
	return (BOOL)SendMessage(hWnd, SB_GETRECT, (WPARAM)nParts, (LPARAM)lprc);
}
/**********************************************************************//**
 *
 * eLXg擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nParts	= p[cԍ
 * @param [out]	pString	= o̓obt@
 * @return	:擾
 *			:\`
*//***********************************************************************/
DWORD		StatusBar_GetText (HWND hWnd, int nParts, LPTSTR pString)
{
	return (DWORD)SendMessage(hWnd, SB_GETTEXT , (WPARAM)nParts, (LPARAM)pString);
}
/// iris::wx::StatusBar_GetText Q
DWORD		StatusBar_GetTextA(HWND hWnd, int nParts, LPSTR	 pString)
{
	return (DWORD)SendMessage(hWnd, SB_GETTEXTA, (WPARAM)nParts, (LPARAM)pString);
}
/// iris::wx::StatusBar_GetText Q
DWORD		StatusBar_GetTextW(HWND hWnd, int nParts, LPWSTR pString)
{
	return (DWORD)SendMessage(hWnd, SB_GETTEXTW, (WPARAM)nParts, (LPARAM)pString);
}
/**********************************************************************//**
 *
 * eLXg擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nParts	= p[cԍ
 * @param [out]	pString	= o̓obt@
 * @return	:擾
 *			:\`
*//***********************************************************************/
int			StatusBar_GetTextLength (HWND hWnd, int nParts)
{
	return (int)SendMessage(hWnd, SB_GETTEXTLENGTH , (WPARAM)nParts, 0);
}
/// iris::wx::StatusBar_GetTextLength Q
int			StatusBar_GetTextLengthA(HWND hWnd, int nParts)
{
	return (int)SendMessage(hWnd, SB_GETTEXTLENGTHA, (WPARAM)nParts, 0);
}
/// iris::wx::StatusBar_GetTextLength Q
int			StatusBar_GetTextLengthW(HWND hWnd, int nParts)
{
	return (int)SendMessage(hWnd, SB_GETTEXTLENGTHW, (WPARAM)nParts, 0);
}
/**********************************************************************//**
 *
 * c[`bveLXg擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nParts	= p[cԍ
 * @param [out]	pString	= o̓obt@
 * @return	
*//***********************************************************************/
LRESULT		StatusBar_GetTipText (HWND hWnd, int nParts, LPTSTR pString)
{
#if (_WIN32_IE >= 0x0400)
	return SendMessage(hWnd, SB_GETTIPTEXT , (WPARAM)nParts, (LPARAM)pString);
#else
	return 0;
#endif
}
/// iris::wx::StatusBar_GetTipText Q
LRESULT		StatusBar_GetTipTextA(HWND hWnd, int nParts, LPSTR	pString)
{
#if (_WIN32_IE >= 0x0400)
	return SendMessage(hWnd, SB_GETTIPTEXTA, (WPARAM)nParts, (LPARAM)pString);
#else
	return 0;
#endif
}
/// iris::wx::StatusBar_GetTipText Q
LRESULT		StatusBar_GetTipTextW(HWND hWnd, int nParts, LPWSTR pString)
{
#if (_WIN32_IE >= 0x0400)
	return SendMessage(hWnd, SB_GETTIPTEXTW, (WPARAM)nParts, (LPARAM)pString);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * Vv[hǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @return	TRUE:Vv\, FALSE:SEPARATE\
*//***********************************************************************/
BOOL		StatusBar_IsSimple(HWND hWnd)
{
#if (_WIN32_IE >= 0x0300)
	return (BOOL)SendMessage(hWnd, SB_ISSIMPLE, 0, 0);
#else
	return (StatusBar_GetPartsNum(hWnd) == 1) ? TRUE : FALSE;
#endif
}
/**********************************************************************//**
 *
 * wiF̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	color	= F
 * @return	
*//***********************************************************************/
COLORREF	StatusBar_SetBkColor(HWND hWnd, COLORREF color)
{
	return ComControl_SetBkColor(hWnd, color);
}
/**********************************************************************//**
 *
 * ACRݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nParts	= p[cԍ
 * @param [in]	hIcon	= ACR
 * @return	
*//***********************************************************************/
BOOL		StatusBar_SetIcon(HWND hWnd, int nParts, HICON hIcon)
{
#if (_WIN32_IE >= 0x0400)
	return (BOOL)SendMessage(hWnd, SB_SETICON, (WPARAM)nParts, (LPARAM)hIcon);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * p[cݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	pixexHeight	= sNZPʍ
 * @return	
*//***********************************************************************/
void		StatusBar_SetMinHeight(HWND hWnd, int pixexHeight)
{
	SendMessage(hWnd, SB_SETMINHEIGHT, (WPARAM)pixexHeight, 0);
}
/**********************************************************************//**
 *
 * p[cݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	nCount		= p[c
 * @param [in]	pWidthArray	= ep[ci[z
 * @return	
*//***********************************************************************/
BOOL		StatusBar_SetParts(HWND hWnd, int nCount, int* pWidthArray)
{
	return (BOOL)SendMessage(hWnd, SB_SETPARTS, (WPARAM)nCount, (LPARAM)pWidthArray);
}
/**********************************************************************//**
 *
 * eLXgݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nParts	= ǉp[cԍ
 * @param [in]	pString	= ǉ镶
 * @param [in]	uType	= p[c̕\`(SBT_***)
 * @return	
*//***********************************************************************/
BOOL		StatusBar_SetText (HWND hWnd, int nParts, LPCTSTR pString, UINT uType)
{
	return (BOOL)SendMessage(hWnd, SB_SETTEXT, (WPARAM)(uType|nParts), (LPARAM)pString);
}
/// iris::wx::StatusBar_SetText Q
BOOL		StatusBar_SetTextA(HWND hWnd, int nParts, LPCSTR  pString, UINT uType)
{
	return (BOOL)SendMessage(hWnd, SB_SETTEXTA, (WPARAM)(uType|nParts), (LPARAM)pString);
}
/// iris::wx::StatusBar_SetText Q
BOOL		StatusBar_SetTextW(HWND hWnd, int nParts, LPCWSTR pString, UINT uType)
{
	return (BOOL)SendMessage(hWnd, SB_SETTEXTW, (WPARAM)(uType|nParts), (LPARAM)pString);
}
/**********************************************************************//**
 *
 * c[`bveLXgƃeLXgݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nParts	= ǉp[cԍ
 * @param [in]	pText	= ǉ镶
 * @param [in]	pTipText= c[`bv̕
 * @param [in]	uType	= p[c̕\`(SBT_***)
 * @return	
*//***********************************************************************/
BOOL		StatusBar_SetTextEx (HWND hWnd, int nParts, LPCTSTR pText, LPCTSTR pTipText, UINT uType)
{
	StatusBar_SetTipText (hWnd, nParts, pTipText);
	return StatusBar_SetText (hWnd, nParts, pText, uType);
}
/// iris::wx::StatusBar_SetTextEx Q
BOOL		StatusBar_SetTextExA(HWND hWnd, int nParts, LPCSTR	pText, LPCSTR  pTipText, UINT uType)
{
	StatusBar_SetTipTextA(hWnd,nParts, pTipText);
	return StatusBar_SetTextA(hWnd, nParts, pText, uType);
}
/// iris::wx::StatusBar_SetTextEx Q
BOOL		StatusBar_SetTextExW(HWND hWnd, int nParts, LPCWSTR pText, LPCWSTR pTipText, UINT uType)
{
	StatusBar_SetTipTextW(hWnd, nParts, pTipText);
	return StatusBar_SetTextW(hWnd, nParts, pText, uType);
}
/**********************************************************************//**
 *
 * c[`bveLXg̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nParts	= ǉp[cԍ
 * @param [in]	pString	= ǉ镶
 * @return	
*//***********************************************************************/
void		StatusBar_SetTipText (HWND hWnd, int nParts, LPCTSTR pString)
{
#if (_WIN32_IE >= 0x0400)
	SendMessage(hWnd, SB_SETTIPTEXT , (WPARAM)nParts, (LPARAM)pString);
#endif
}
/// iris::wx::StatusBar_SetTipText Q
void		StatusBar_SetTipTextA(HWND hWnd, int nParts, LPCSTR	 pString)
{
#if (_WIN32_IE >= 0x0400)
	SendMessage(hWnd, SB_SETTIPTEXTA, (WPARAM)nParts, (LPARAM)pString);
#endif
}
/// iris::wx::StatusBar_SetTipText Q
void		StatusBar_SetTipTextW(HWND hWnd, int nParts, LPCWSTR pString)
{
#if (_WIN32_IE >= 0x0400)
	SendMessage(hWnd, SB_SETTIPTEXTW, (WPARAM)nParts, (LPARAM)pString);
#endif
}
/**********************************************************************//**
 *
 * Vv[h̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	bSimple		= TRUE:Vv\, FALSE:SEPARATE\
*//***********************************************************************/
void		StatusBar_Simple(HWND hWnd, BOOL bSimple)
{
	SendMessage(hWnd, SB_SIMPLE, (WPARAM)bSimple, 0);
}

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CStatusBar::CStatusBar(void)
{
	CComCtrl::Initialize(ICC_TAB_CLASSES|ICC_BAR_CLASSES);	// status bar and tooltip
}
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
*//***********************************************************************/
CStatusBar::CStatusBar(HWND hWnd)
: CSubClass(hWnd)
{
	CComCtrl::Initialize(ICC_TAB_CLASSES|ICC_BAR_CLASSES);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CStatusBar::~CStatusBar(void)
{
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CStatusBar::Create(DWORD dwStyle
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void *pParam )
{
	// EBhE̍쐬
	return CreateWindow(STATUSCLASSNAME
		, nullptr
		, dwStyle
		, 0, 0, 0, 0
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CStatusBar::CreateEx(DWORD dwExStyle
					  , DWORD dwStyle
					  , HWND hWndParent, UINT nID
					  , HINSTANCE hInstance
					  , void *pParam )
{
	// EBhE̍쐬
	return CreateWindowEx(dwExStyle
		, STATUSCLASSNAME
		, nullptr
		, dwStyle
		, 0, 0, 0, 0
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

//**********************************************************************
//
// EBhEvV[W
//
//**********************************************************************
LRESULT CStatusBar::WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return PreWndProc(hWnd, uMsg, wParam, lParam);
}

//**********************************************************************
//
// EBhEvV[W
//
//**********************************************************************
LRESULT CStatusBar::RecvParentMessage(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch( uMsg )
	{
	case WM_SIZE:
		SendMessage(uMsg, wParam, lParam);
		break;
	}
	return CSubClass::RecvParentMessage(hWnd, uMsg, wParam, lParam);
}

//**********************************************************************
//
// bp[֐
//
//**********************************************************************
BOOL		CStatusBar::GetBorders(int pBorders[])												{ return StatusBar_GetBorders(m_hWnd, pBorders); }
int			CStatusBar::GetHorizontalBorder(void)												{ return StatusBar_GetHorizontalBorder(m_hWnd); }
int			CStatusBar::GetVerticalBorder(void)													{ return StatusBar_GetVerticalBorder(m_hWnd); }
int			CStatusBar::GetSeparateBorder(void)													{ return StatusBar_GetSeparateBorder(m_hWnd); }
HICON		CStatusBar::GetIcon(int nParts)														{ return StatusBar_GetIcon(m_hWnd, nParts); }
int			CStatusBar::GetParts(int nCount, int pWidthArray[])									{ return StatusBar_GetParts(m_hWnd, nCount, pWidthArray); }
int			CStatusBar::GetPartsNum(void)														{ return StatusBar_GetPartsNum(m_hWnd); }
BOOL		CStatusBar::GetRect(int nParts, LPRECT lprc)										{ return StatusBar_GetRect(m_hWnd, nParts, lprc); }
DWORD		CStatusBar::GetText (int nParts, LPTSTR pString)									{ return StatusBar_GetText(m_hWnd, nParts, pString); }
DWORD		CStatusBar::GetTextA(int nParts, LPSTR	pString)									{ return StatusBar_GetTextA(m_hWnd, nParts, pString); }
DWORD		CStatusBar::GetTextW(int nParts, LPWSTR pString)									{ return StatusBar_GetTextW(m_hWnd, nParts, pString); }
int			CStatusBar::GetTextLength (int nParts)												{ return StatusBar_GetTextLength(m_hWnd, nParts); }
int			CStatusBar::GetTextLengthA(int nParts)												{ return StatusBar_GetTextLengthA(m_hWnd, nParts); }
int			CStatusBar::GetTextLengthW(int nParts)												{ return StatusBar_GetTextLengthW(m_hWnd, nParts); }
LRESULT		CStatusBar::GetTipText (int nParts, LPTSTR pString)									{ return StatusBar_GetTipText(m_hWnd, nParts, pString); }
LRESULT		CStatusBar::GetTipTextA(int nParts, LPSTR  pString)									{ return StatusBar_GetTipTextA(m_hWnd, nParts, pString); }
LRESULT		CStatusBar::GetTipTextW(int nParts, LPWSTR pString)									{ return StatusBar_GetTipTextW(m_hWnd, nParts, pString); }
BOOL		CStatusBar::IsSimple(void)															{ return StatusBar_IsSimple(m_hWnd); }
COLORREF	CStatusBar::SetBkColor(DWORD color)													{ return StatusBar_SetBkColor(m_hWnd, color); }
BOOL		CStatusBar::SetIcon(int nParts, HICON hIcon)										{ return StatusBar_SetIcon(m_hWnd, nParts, hIcon); }
void		CStatusBar::SetMinHeight(int pixexHeight)											{ StatusBar_SetMinHeight(m_hWnd, pixexHeight); }
BOOL		CStatusBar::SetParts(int nCount, int* pWidthArray)									{ return StatusBar_SetParts(m_hWnd, nCount, pWidthArray); }
BOOL		CStatusBar::SetText (int nParts, LPCTSTR pString, UINT uType)						{ return StatusBar_SetText(m_hWnd, nParts, pString, uType); }
BOOL		CStatusBar::SetTextA(int nParts, LPCSTR	 pString, UINT uType)						{ return StatusBar_SetTextA(m_hWnd, nParts, pString, uType); }
BOOL		CStatusBar::SetTextW(int nParts, LPCWSTR pString, UINT uType)						{ return StatusBar_SetTextW(m_hWnd, nParts, pString, uType); }
BOOL		CStatusBar::SetTextEx (int nParts, LPCTSTR pText, LPCTSTR pTipText, UINT uType)		{ return StatusBar_SetTextEx(m_hWnd, nParts, pText, pTipText, uType); }
BOOL		CStatusBar::SetTextExA(int nParts, LPCSTR  pText, LPCSTR  pTipText, UINT uType)		{ return StatusBar_SetTextExA(m_hWnd, nParts, pText, pTipText, uType); }
BOOL		CStatusBar::SetTextExW(int nParts, LPCWSTR pText, LPCWSTR pTipText, UINT uType)		{ return StatusBar_SetTextExW(m_hWnd, nParts, pText, pTipText, uType); }
void		CStatusBar::SetTipText (int nParts, LPCTSTR pString)								{ return StatusBar_SetTipText(m_hWnd, nParts, pString); }
void		CStatusBar::SetTipTextA(int nParts, LPCSTR	pString)								{ return StatusBar_SetTipTextA(m_hWnd, nParts, pString); }
void		CStatusBar::SetTipTextW(int nParts, LPCWSTR pString)								{ return StatusBar_SetTipTextW(m_hWnd, nParts, pString); }
void		CStatusBar::Simple(BOOL bSimple)													{ StatusBar_Simple(m_hWnd, bSimple); }

}	// end of namespace wx
}	// end of namespace iris
