//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSpin.h
 * @brief		XsRg[t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXSpin_H_
#define _IRIS_WXSpin_H_

//======================================================================
// include
#include "WXSubClass.h"
#include <commctrl.h>

//======================================================================
// define

namespace iris {
namespace wx
{

//======================================================================
// declare 
class CSpin;
class CFSpin;

//======================================================================
// function
//
int			UDM_GetAccel(HWND hWnd, int nAccel, LPUDACCEL lpAccel);
// ̎擾
int			UDM_GetBase(HWND hWnd);
// BUDDY擾
HWND		UDM_GetBuddy(HWND hWnd);
// ʒu擾
int			UDM_GetPos(HWND hWnd);
// ʒu擾(32bit)
int			UDM_GetPos32(HWND hWnd, LPARAM pErr=0);
// ͈͎擾
DWORD		UDM_GetRange(HWND hWnd);
DWORD		UDM_GetRange(HWND hWnd, int& min, int& max);
// ͈͎擾(32bit)
BOOL		UDM_GetRange32(HWND hWnd, int& min, int& max);
// 
BOOL		UDM_SetAccel(HWND hWnd, int nAccel, LPUDACCEL lpAccel);
// ̐ݒ
BOOL		UDM_SetBase(HWND hWnd, int nBase);
// BUDDYݒ
HWND		UDM_SetBuddy(HWND hWnd, HWND hBuddy);
// ʒuݒ
int			UDM_SetPos(HWND hWnd, int pos);
// ʒuݒ(32bit)
int			UDM_SetPos32(HWND hWnd, int pos);
// ͈͐ݒ
void		UDM_SetRange(HWND hWnd, short min, short max);
// ͈͐ݒ(32bit)
BOOL		UDM_SetRange32(HWND hWnd, int min, int max);

//======================================================================
// class
//! XsRg[
class CSpin : public CSubClass
{
public:
	// RXgN^
	CSpin(void);
	CSpin(HWND hWnd);
	// fXgN^
	~CSpin(void);
public:
    // EBhE̍쐬
    virtual HWND Create(DWORD dwStyle
					, const RECT &rRect
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam=nullptr );
    virtual HWND Create(DWORD dwStyle
					, int x, int y, int w, int h
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void *pParam = nullptr );

	// EBhE̍쐬(CreateUpDownControl)
	virtual HWND Create(DWORD dwStyle
					 , const RECT &rRect
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInst
					 , HWND hBuddy
					 , int nUpper, int nLower, int nPos );
    virtual HWND Create(DWORD dwStyle
					 , int x, int y, int w, int h
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInst
					 , HWND hBuddy
					 , int nUpper, int nLower, int nPos );

protected:
    // EBhEvV[W
	virtual LRESULT WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam );
public:
	// wrap
	//
	int			GetAccel(int nAccel, _UDACCEL* lpAccel);
	// ̎擾
	int			GetBase(void);
	// BUDDY擾
	HWND		GetBuddy(void);
	// ʒu擾
	int			GetPos(void);
	int			GetPos32(LPARAM pErr=0);
	// ͈͎擾
	DWORD		GetRange(void);
	DWORD		GetRange(int& min, int& max);
	BOOL		GetRange32(int& min, int& max);
	// 
	BOOL		SetAccel(int nAccel, _UDACCEL* lpAccel);
	// ̐ݒ
	BOOL		SetBase(int nBase);
	// BUDDYݒ
	HWND		SetBuddy(HWND hBuddy);
	// ʒuݒ
	int			SetPos(int pos);
	int			SetPos32(int pos);
	// ͈͐ݒ
	void		SetRange(short min, short max);
	BOOL		SetRange32(int min, int max);
};

//! XsRg[
class CFSpin : public CSpin
{
private:
	// ݂̈ʒu
	float	m_fPos;
	float	m_fDelta;
	// x
	float	m_fMin, m_fMax;
	// \
	int		m_Digit;
public:
	// RXgN^
	CFSpin(void);
	CFSpin(HWND hWnd);
	// fXgN^
	~CFSpin(void);
protected:
    // EBhEvV[W
	virtual LRESULT WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam );
	// evV[W󂯂bZ[WM
	virtual	LRESULT	RecvParentMessage(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
private:
	// BODYɃeLXgݒ
	void		SetText(void);
	// BODY琔l擾
	void		GetText(void);

public:
	// set, get
	void		SetDigit(int digit)		{ m_Digit = digit; }
	int			GetDigit(void)			{ return m_Digit; }

	// 
	void		SetDelta(float delta)	{ m_fDelta = delta; }
	float		GetDelta(void)			{ return m_fDelta; }

public:
	// wrap
	// ʒuݒ
	float		SetFPos(float pos);
	// ʒu擾
	float		GetFPos(void);
	// ͈͐ݒ
	void		SetFRange(float fmin, float fmax);
	// ͈͎擾
	void		GetFRange(float& fmin, float& fmax);
};

}	// end of namespace wx
}	// end of namespace iris

#endif	// _WXSpin_H_
