//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSpin.cpp
 * @brief		XsRg[t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXSpin_CPP_

//======================================================================
// include
#include "WXSpin.h"
#include <tchar.h>
#include "WXComControl.h"
#include "../wx_support.h"

#include "../debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace wx
{

//======================================================================
// function
/**********************************************************************//**
 *
 * ANZ[V擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nAccel	= lpAccel Ŏw肷z̗vf
 * @param [in]	lpAccel	= ANZ[V󂯎 UDACCEL \̂̔zւ̃|C^
 * @return	擾ANZ[^\̂̐
*//***********************************************************************/
int			UDM_GetAccel(HWND hWnd, int nAccel, LPUDACCEL lpAccel)
{
	return (int)SendMessage( hWnd, UDM_GETACCEL, (WPARAM)nAccel, (LPARAM)lpAccel );
}
/**********************************************************************//**
 *
 * ̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	
*//***********************************************************************/
int			UDM_GetBase(HWND hWnd)
{
	return (int)SendMessage( hWnd, UDM_GETBASE, 0, 0);
}
/**********************************************************************//**
 *
 * BUDDY擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	EBhEnh
*//***********************************************************************/
HWND		UDM_GetBuddy(HWND hWnd)
{
	return (HWND)SendMessage( hWnd, UDM_GETBUDDY, 0, 0);
}
/**********************************************************************//**
 *
 * ʒu擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	ʒu
*//***********************************************************************/
int			UDM_GetPos(HWND hWnd)
{
	return (int)SendMessage( hWnd, UDM_GETPOS, 0, 0);
}
/**********************************************************************//**
 *
 * UDM_GETPOS32
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	ʒu
*//***********************************************************************/
int			UDM_GetPos32(HWND hWnd, LPARAM pErr)
{
#if (_WIN32_IE >= 0x0400)
	return (int)SendMessage( hWnd, UDM_GETPOS32, 0, pErr );
#else
	if( pErr != nullptr ) *pErr = 0;
	return (int)SendMessage( hWnd, UDM_GETPOS  , 0, 0 );
#endif
}
/**********************************************************************//**
 *
 * ͈͎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	:ŏlA:ől
*//***********************************************************************/
DWORD		UDM_GetRange(HWND hWnd)
{
	return (DWORD)SendMessage( hWnd, UDM_GETRANGE, 0, 0);
}
/**********************************************************************//**
 *
 * ͈͎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [out]	min		= óBŏl
 * @param [out]	max		= óBől
 * @return	:ŏlA:ől
*//***********************************************************************/
DWORD		UDM_GetRange(HWND hWnd, int& min, int& max)
{
	DWORD lr = UDM_GetRange(hWnd); 
	min = HIWORD(lr);
	max = LOWORD(lr);
	return lr;
}
/**********************************************************************//**
 *
 * UDM_GETRANGE32
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [out]	min		= óBŏl
 * @param [out]	max		= óBől
 * @return	
*//***********************************************************************/
BOOL		UDM_GetRange32(HWND hWnd, int& min, int& max)
{
#if (_WIN32_IE >= 0x0400)
	SendMessage( hWnd, UDM_GETRANGE32, (WPARAM)&min, (LPARAM)&max );
	return TRUE;
#else
	return FALSE;
#endif
}
/**********************************************************************//**
 *
 * ANZ[Vݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nAccel	= lpAccel Ŏw肷 UDACCEL \̗̂vf
 * @param [in]	lpAccel	= UDACCEL \̂̔zւ̃|C^
 * @return	
*//***********************************************************************/
BOOL		UDM_SetAccel(HWND hWnd, int nAccel, LPUDACCEL lpAccel)
{
	return (BOOL)SendMessage( hWnd, UDM_SETACCEL, (WPARAM)nAccel, (LPARAM)lpAccel );
}
/**********************************************************************//**
 *
 * ̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nBase	= 
 * @return	
*//***********************************************************************/
BOOL		UDM_SetBase(HWND hWnd, int nBase)
{
	return (BOOL)SendMessage( hWnd, UDM_SETBASE, (WPARAM)nBase, 0);
}
/**********************************************************************//**
 *
 * EBhEnh̊֘At
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	hBuddy	= ֘AtEBhEnh
 * @return	
*//***********************************************************************/
HWND		UDM_SetBuddy(HWND hWnd, HWND hBuddy)
{
	return (HWND)SendMessage( hWnd, UDM_SETBUDDY, (WPARAM)hBuddy, 0);
}
/**********************************************************************//**
 *
 * ʒuݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	pos		= ʒu
 * @return	
*//***********************************************************************/
int			UDM_SetPos(HWND hWnd, int pos)
{
	return (int)SendMessage( hWnd, UDM_SETPOS, 0, (LPARAM)pos);
}
/**********************************************************************//**
 *
 * ʒuݒ(32)
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	pos		= ʒu
 * @return	
*//***********************************************************************/
int			UDM_SetPos32(HWND hWnd, int pos)
{
#if (_WIN32_IE >= 0x0400)
	return (int)SendMessage( hWnd, UDM_SETPOS32, 0, (LPARAM)pos );
#else
	return (int)SendMessage( hWnd, UDM_SETPOS  , 0, (LPARAM)pos );
#endif
}
/**********************************************************************//**
 *
 * UDM_SETRANGE
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	min		= ŏl
 * @param [in]	max		= ől
 * @return	
*//***********************************************************************/
void		UDM_SetRange(HWND hWnd, short min, short max)
{
	SendMessage( hWnd, UDM_SETRANGE, 0, MAKELPARAM(min,max) );
}
/**********************************************************************//**
 *
 * UDM_SETRANGE32
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	min		= ŏl
 * @param [in]	max		= ől
 * @return	
*//***********************************************************************/
BOOL		UDM_SetRange32(HWND hWnd, int min, int max)
{
#if (_WIN32_IE >= 0x0400)
	SendMessage( hWnd, UDM_SETRANGE32, (WPARAM)min, (LPARAM)max );
	return TRUE;
#else
	return FALSE;
#endif
}

//======================================================================
// class
// CSpin
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CSpin::CSpin(void)
{
	CComCtrl::Initialize(ICC_UPDOWN_CLASS);
}
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
*//***********************************************************************/
CSpin::CSpin(HWND hWnd)
: CSubClass(hWnd)
{
	CComCtrl::Initialize(ICC_UPDOWN_CLASS);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CSpin::~CSpin(void)
{
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CSpin::Create( DWORD dwStyle
					, const RECT &rRect
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CWindow::Create(UPDOWN_CLASS
		, nullptr
		, dwStyle
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}
/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CSpin::Create( DWORD dwStyle
					 , int x, int y, int w, int h
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void* pParam )
{
	return CreateWindow(UPDOWN_CLASS
		, nullptr
		, dwStyle
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 *
 * EBhE̍쐬(CreateUpDownControl)
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CSpin::Create( DWORD dwStyle
					 , const RECT &rRect
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInst
					 , HWND hBuddy
					 , int nUpper, int nLower, int nPos )
{
	if( m_hWnd != nullptr ) return m_hWnd;
	HWND hWnd = CreateUpDownControl(dwStyle
		, rRect.left
		, rRect.top
		, rRect.right-rRect.left
		, rRect.bottom-rRect.top
		, hWndParent
		, nID
		, hInst
		, hBuddy
		, nUpper, nLower, nPos );
	if( hWnd == nullptr ) return nullptr;
	Attach(hWnd);
	return hWnd;
}
/**********************************************************************//**
 *
 * EBhE̍쐬(CreateUpDownControl)
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	x,y,w,h			= WƑ傫
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CSpin::Create( DWORD dwStyle
					 , int x, int y, int w, int h
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInst
					 , HWND hBuddy
					 , int nUpper, int nLower, int nPos )
{
	if( m_hWnd != nullptr ) return m_hWnd;
	HWND hWnd = CreateUpDownControl(dwStyle
		, x
		, y
		, w
		, h
		, hWndParent
		, nID
		, hInst
		, hBuddy
		, nUpper, nLower, nPos );
	if( hWnd == nullptr ) return nullptr;
	Attach(hWnd);
	return hWnd;
}

//**********************************************************************
//
// EBhEvV[W
//
//**********************************************************************
LRESULT CSpin::WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return PreWndProc(hWnd, uMsg, wParam, lParam);
}

//**********************************************************************
//
// bp[֐
//
//**********************************************************************
int		CSpin::GetAccel(int nAccel, LPUDACCEL lpAccel)	{ return UDM_GetAccel(m_hWnd,nAccel,lpAccel); }
int		CSpin::GetBase(void)							{ return UDM_GetBase(m_hWnd); }
HWND	CSpin::GetBuddy(void)							{ return UDM_GetBuddy(m_hWnd); }
int		CSpin::GetPos(void)								{ return UDM_GetPos(m_hWnd); }
int		CSpin::GetPos32(LPARAM pErr)					{ return UDM_GetPos32(m_hWnd,pErr); }
DWORD	CSpin::GetRange(void)							{ return UDM_GetRange(m_hWnd); }
DWORD	CSpin::GetRange(int& min, int& max)				{ return UDM_GetRange(m_hWnd,min,max); }
BOOL	CSpin::GetRange32(int& min, int& max)			{ return UDM_GetRange32(m_hWnd,min,max); }
BOOL	CSpin::SetAccel(int nAccel, LPUDACCEL lpAccel)	{ return UDM_SetAccel(m_hWnd,nAccel,lpAccel); }
BOOL	CSpin::SetBase(int nBase)						{ return UDM_SetBase(m_hWnd,nBase); }
HWND	CSpin::SetBuddy(HWND hBuddy)					{ return UDM_SetBuddy(m_hWnd,hBuddy); }
int		CSpin::SetPos(int pos)							{ return UDM_SetPos(m_hWnd,pos); }
int		CSpin::SetPos32(int pos)						{ return UDM_SetPos32(m_hWnd,pos); }
void	CSpin::SetRange(short min, short max)			{ UDM_SetRange(m_hWnd,min,max); }
BOOL	CSpin::SetRange32(int min, int max)				{ return UDM_SetRange32(m_hWnd,min,max); }

// CFSpin
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CFSpin::CFSpin(void)
: m_fPos(0.0f)
, m_fDelta(1.0f)
, m_fMin(0.0f)
, m_fMax(100.0f)
, m_Digit(-1)
{
}
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
*//***********************************************************************/
CFSpin::CFSpin(HWND hWnd)
: CSpin(hWnd)
, m_fPos(0.0f)
, m_fDelta(1.0f)
, m_fMin(0.0f)
, m_fMax(100.0f)
, m_Digit(-1)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CFSpin::~CFSpin(void)
{
}

//**********************************************************************
//
// EBhEvV[W
//
//**********************************************************************
LRESULT CFSpin::WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
	case UDM_SETACCEL:
	case UDM_GETACCEL:
		break;

#ifdef UDM_SETRANGE32
	case UDM_GETRANGE32:
		if( wParam ) *(int*)wParam = (IrisFInt)m_fMin;
		if( lParam ) *(int*)lParam = (IrisFInt)m_fMax;
		break;
#endif
	case UDM_GETRANGE:
		{
			short min = (short)m_fMin;
			short max = (short)m_fMax;
			return MAKELRESULT(max,min);
		}
		break;

#ifdef UDM_SETRANGE32
	case UDM_SETRANGE32:
		m_fMin = ((IrisFInt)(s32)wParam).fv;
		m_fMax = ((IrisFInt)(s32)lParam).fv;
		return 0;
#endif
	case UDM_SETRANGE:
		m_fMin = (float)HIWORD(lParam);
		m_fMax = (float)LOWORD(lParam);
		return 0;

#ifdef UDM_SETPOS32
	case UDM_SETPOS32:
#endif
	case UDM_SETPOS:
		m_fPos = ((IrisFInt)(s32)lParam).fv;
		SetText();
		return 0;

#ifdef UDM_GETPOS32
	case UDM_GETPOS32:
#endif
	case UDM_GETPOS:
		GetText();
		if( wParam != 0 ) 
		{
			float* pPos = (float*)wParam;
			*pPos = m_fPos;
		}
		return (LRESULT)(IrisFInt)m_fPos;

	case WM_VSCROLL:
		SetText();
		return 0;
	case WM_DESTROY:
		CWindow::Detach();
		break;
	}
	return PreWndProc(hWnd, uMsg, wParam, lParam);
}

//**********************************************************************
//
// EBhEvV[W
//
//**********************************************************************
LRESULT CFSpin::RecvParentMessage(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch( uMsg )
	{
	case WM_NOTIFY:
		{
			LPNMHDR lp = (LPNMHDR)lParam;
			switch(lp->code)
			{
			case UDN_DELTAPOS:
				{
					LPNMUPDOWN lpnmud = (LPNMUPDOWN)lp;
					GetText();
					m_fPos -= lpnmud->iDelta*m_fDelta;
					if( m_fPos < m_fMin ) m_fPos = m_fMin;
					if( m_fPos > m_fMax ) m_fPos = m_fMax;
				}
				return 0;
			}
		}
		break;
	}
	return CSubClass::RecvParentMessage(hWnd,uMsg,wParam,lParam);
}

/**********************************************************************//**
 *
 * BODYɃeLXgݒ
 *
*//***********************************************************************/
void CFSpin::SetText(void)
{
	// TODO:WCHARΉ
	CHAR str[256];
	_gcvt_s( str, 256, m_fPos, m_Digit );
	::SetWindowTextA((HWND)SendMessage(UDM_GETBUDDY,0,0),str);
}

/**********************************************************************//**
 *
 * BODY琔l擾
 *
*//***********************************************************************/
void CFSpin::GetText(void)
{
	HWND hBuddy = (HWND)SendMessage(UDM_GETBUDDY,0,0);
	if( hBuddy )
	{
		int len = (int)::GetWindowTextLength(hBuddy) + 1;
		LPSTR temp = new CHAR [len];
		::GetWindowTextA(hBuddy,temp,len);
		m_fPos = (float)atof(temp);
		delete [] temp;
	}
}

//**********************************************************************
//
// wrap
//
//**********************************************************************
float	CFSpin::SetFPos(float pos)					{ return (IrisFInt)(SetPos((IrisFInt)pos)); }
float	CFSpin::GetFPos(void)						{ return (IrisFInt)(GetPos()); }
void	CFSpin::SetFRange(float fmin, float fmax)	{ if( SetRange32((IrisFInt)fmin,(IrisFInt)fmax) == 0 ) { m_fMin = fmin; m_fMax = fmax; } }
void	CFSpin::GetFRange(float &fmin, float &fmax)	{ int min,max; if( GetRange32(min,max) ) { fmin = (IrisFInt)min; fmax = (IrisFInt)max; } else { fmin = m_fMin; fmax = m_fMax; } }

}	// end of namespace wx
}	// end of namespace iris
