//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXRichText.h
 * @brief		b`eLXgRg[t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXRichText_H_
#define _IRIS_WXRichText_H_

//======================================================================
// include
#include "WXEditBox.h"
#include <richedit.h>

namespace iris {
namespace wx
{

//======================================================================
// declare 
class CRichText10;
class CRichText20;

//======================================================================
// typedef
#if (_RICHEDIT_VER >= 0x0200)
typedef CRichText20	CRichText;	//!< b`GfBbgNX
#else
typedef CRichText10	CRichText;	//!< b`GfBbgNX
#endif

//======================================================================
// function
// Cu̓ǂݍ
BOOL		RichText_LoadLibrary(void);
// Củ
BOOL		RichText_FreeLibrary(void);

// RichEdit 1.0
// w肳ꂽNbv{[h`\t邱Ƃł邩ǂ
BOOL		RichText_CanPaste(HWND hWnd, UINT uFormat);
// FormatRange ňȑOɏꂽb` GfBbg Rg[ (eLXg OLE ACe) ̓ëꕔ\
BOOL		RichText_DisplayBand(HWND hWnd, LPRECT pDisplayRect);
// ݂̑I̋E擾
void		RichText_ExGetSel(HWND hWnd, CHARRANGE* lpcr);
// ͂łeLXg̒𐧌
void		RichText_ExLimitText(HWND hWnd, LONG lChars);
// w肳ꂽCfbNXs̍sԍ擾
LONG		RichText_ExLineFromChar(HWND hWnd, LONG lIndex);
// I̋Eݒ
void		RichText_ExSetSel(HWND hWnd, CHARRANGE* lpcr);
// eLXg
LONG		RichText_FindText(HWND hWnd, DWORD dwFlag, FINDTEXT* lpFindText);
// eLXg
LONG		RichText_FindTextEx(HWND hWnd, DWORD dwFlag, FINDTEXTEX* lpFindText);
// w肳ꂽʒu̒O܂͒̃[h؂
DWORD		RichText_FindWordBreak(HWND hWnd, UINT nCode, DWORD nStart);
// w肳ꂽfoCXpɃeLXg͈̔͂
LONG		RichText_FormatRange(HWND hWnd, FORMATRANGE* lpfr, BOOL bDisplay);
// 擾
DWORD		RichText_GetCharFormat (HWND hWnd, UINT uFlags, CHARFORMAT*  lpcf);
DWORD		RichText_GetCharFormatA(HWND hWnd, UINT uFlags, CHARFORMATA* lpcf);
DWORD		RichText_GetCharFormatW(HWND hWnd, UINT uFlags, CHARFORMATW* lpcf);
// Cxg}XN擾
LONG		RichText_GetEventMask(HWND hWnd);
// OLEC^[tFCX̎擾
LRESULT		RichText_GetOLEInterface(HWND hWnd, WPARAM wParam, LPARAM lParam);
// i擾
DWORD		RichText_GetParaFormat(HWND hWnd, UINT uFlags, PARAFORMAT* lppf);
// IvV擾
UINT		RichText_GetOptions(HWND hWnd);
// ݂̑IeLXg擾
LONG		RichText_GetSelText(HWND hWnd, LPSTR lpString);
// w肳ꂽ͈͂̃eLXg擾
LONG		RichText_GetTextRange(HWND hWnd, TEXTRANGE* lptr);
// 
LRESULT		RichText_GetWordBreakProcEx(HWND hWnd, WPARAM wParam, LPARAM lParam);
// I̕\Ɣ\̐ݒ
void		RichText_HideSelection(HWND hWnd, BOOL bHide);
// ̃Nbv{[h`Ńf[^\t
void		RichText_PasteSpecial(HWND hWnd, UINT nClipFormat, REPASTESPECIAL* lprps);
// eEBhEւ EN_REQUESTRESIZE ʒmbZ[WIɑM
void		RichText_RequestResize(HWND hWnd);
// I̎ނ擾
WORD		RichText_SelectionType(HWND hWnd);
// wiFݒ
COLORREF	RichText_SetBkGndColor(HWND hWnd, BOOL bSysColor, COLORREF color);
// ݒ
BOOL		RichText_SetCharFormat (HWND hWnd, UINT uFlags, CHARFORMAT*  lpcf);
BOOL		RichText_SetCharFormatA(HWND hWnd, UINT uFlags, CHARFORMATA* lpcf);
BOOL		RichText_SetCharFormatW(HWND hWnd, UINT uFlags, CHARFORMATW* lpcf);
// Cxg}XNݒ
DWORD		RichText_SetEventMask(HWND hWnd, DWORD dwEventMask);
// OLE ֘Ã\[XɃANZX邽߂ɎgR[obNw
LRESULT		RichText_SetOLECallback(HWND hWnd, WPARAM wParam, LPARAM lParam);
// IvVݒ
void		RichText_SetOptions(HWND hWnd, WORD wOp, DWORD dwFlags);
// iݒ
BOOL		RichText_SetParaFormat(HWND hWnd, UINT uFlags, PARAFORMAT* lppf);
// Ɏg^[Qbg foCXƍsݒ
BOOL		RichText_SetTargetDevice(HWND hWnd, HDC hDC, LONG lLineWidth);
// 
LRESULT		RichText_SetWordBreakProcEx(HWND hWnd, WPARAM wParam, LPARAM lParam);
// eLXgw肳ꂽ̓Xg[̃eLXgɒu
LONG		RichText_StreamIn(HWND hWnd, int nFormat, EDITSTREAM* lpes);
// eLXgw肳ꂽo̓Xg[ɏo
LONG		RichText_StreamOut(HWND hWnd, int nFormat, EDITSTREAM* lpes);

// RichEdit 2.0
// URL̎o̐ݒ
BOOL		RichText_AutoUrlDetect(HWND hWnd, BOOL bEnable);
// 蒼L[ɃANV܂܂Ă邩ǂ
BOOL		RichText_CanRedo(HWND hWnd);
// 
LRESULT		RichText_ConvPosition(HWND hWnd, WPARAM wParam, LPARAM lParam);
// eLXg
LONG		RichText_FindTextA(HWND hWnd, DWORD dwFlag, FINDTEXTA* lpFindText);
LONG		RichText_FindTextW(HWND hWnd, DWORD dwFlag, FINDTEXTW* lpFindText);
// eLXg
LONG		RichText_FindTextExA(HWND hWnd, DWORD dwFlag, FINDTEXTEXA* lpFindText);
LONG		RichText_FindTextExW(HWND hWnd, DWORD dwFlag, FINDTEXTEXW* lpFindText);
// URL̎oݒ̎擾
BOOL		RichText_GetAutoUrlDetect(HWND hWnd);
// IME̕ϊ̐F擾
BOOL		RichText_GetIMEColor(HWND hWnd, COMPCOLOR* lpcc);
// ݂IMẼ[h擾
UINT		RichText_GetIMECompMode(HWND hWnd);
// IMẼIvV擾
UINT		RichText_GetIMEOptions(HWND hWnd);
// IMĚIvV擾
UINT		RichText_GetLangOptions(HWND hWnd);
// ݂̋؂蕶擾
BOOL		RichText_GetPunctuation(HWND hWnd, UINT uType, PUNCTUATION* lpPunc);
// ̂蒼L[̎ނ擾
UNDONAMEID	RichText_GetRedoName(HWND hWnd);
// eLXg̎擾
LONG		RichText_GetTextEx(HWND hWnd, GETTEXTEX* lpgtex, LPTSTR lpString);
// eLXgvZ
LONG		RichText_GetTextLengthEx(HWND hWnd, DWORD dwFlags, UINT uCodePage);
// eLXg[hƃAhDx擾
UINT		RichText_GetTextMode(HWND hWnd);
// w肳ꂽ͈͂̃eLXg擾
LONG		RichText_GetTextRangeA(HWND hWnd, TEXTRANGEA* lptr);
LONG		RichText_GetTextRangeW(HWND hWnd, TEXTRANGEW* lptr);
// ̃AhDL[̎ނ擾
UNDONAMEID	RichText_GetUndoName(HWND hWnd);
// [hbv IvVƃ[h؂IvV擾
UINT		RichText_GetWordWrapMode(HWND hWnd);
// 蒼
BOOL		RichText_Redo(HWND hWnd);
// IMEϊ̐Fݒ
BOOL		RichText_SetIMEColor(HWND hWnd, COMPCOLOR* lpcc);
// IMẼIvVݒ
BOOL		RichText_SetIMEOptions(HWND hWnd, WORD wOp, UINT uOptions);
// IMĚIvVݒ
void		RichText_SetLangOptions(HWND hWnd, UINT uOptions);
// pbg̐ݒ
void		RichText_SetPalette(HWND hWnd, HPALETTE hPalette);
// ؂蕶ݒ
BOOL		RichText_SetPunctuation(HWND hWnd, UINT uType, PUNCTUATION* lpPunc);
// eLXg̐ݒ
BOOL		RichText_SetTextEx(HWND hWnd, SETTEXTEX* lpgtex, LPTSTR lpString);
// eLXg[h܂̓AhDxݒ
BOOL		RichText_SetTextMode(HWND hWnd, UINT uMode);
// AhDL[Ɋi[łőANVݒ
UINT		RichText_SetUndoLimit(HWND hWnd, UINT uLimit);
// [hbv IvVƃ[h؂IvVݒ
UINT		RichText_SetWordWrapMode(HWND hWnd, UINT uFlags);
// XN[o[̕\ݒ
void		RichText_ShowScrollBar(HWND hWnd, UINT uType, BOOL bShow);
// ݂̃AhDANVɂɓ̓ANVǉ邱Ƃ𒆎~
void		RichText_StopGroupTyping(HWND hWnd);


// LOGFONT̎擾
BOOL		RichText_GetLogFont (HWND hWnd, UINT uFlags, LOGFONT*  lplf);
BOOL		RichText_GetLogFontA(HWND hWnd, UINT uFlags, LOGFONTA* lplf);
BOOL		RichText_GetLogFontW(HWND hWnd, UINT uFlags, LOGFONTW* lplf);
// LOGFONT̐ݒ
BOOL		RichText_SetLogFont (HWND hWnd, UINT uFlags, LOGFONT*  lplf);
BOOL		RichText_SetLogFontA(HWND hWnd, UINT uFlags, LOGFONTA* lplf);
BOOL		RichText_SetLogFontW(HWND hWnd, UINT uFlags, LOGFONTW* lplf);


//======================================================================
// class
//! RichEdit 1.0Rg[NX
class CRichText10 : public CEditBox
{
public:
	// RXgN^
	CRichText10(void);
	CRichText10(HWND hWnd);
	// fXgN^
	~CRichText10(void);
public:
    // EBhE̍쐬
    virtual HWND Create(DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam=nullptr );
    virtual HWND Create(DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void *pParam = nullptr );

    // EBhE̍쐬
    virtual HWND CreateEx(DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam=nullptr );
    virtual HWND CreateEx(DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void *pParam = nullptr );

public:
	// g֐
	// Iڂ̊JnƏÏʒu̎擾
	virtual	void		GetSel(LONG& rFirst, LONG& rLast);
	virtual void		SetSel(LONG lFirst, LONG lEnd);

public:
	// wrap
	// w肳ꂽNbv{[h`\t邱Ƃł邩ǂ
	BOOL		CanPaste(UINT uFormat);
	// FormatRange ňȑOɏꂽb` GfBbg Rg[ (eLXg OLE ACe) ̓ëꕔ\
	BOOL		DisplayBand(LPRECT pDisplayRect);
	// ݂̑I̋E擾
	void		ExGetSel(CHARRANGE* lpcr);
	// ͂łeLXg̒𐧌
	void		ExLimitText(LONG lChars);
	// w肳ꂽCfbNXs̍sԍ擾
	LONG		ExLineFromChar(LONG lIndex);
	// I̋Eݒ
	void		ExSetSel(CHARRANGE* lpcr);
	// eLXg
	LONG		FindText(DWORD dwFlag, FINDTEXT* lpFindText);
	// eLXg
	LONG		FindTextEx(DWORD dwFlag, FINDTEXTEX* lpFindText);
	// w肳ꂽʒu̒O܂͒̃[h؂
	DWORD		FindWordBreak(UINT nCode, DWORD nStart);
	// w肳ꂽfoCXpɃeLXg͈̔͂
	LONG		FormatRange(FORMATRANGE* lpfr, BOOL bDisplay);
	// 擾
	DWORD		GetCharFormat(UINT uFlags, CHARFORMAT* lpcf);
	// Cxg}XN擾
	LONG		GetEventMask(void);
	// OLEC^[tFCX̎擾
	LRESULT		GetOLEInterface(WPARAM wParam, LPARAM lParam);
	// i擾
	DWORD		GetParaFormat(UINT uFlags, PARAFORMAT* lppf);
	// IvV擾
	UINT		GetOptions(void);
	// ݂̑IeLXg擾
	LONG		GetSelText(LPSTR lpString);
	// w肳ꂽ͈͂̃eLXg擾
	LONG		GetTextRange(TEXTRANGE* lptr);
	// 
	LRESULT		GetWordBreakProcEx(WPARAM wParam, LPARAM lParam);
	// I̕\Ɣ\̐ݒ
	void		HideSelection(BOOL bHide);
	// ̃Nbv{[h`Ńf[^\t
	void		PasteSpecial(UINT nClipFormat, REPASTESPECIAL* lprps);
	// eEBhEւ EN_REQUESTRESIZE ʒmbZ[WIɑM
	void		RequestResize(void);
	// I̎ނ擾
	WORD		SelectionType(void);
	// wiFݒ
	COLORREF	SetBkGndColor(BOOL bSysColor, COLORREF color);
	// ݒ
	BOOL		SetCharFormat(UINT uFlags, CHARFORMAT* lpcf);
	// Cxg}XNݒ
	DWORD		SetEventMask(DWORD dwEventMask);
	// OLE ֘Ã\[XɃANZX邽߂ɎgR[obNw
	LRESULT		SetOLECallback(WPARAM wParam, LPARAM lParam);
	// IvVݒ
	void		SetOptions(WORD wOp, DWORD dwFlags);
	// iݒ
	BOOL		SetParaFormat(UINT uFlags, PARAFORMAT* lppf);
	// Ɏg^[Qbg foCXƍsݒ
	BOOL		SetTargetDevice(HDC hDC, LONG lLineWidth);
	// 
	LRESULT		SetWordBreakProcEx(WPARAM wParam, LPARAM lParam);
	// eLXgw肳ꂽ̓Xg[̃eLXgɒu
	LONG		StreamIn(int nFormat, EDITSTREAM* lpes);
	// eLXgw肳ꂽo̓Xg[ɏo
	LONG		StreamOut(int nFormat, EDITSTREAM* lpes);

public:
	// CEditBox㏑
	// ݒ\ȃeLXg̍őoCgݒ
	virtual	void		LimitText(int cchMax);
	// w肳ꂽCfbNXs̍sԍ擾
	virtual	int			LineFromChar(int ich);
};


//! RichEdit 2.0Rg[NX
class CRichText20 : public CRichText10
{
public:
	// RXgN^
	CRichText20(void);
	CRichText20(HWND hWnd);
	// fXgN^
	~CRichText20(void);

public:
	// wrap
	// 蒼L[ɃANV܂܂Ă邩ǂ
	BOOL		CanRedo(void);
	// 
	LRESULT		ConvPosition(WPARAM wParam, LPARAM lParam);
	// eLXg
	LONG		FindTextA(DWORD dwFlag, FINDTEXTA* lpFindText);
	LONG		FindTextW(DWORD dwFlag, FINDTEXTW* lpFindText);
	// eLXg
	LONG		FindTextExA(DWORD dwFlag, FINDTEXTEXA* lpFindText);
	LONG		FindTextExW(DWORD dwFlag, FINDTEXTEXW* lpFindText);
	// URL̎oݒ̎擾
	BOOL		GetAutoUrlDetect(void);
	// IME̕ϊ̐F擾
	BOOL		GetIMEColor(COMPCOLOR* lpcc);
	// ݂IMẼ[h擾
	UINT		GetIMECompMode(void);
	// IMẼIvV擾
	UINT		GetIMEOptions(void);
	// IMĚIvV擾
	UINT		GetLangOptions(void);
	// ݂̋؂蕶擾
	BOOL		GetPunctuation(UINT uType, PUNCTUATION* lpPunc);
	// ̂蒼L[̎ނ擾
	UNDONAMEID	GetRedoName(void);
	// eLXg̎擾
	LONG		GetTextEx(GETTEXTEX* lpgtex, LPTSTR lpString);
	// eLXgvZ
	LONG		GetTextLengthEx(DWORD dwFlags, UINT uCodePage);
	// eLXg[hƃAhDx擾
	UINT		GetTextMode(void);
	// w肳ꂽ͈͂̃eLXg擾
	LONG		GetTextRangeA(TEXTRANGEA* lptr);
	LONG		GetTextRangeW(TEXTRANGEW* lptr);
	// ̃AhDL[̎ނ擾
	UNDONAMEID	GetUndoName(void);
	// [hbv IvVƃ[h؂IvV擾
	UINT		GetWordWrapMode(void);
	// 蒼
	BOOL		Redo(void);
	// URL̎o̐ݒ
	BOOL		SetAutoUrlDetect(BOOL bEnable);
	// IMEϊ̐Fݒ
	BOOL		SetIMEColor(COMPCOLOR* lpcc);
	// IMẼIvVݒ
	BOOL		SetIMEOptions(WORD wOp, UINT uOptions);
	// IMĚIvVݒ
	void		SetLangOptions(UINT uOptions);
	// pbg̐ݒ
	void		SetPalette(HPALETTE hPalette);
	// ؂蕶ݒ
	BOOL		SetPunctuation(UINT uType, PUNCTUATION* lpPunc);
	// eLXg̐ݒ
	BOOL		SetTextEx(SETTEXTEX* lpgtex, LPTSTR lpString);
	// eLXg[h܂̓AhDxݒ
	BOOL		SetTextMode(UINT uMode);
	// AhDL[Ɋi[łőANVݒ
	UINT		SetUndoLimit(UINT uLimit);
	// [hbv IvVƃ[h؂IvVݒ
	UINT		SetWordWrapMode(UINT uFlags);
	// XN[o[̕\ݒ
	void		ShowScrollBar(UINT uType, BOOL bShow);
	// ݂̃AhDANVɂɓ̓ANVǉ邱Ƃ𒆎~
	void		StopGroupTyping(void);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
