//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMenuBar.h
 * @brief		MenuBart@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXMenuBar_H_
#define _IRIS_WXMenuBar_H_

//======================================================================
// icnlude
#include "iris_object.h"

namespace iris {
namespace wx
{

//======================================================================
// declare 
class CMenu;

//======================================================================
// function

// 擾
// hMenuȉׂ̂Ă
UINT	GetMenuStringFromID		(HMENU hMenu, UINT uID , LPTSTR lpString, UINT uSize);
UINT	GetMenuStringFromIDA	(HMENU hMenu, UINT uID , LPSTR  lpString, UINT uSize);
UINT	GetMenuStringFromIDW	(HMENU hMenu, UINT uID , LPWSTR lpString, UINT uSize);
UINT	GetMenuStringFromPos	(HMENU hMenu, UINT uPos, LPTSTR lpString, UINT uSize);
UINT	GetMenuStringFromPosA	(HMENU hMenu, UINT uPos, LPSTR  lpString, UINT uSize);
UINT	GetMenuStringFromPosW	(HMENU hMenu, UINT uPos, LPWSTR lpString, UINT uSize);

// 
HMENU	FindRootMenu(HMENU hMenu, UINT uID);
HMENU	FindMenu(HMENU hMenu, UINT uID);
HMENU	FindMenuItemInfo (HMENU hMenu, UINT uItem, BOOL fByPos, LPMENUITEMINFO  lpmii);
HMENU	FindMenuItemInfoA(HMENU hMenu, UINT uItem, BOOL fByPos, LPMENUITEMINFOA lpmii);
HMENU	FindMenuItemInfoW(HMENU hMenu, UINT uItem, BOOL fByPos, LPMENUITEMINFOW lpmii);

// j[ʒu̎擾
int		GetMenuItemPos(HMENU hMenu, UINT uID);

// |bvAbvj[̕\i}EXJ[\t߂ɏoj
BOOL	ShowPopupMenu(HWND hWnd, HMENU hMenu, LPRECT prc);

//======================================================================
// class
//! j[NX
class CMenu : public IIrisObject
{
protected:
	HMENU	m_hMenu;	//!< j[nh

public:
	// RXgN^
	CMenu(void);
	CMenu(HMENU hMenu);
	CMenu(HWND hWnd);
	// fXgN^
	~CMenu(void);
public:
    // j[nh̎擾
	HMENU	GetMenu(void)		{ return m_hMenu; }
	HMENU	operator()(void)	{ return m_hMenu; }
	operator HMENU (void)		{ return m_hMenu; }

public:
    // j[֘At
    bool	Attach(HMENU hMenu);
    // j[̊֘At𕪗
    HMENU	Detach(void);

public:
    // j[쐬
    BOOL	CreateMenu(void);
    // |bvAbvj[쐬
    BOOL	CreatePopupMenu(void);
	// j[̃[h
	BOOL	LoadMenuA(HINSTANCE hInstance, LPCSTR  lpMenuName);
	BOOL	LoadMenuW(HINSTANCE hInstance, LPCWSTR lpMenuName);
	// j[̔j
    BOOL	DestroyMenu(void);

public:
	// j[ǉ
	BOOL	InsertMenuItemA(UINT uItem, BOOL fByPos, LPCMENUITEMINFOA lpmii);
	BOOL	InsertMenuItemW(UINT uItem, BOOL fByPos, LPCMENUITEMINFOW lpmii);
	// j[폜
	BOOL	DeleteMenu(UINT uItem, UINT uFlags);
	// j[폜iȂj
	HMENU	RemoveMenu(UINT uItem, UINT uFlags);

public:
	// j[I
	BOOL	SelectMenuItem(HWND hWnd, int nPos);
	// j[
	BOOL	PushMenuItem(HWND hWnd, int nPos);

public:
	// j[Ƀ`FbN
	BOOL	CheckMenuItem(UINT uItem, UINT uCheck);
	// j[ɃWI{^`FbN
	BOOL	CheckMenuRadioItem(UINT uFirst, UINT uLast, UINT uCheck, UINT uFlags);
	BOOL	CheckMenuRadioItem(UINT uCheck, UINT uFlags);
	// j[ڂLAA܂͒WF\ɂ
	BOOL	EnableMenuItem(UINT uID, UINT uEnable);
	// j[擾
	BOOL	GetMenuInfo(LPMENUINFO lpmi);
	// j[ڐ̎擾
	int		GetMenuItemCount(void);
	// j[ID̎擾
	UINT	GetMenuItemID(int nPos);
	// j[ACe\̂fMasko擾
	DWORD	GetMenuItemInfoMask(UINT uItem, BOOL fByPosition);
	// j[ACe\̂fTypeo擾
	DWORD	GetMenuItemInfoType(UINT uItem, BOOL fByPosition);
	// j[ACe\̂fStateo擾
	DWORD	GetMenuItemInfoState(UINT uItem, BOOL fByPosition);
	// j[ACȅ擾
	BOOL	GetMenuItemInfoA(UINT uItem, BOOL fByPosition, LPMENUITEMINFOA lpmii);
	BOOL	GetMenuItemInfoW(UINT uItem, BOOL fByPosition, LPMENUITEMINFOW lpmii);
	// j[ACë̗擾
	BOOL	GetMenuItemRect(HWND hWnd, UINT uItem, LPRECT lprc);
	// Tuj[̎擾
	HMENU	GetSubMenu(int nPos);
	// nCCgݒ
	BOOL	HiliteMenuItem(HWND hWnd, UINT uID, UINT uHilite);
	// j[nhǂ
	BOOL	IsMenu(void);
	// |bvAbvj[ǂ
	BOOL	IsPopupMenu(void);
	// ʒu烁j[nh擾
	int		MenuItemFromPoint(HWND hWnd, POINT ptScreen);
	// j[ݒ
	BOOL	SetMenuInfo(LPCMENUINFO lpmi);
	// rbg}bvj[Ɋ֘At
	BOOL	SetMenuItemBitmaps(UINT uItem, UINT uFlags, HBITMAP hBitmapUnchecked, HBITMAP hBitmapChecked);
	// j[ACeݒ
	BOOL	SetMenuItemInfoA(UINT uItem, BOOL fByPosition, LPMENUITEMINFOA lpmii);
	BOOL	SetMenuItemInfoW(UINT uItem, BOOL fByPosition, LPMENUITEMINFOW lpmii);
	// V[gJbgj[̕\
	BOOL	TrackPopupMenu(UINT uFlags, int x, int y, HWND hWnd);
	BOOL	TrackPopupMenuEx(UINT uFlags, int x, int y, HWND hWnd, LPTPMPARAMS lptpm);

public:
	// hMenuȉׂ̂Ă
	UINT	GetMenuStringFromID	(UINT uID, LPTSTR lpString, UINT uSize);
	UINT	GetMenuStringFromIDA(UINT uID, LPSTR  lpString, UINT uSize);
	UINT	GetMenuStringFromIDW(UINT uID, LPWSTR lpString, UINT uSize);
	UINT	GetMenuStringFromPos (UINT uPos, LPTSTR lpString, UINT uSize);
	UINT	GetMenuStringFromPosA(UINT uPos, LPSTR  lpString, UINT uSize);
	UINT	GetMenuStringFromPosW(UINT uPos, LPWSTR lpString, UINT uSize);

	// j[ACeIDAj[nh
	HMENU	FindRootMenu(UINT uID);
	HMENU	FindMenu(UINT uID);
	// j[ACě
	HMENU	FindMenuItemInfo (UINT uItem, BOOL fByPos, LPMENUITEMINFO  lpmii);
	HMENU	FindMenuItemInfoA(UINT uItem, BOOL fByPos, LPMENUITEMINFOA lpmii);
	HMENU	FindMenuItemInfoW(UINT uItem, BOOL fByPos, LPMENUITEMINFOW lpmii);

	// j[ʒu̎擾
	int		GetMenuItemPos(UINT uID);
	
	// |bvAbvj[̕\i}EXJ[\t߂ɏoj
	BOOL	ShowPopupMenu(HWND hWnd, RECT* prc);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
