//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXListView.h
 * @brief		ListViewt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXListView_H_
#define _IRIS_WXListView_H_

//======================================================================
// include
#include "WXSubClass.h"
#include <commctrl.h>

//======================================================================
// define

namespace iris {
namespace wx
{

//======================================================================
// declare 
class CListView;

//======================================================================
// function
// commctrl.hɒ`Ă̂̓Rg
// 
//DWORD		ListView_ApproximateViewRect(HWND hWnd, int nWidth, int nHeight, int nCount);
//
//BOOL		ListView_SetUnicodeFormat(HWND hWnd, BOOL fUnicode);

//======================================================================
// class
//! Xg{bNXNX
class CListView : public CSubClass
{
public:
	// RXgN^
	CListView(void);
	CListView(HWND hWnd);
	// fXgN^
	~CListView(void);
public:
    // EBhE̍쐬
    virtual HWND Create(DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam=nullptr );
    virtual HWND Create(DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void *pParam = nullptr );

    // EBhE̍쐬
    virtual HWND CreateEx(DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam=nullptr );
    virtual HWND CreateEx(DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void *pParam = nullptr );
protected:
    // EBhEvV[W
	virtual LRESULT WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam );

public:
	// wrap
	// 
	BOOL		ApproximateViewRect(int nWidth, int nHeight, int nCount);
	// 
	BOOL		Arrange(UINT code);
	// 
	HIMAGELIST	CreateDragImage(int nIndex, LPPOINT lppt);
	// SACe̍폜
	BOOL		DeleteAllItems(void);
	// J̍폜
	BOOL		DeleteColumn(int nIndex);
	// ACe̍폜
	BOOL		DeleteItem(int nIndex);
	// 
	HWND		EditLabel(int nIndex);
	// 
	BOOL		EnsureVisible(int nIndex, int fPartialOK);
	// ACě
	int			FindItem(int nStart, const LV_FINDINFO* lplvfi);
	// wiF̎擾
	COLORREF	GetBkColor(void);
	// wiC[W̎擾
	BOOL		GetBkImage(LVBKIMAGE* lpbki);
	// 
	BOOL		GetCallbackMask(void);
	// 
	BOOL		GetCheckState(int nIndex);
	// J̎擾
	BOOL		GetColumn(int nIndex, LV_COLUMN* lpclmn);
	// J̏擾
	BOOL		GetColumnOrderArray(int nCount, LPINT lpOrder);
	// J̕擾
	int			GetColumnWidth(int nIndex);
	// 
	int			GetCountPerPage(void);
	// GfBbgRg[̎擾
	HWND		GetEditControl(void);
	// gX^C̎擾
	DWORD		GetExtendedListViewStyle(void);
	// wb_̎擾
	HWND		GetHeader(void);
	// zbgACẽJ[\擾
	HCURSOR		GetHotCursor(void);
	// zbgACe̎擾
	int			GetHotItem(void);
	// 
	DWORD		GetHoverTime(void);
	// C[WXg̎擾
	HIMAGELIST	GetImageList(int nImage);
	// 
	BOOL		GetISearchString(LPTSTR lpString);
	// ACe̎擾
	BOOL		GetItem(LV_ITEM* lplvi);
	// ACe̎擾
	int			GetItemCount(void);
	// ACëʒu擾
	BOOL		GetItemPosition(int nIndex, LPPOINT lppt);
	// ACe̕`̈̎擾
	BOOL		GetItemRect(int nIndex, LPRECT lprc, LONG code);
	// 
	DWORD		GetItemSpacing(BOOL bSmall);
	// 
	UINT		GetItemState(int nIndex, UINT mask);
	// ACẽeLXg擾
	void		GetItemText(int nIndex, int nSubItem, LPTSTR lpText, int cchTextMax);
	// ̃ACe擾
	int			GetNextItem(int nIndex, int nFlags);
	// 
	BOOL		GetNumberOfWorkAreas(UINT* pnWorkAreas);
	// 
	BOOL		GetOrigin(LPPOINT lppt);
	// IACe̎擾
	UINT		GetSelectedCount(void);
	// 
	int			GetSelectionMark(void);
	// 
	int			GetStringWidth(LPCTSTR lpString);
	// TuACe̕`̈擾
	BOOL		GetSubItemRect(int nIndex, int nSubItem, LONG code, LPRECT lprc);
	// eLXg̔wiJ[擾
	COLORREF	GetTextBkColor(void);
	// eLXgJ[̎擾
	COLORREF	GetTextColor(void);
	// 
	HWND		GetToolTips(void);
	// 擪̃CfbNX擾
	int			GetTopIndex(void);
	//
	BOOL		GetUnicodeFormat(void);
	// 
	BOOL		GetViewRect(LPRECT lprc);
	// 
	BOOL		GetWorkAreas(int nWorkAreas, LPRECT lprc);
	// qbgeXg
	int			HitTest(LV_HITTESTINFO* lphti);
	// J̑}
	BOOL		InsertColumn(int nIndex, const LV_COLUMN* lpclmn);
	// ACȇ}
	BOOL		InsertItem(const LV_ITEM* lplvi);
	// 
	BOOL		RedrawItems(int nFirst, int nLast);
	// XN[
	BOOL		Scroll(int dx, int dy);
	// wiF̐ݒ
	COLORREF	SetBkColor(COLORREF color);
	// wiC[W̐ݒ
	BOOL		SetBkImage(LVBKIMAGE* lpbki);
	// 
	BOOL		SetCallbackMask(BOOL mask);
	// 
	void		SetCheckState(int nIndex, BOOL bCheck);
	// J̐ݒ
	BOOL		SetColumn(int nIndex, const LV_COLUMN* lpclmn);
	// J̏Ԃݒ
	BOOL		SetColumnOrderArray(int nCount, LPINT lpOrder);
	// J̕ݒ
	BOOL		SetColumnWidth(int nIndex, int cx);
	// gX^C̐ݒ
	DWORD		SetExtendedListViewStyle(DWORD dwExStyle);
	// gX^C̐ݒ
	DWORD		SetExtendedListViewStyleEx(DWORD dwMask, DWORD dwExStyle);
	// zbgACẽJ[\ݒ
	HCURSOR		SetHotCursor(HCURSOR hCursor);
	// zbgACe̐ݒ
	int			SetHotItem(int nIndex);
	// 
	DWORD		SetHoverTime(DWORD dwHoverTimeMs);
	// 
	DWORD		SetIconSpacing(int cx, int cy);
	// C[WXg̐ݒ
	HIMAGELIST	SetImageList(HIMAGELIST hImage, int nImage);
	// ACe̐ݒ
	BOOL		SetItem(const LV_ITEM* lplvi);
	// ACe̐ݒ
	void		SetItemCount(int nCount);
	// ACe̐ݒ
	void		SetItemCountEx(int nCount, DWORD dwFlags);
	// ACeʒu̐ݒ
	BOOL		SetItemPosition(int nIndex, int nX, int nY);
	// ACëʒu̐ݒ(32bit)
	void		SetItemPosition32(int nIndex, int nX, int nY);
	// 
	void		SetItemState(int nIndex, UINT data, UINT mask);
	// ACẽeLXgݒ
	void		SetItemText(int nIndex, int nSubItem, LPTSTR lpText);
	// 
	int			SetSelectionMark(int nIndex);
	// eLXg̔wiJ[̐ݒ
	BOOL		SetTextBkColor(COLORREF color);
	// eLXgJ[̐ݒ
	BOOL		SetTextColor(COLORREF color);
	// 
	HWND		SetToolTips(HWND hWndTT);
	// 
	BOOL		SetUnicodeFormat(BOOL bUnicode);
	// 
	BOOL		SetWorkAreas(int nWorkAreas, LPRECT lprc);
	// ACẽ\[g
	BOOL		SortItems(PFNLVCOMPARE* lpfnCompare, LPARAM lParam);
	// ACẽ\[g
	BOOL		SortItemsEx(PFNLVCOMPARE* lpfnCompare, LPARAM lParam);
	// TuACẽqbgeXg
	int			SubItemHitTest(LPLVHITTESTINFO* lphti);
	// XV
	BOOL		Update(int nIndex);
};

}	// end of namespace wx
}	// end of namespace iris

#endif

