//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXEditBox.cpp
 * @brief		GfBbg{bNXRg[t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXEditBox_CPP_

//======================================================================
// include
#include "WXEditBox.h"
#include <windowsx.h>
#include <commctrl.h>

namespace iris {
namespace wx
{

//======================================================================
// function
/**********************************************************************//**
 *
 * NCAgWÄʒuɍł߂CfbNX擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	cx		= NCAgxW
 * @param [in]	cy		= NCAgyW
 * @retval	-1		= s
 * @retval		= CfbNX
 * @retval		= sCfbNX
*//***********************************************************************/
DWORD	Edit_CharFormPos(HWND hWnd, int cx, int cy)
{
#if(WINVER >= 0x0400)
	return (DWORD)SendMessage(hWnd, EM_CHARFROMPOS, 0, MAKELPARAM(cx,cy));
#else
	return -1;
#endif
}
/**********************************************************************//**
 *
 * NCAgWÄʒuɍł߂CfbNX擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	cx			= NCAgxW
 * @param [in]	cy			= NCAgyW
 * @param [out]	rCharIndex	= óBCfbNX
 * @param [out]	rLineIndex	= óBsCfbNX
 * @return	
*//***********************************************************************/
BOOL	Edit_CharFormPos(HWND hWnd, int cx, int cy, int& rCharIndex, int& rLineIndex)
{
	DWORD ret = Edit_CharFormPos(hWnd, cx, cy);
	if( ret == (DWORD)-1 ) return FALSE;
	rCharIndex = LOWORD(ret);
	rLineIndex = HIWORD(ret);
	return TRUE;
}
/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	wParam	= 
 * @return	
*//***********************************************************************/
LRESULT	Edit_GetIMEStatus(HWND hWnd, WPARAM wParam)
{
#if(WINVER >= 0x0500)
	return SendMessage(hWnd, EM_GETIMESTATUS, wParam, 0);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * ݒ\ȃeLXg̍őoCg擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @return	őoCg
*//***********************************************************************/
int		Edit_GetLimitText(HWND hWnd)
{
#if(WINVER >= 0x0400)
	return (int)SendMessage(hWnd, EM_GETLIMITTEXT, 0, 0);
#else
	return 32766;
#endif
}
/**********************************************************************//**
 *
 * Ẽ}[W擾(seLXg{bNX)
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @retval		= ̃}[W
 * @retval		= Ẽ}[W
*//***********************************************************************/
DWORD	Edit_GetMargins(HWND hWnd)
{
#if(WINVER >= 0x0400)
	return (DWORD)SendMessage(hWnd, EM_GETMARGINS, 0, 0);
#else
	return -1;
#endif
}
/**********************************************************************//**
 *
 * Ẽ}[W擾(seLXg{bNX)
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [out]	rLeft	= óB̃}[W
 * @param [out]	rRight	= óBẼ}[W
 * @return	
*//***********************************************************************/
BOOL	Edit_GetMargins(HWND hWnd, int& rLeft, int& rRight)
{
	DWORD ret = Edit_GetMargins(hWnd);
	if( ret == (DWORD)-1 ) return FALSE;
	rLeft = LOWORD(ret);
	rRight= HIWORD(ret);
	return TRUE;
}
/**********************************************************************//**
 *
 * XN[o[̈ʒu擾(sGfBbg Rg[)
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @return	XN[o[ʒu
*//***********************************************************************/
int		Edit_GetThumb(HWND hWnd)
{
	return (int)SendMessage(hWnd, EM_GETTHUMB, 0, 0);
}
/**********************************************************************//**
 *
 * Cӂ̕ɃXN[
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	nVScroll	= ̃XN[l
 * @param [in]	nHScroll	= ̃XN[l
*//***********************************************************************/
void	Edit_LineScroll(HWND hWnd, int nVScroll, int nHScroll)
{
	Edit_Scroll(hWnd, nVScroll, nHScroll);
}
/**********************************************************************//**
 *
 * CfbNX̍Wl擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	nCharIndex	= CfbNX
 * @retval		= XW
 * @retval		= YW
*//***********************************************************************/
DWORD	Edit_PosFromChar(HWND hWnd, int nCharIndex)
{
#if(WINVER >= 0x0400)
	return (DWORD)SendMessage(hWnd, EM_POSFROMCHAR, (WPARAM)nCharIndex, 0);
#else
	return -1;
#endif
}
/**********************************************************************//**
 *
 * CfbNX̍Wl擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	nCharIndex	= CfbNX
 * @param [out]	rX			= óBXW
 * @param [out]	rY			= óBYW
 * @return	
*//***********************************************************************/
BOOL	Edit_PosFromChar(HWND hWnd, int nCharIndex, int& rX, int& rY)
{
	DWORD ret = Edit_PosFromChar(hWnd, nCharIndex);
	if( ret == (DWORD)-1 ) return FALSE;
	rX = LOWORD(ret);
	rY = HIWORD(ret);
	return TRUE;
}
/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	wParam	= 
 * @param [in]	lParam	= 
*//***********************************************************************/
LRESULT		Edit_SetIMEStatus(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
#if(WINVER >= 0x0500)
	return SendMessage(hWnd, EM_SETIMESTATUS, wParam, lParam);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * ݒ\ȃeLXg̍őoCgݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۃnh
 * @param [in]	cchMax	= őoCg
*//***********************************************************************/
void	Edit_SetLimitText(HWND hWnd, int cchMax)
{
	Edit_LimitText(hWnd, cchMax);
}
/**********************************************************************//**
 *
 * Ẽ}[Wݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd			= Ώۃnh
 * @param [in]	nLeftMargin		= ̃}[W
 * @param [in]	nRightMargin	= Ẽ}[W
 * @param [in]	uFlags			= ̗LtOB(EC_LEFTMARGIN, EC_RIGHTMARGIN)
*//***********************************************************************/
void	Edit_SetMargins(HWND hWnd, int nLeftMargin, int nRightMargin, UINT uFlags)
{
	SendMessage(hWnd, EM_SETMARGINS, (WPARAM)uFlags, MAKELPARAM(nLeftMargin,nRightMargin));
}
/**********************************************************************//**
 *
 * ɃXN[
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۃnh
 * @param [in]	uScroll		= XN[tO(SB_***)
*//***********************************************************************/
void	Edit_VScroll(HWND hWnd, UINT uScroll)
{
	SendMessage(hWnd, EM_SCROLL, (WPARAM)uScroll, 0);
}


//======================================================================
// class
// CEditBox
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CEditBox::CEditBox(void)
{
}
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
*//***********************************************************************/
CEditBox::CEditBox(HWND hWnd)
: CSubClass(hWnd)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CEditBox::~CEditBox(void)
{
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CEditBox::Create( DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CWindow::Create(WC_EDIT
		, lpszWindowName
		, dwStyle
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}
/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CEditBox::Create( DWORD dwStyle
					 , LPCTSTR lpszWindowName
					 , int x, int y, int w, int h
					 , HWND hWndParent, UINT nID
					 , HINSTANCE hInstance
					 , void* pParam )
{
	return CreateWindow(WC_EDIT
		, lpszWindowName
		, dwStyle
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CEditBox::CreateEx( DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CWindow::CreateEx(dwExStyle
		, WC_EDIT
		, lpszWindowName
		, dwStyle
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}
/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CEditBox::CreateEx( DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CreateWindowEx(dwExStyle
		, WC_EDIT
		, lpszWindowName
		, dwStyle
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 *
 * Iڂ̊JnƏÏʒu̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	rFirst	= Jnʒu
 * @param [out]	rLast	= Iʒu
*//***********************************************************************/
void CEditBox::GetSel(LONG& rFirst, LONG& rLast)
{
	DWORD ret = GetSel();
	rFirst	= LOWORD(ret);
	rLast	= HIWORD(ret);
}

/**********************************************************************//*
 *
 * bp[֐
 *
*//***********************************************************************/
BOOL		CEditBox::CanUndo(void)														{ return Edit_CanUndo(m_hWnd); }
DWORD		CEditBox::CharFormPos(int cx, int cy)										{ return Edit_CharFormPos(m_hWnd, cx, cy); }
BOOL		CEditBox::CharFormPos(int cx, int cy, int& rCharIndex, int& rLineIndex)		{ return Edit_CharFormPos(m_hWnd, cx, cy, rCharIndex, rLineIndex); }
void		CEditBox::EmptyUndoBuffer(void)												{ Edit_EmptyUndoBuffer(m_hWnd); }
BOOL		CEditBox::FmtLines(BOOL bAddEOL)											{ return Edit_FmtLines(m_hWnd, bAddEOL); }
int			CEditBox::GetFirstVisibleLine(void)											{ return Edit_GetFirstVisibleLine(m_hWnd); }
HLOCAL		CEditBox::GetHandle(void)													{ return Edit_GetHandle(m_hWnd); }
LRESULT		CEditBox::GetIMEStatus(WPARAM wParam)										{ return Edit_GetIMEStatus(m_hWnd, wParam); }
int			CEditBox::GetLimitText(void)												{ return Edit_GetLimitText(m_hWnd); }
int			CEditBox::GetLine(int nLine, LPTSTR lpch, int cchMax)						{ return Edit_GetLine(m_hWnd, nLine, lpch, cchMax); }
int			CEditBox::GetLineCount(void)												{ return Edit_GetLineCount(m_hWnd); }
DWORD		CEditBox::GetMargins(void)													{ return Edit_GetMargins(m_hWnd); }
BOOL		CEditBox::GetMargins(int& rLeft, int& rRight)								{ return Edit_GetMargins(m_hWnd, rLeft, rRight); }
BOOL		CEditBox::GetModify(void)													{ return Edit_GetModify(m_hWnd); }
TCHAR		CEditBox::GetPasswordChar(void)												{ return Edit_GetPasswordChar(m_hWnd); }
void		CEditBox::GetRect(LPRECT lprc)												{ Edit_GetRect(m_hWnd, lprc); }
DWORD		CEditBox::GetSel(void)														{ return Edit_GetSel(m_hWnd); }
int			CEditBox::GetThumb(void)													{ return Edit_GetThumb(m_hWnd); }
EDITWORDBREAKPROC	CEditBox::GetWordBreakProc(void)									{ return Edit_GetWordBreakProc(m_hWnd); }
void		CEditBox::LimitText(int cchMax)												{ Edit_LimitText(m_hWnd, cchMax); }
int			CEditBox::LineFromChar(int ich)												{ return Edit_LineFromChar(m_hWnd, ich); }
int			CEditBox::LineIndex(int nLine)												{ return Edit_LineIndex(m_hWnd, nLine); }
int			CEditBox::LineLength(int nLine)												{ return Edit_LineLength(m_hWnd, nLine); }
void		CEditBox::LineScroll(int nVScroll, int nHScroll)							{ Edit_LineScroll(m_hWnd, nVScroll, nHScroll); }
DWORD		CEditBox::PosFromChar(int nCharIndex)										{ return Edit_PosFromChar(m_hWnd, nCharIndex); }
BOOL		CEditBox::PosFromChar(int nCharIndex, int& rX, int& rY)						{ return Edit_PosFromChar(m_hWnd, nCharIndex, rX, rY); }
void		CEditBox::ReplaceSel(LPCTSTR lpszReplace)									{ Edit_ReplaceSel(m_hWnd, lpszReplace); }
BOOL		CEditBox::ScrollCaret(void)													{ return Edit_ScrollCaret(m_hWnd); }
void		CEditBox::SetHandle(HLOCAL hLocal)											{ Edit_SetHandle(m_hWnd, hLocal); }
LRESULT		CEditBox::SetIMEStatus(WPARAM wParam, LPARAM lParam)						{ return Edit_SetIMEStatus(m_hWnd, wParam, lParam); }
void		CEditBox::SetLimitText(int cchMax)											{ Edit_SetLimitText(m_hWnd, cchMax); }
void		CEditBox::SetMargins(int nLeftMargin, int nRightMargin, UINT uFlags)		{ Edit_SetMargins(m_hWnd, nLeftMargin, nRightMargin, uFlags); }
void		CEditBox::SetModify(BOOL bModify)											{ Edit_SetModify(m_hWnd, bModify); }
void		CEditBox::SetPasswordChar(TCHAR ch)											{ Edit_SetPasswordChar(m_hWnd, ch); }
BOOL		CEditBox::SetReadOnly(BOOL bReadOnly)										{ return Edit_SetReadOnly(m_hWnd, bReadOnly); }
void		CEditBox::SetRect(const LPRECT lprc)										{ Edit_SetRect(m_hWnd, lprc); }
void		CEditBox::SetRectNoPaint(const LPRECT lprc)									{ Edit_SetRectNoPaint(m_hWnd, lprc); }
void		CEditBox::SetSel(LONG nStart, LONG nEnd)									{ Edit_SetSel(m_hWnd, nStart, nEnd); }
void		CEditBox::SetTabStops(int nTabs, LPINT lpTabs)								{ Edit_SetTabStops(m_hWnd, nTabs, lpTabs); }
void		CEditBox::SetWordBreakProc(EDITWORDBREAKPROC lpfnWordBreak)					{ Edit_SetWordBreakProc(m_hWnd, lpfnWordBreak); }
BOOL		CEditBox::Undo(void)														{ return Edit_Undo(m_hWnd); }
void		CEditBox::VScroll(UINT uScroll)												{ Edit_VScroll(m_hWnd, uScroll); }

}	// end of namespace wx
}	// end of namespace iris
