//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXIcon.h
 * @brief		nhx[XNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXIcon_H_
#define _IRIS_WXIcon_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris {
namespace wx
{

//======================================================================
// class
//! nhNX
class CIcon : public IIrisObject
{
protected:
	HICON	m_hIcon;			//!< ACRnh
public:
	// RXgN^
	CIcon(void);
	// RXgN^
	CIcon(HICON hIcon);

	/// fXgN^
	virtual ~CIcon(void);

	HICON				GetIcon(void)		{ return m_hIcon; }
			operator	HICON (void)		{ return GetIcon(); }
	HICON	operator	() (void)			{ return GetIcon(); }
	CIcon&	operator	= (HICON hIcon)		{ Attach(hIcon); return *this; }
	
public:
	// ֘At
	BOOL	Attach(HICON hIcon);
	// ֘At
	HICON	Detach(void);

public:
	// 폜
	BOOL	Destroy(void);

public:
	// 쐬
	BOOL	Create(HINSTANCE hInst, int nWidth, int nHeight, BYTE byPlanes, BYTE byBitsPixel, const BYTE* lpbANDbits, const BYTE* lpbXORbits);
	BOOL	CreateFromResource(PBYTE pResBits, DWORD dwResSize, DWORD dwVer=0x00030000);
	BOOL	CreateFromResourceEx(PBYTE pResBits, DWORD dwResSize, int w, int h, UINT uFlags, DWORD dwVer=0x00030000);
	BOOL	CreateIndirect(PICONINFO pIconInfo);
	// Rs[쐬
	BOOL	Copy(HICON hIcon);
	// 
	BOOL	Duplicate(HICON hIcon);
	// \[Xǂݍ
	BOOL	LoadIconA(HINSTANCE hInst, LPCSTR  lpIconName);
	BOOL	LoadIconW(HINSTANCE hInst, LPCWSTR lpIconName);
	// t@CǍ
	BOOL	ExtractIconA(HINSTANCE hInst, LPCSTR  lpExeFileName, UINT uIndex);
	BOOL	ExtractIconW(HINSTANCE hInst, LPCWSTR lpExeFileName, UINT uIndex);
	// t@CǍ
	BOOL	ExtractAssociatedIconA(HINSTANCE hInst, LPSTR  lpPath, LPWORD lpIcon);
	BOOL	ExtractAssociatedIconW(HINSTANCE hInst, LPWSTR lpPath, LPWORD lpIcon);

public:
	// ACR̎擾
	BOOL	GetInfo(PICONINFO pIconInfo);

public:
	// `
	BOOL	Draw(HDC hDC, int x, int y);
	BOOL	DrawEx(HDC hDC, int x, int y, int w, int h, HBRUSH hBrush, UINT diFlags);

private:
	// ACR쐬̓o^
	inline	BOOL	TryAttach(HICON hIcon)
	{
		if( Attach(hIcon) ) return TRUE;
		::DestroyIcon(hIcon);
		return FALSE;
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif
